/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriter;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jst.ProblemSeverity;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.core.ArgumentsParser;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.IHeadlessLauncherConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.impl.EVLauncherResult;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.impl.BaseReporter;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.util.FileOperator;

public class XMLReportGenerator {
    private static void generateTotalStatus(EVLauncherResult result, XmlStreamWriter xsw, IHeadlessLauncherConfigure conf) {
        xsw.writeStartElement("TotoalResult");
        XMLReportGenerator.createSingleElement(xsw, "ValidatedFiles", "value", String.valueOf(conf.getValidatedJSFiles().size()), "Total number of files while validating");
        XMLReportGenerator.createSingleElement(xsw, "TotalErrors", "value", String.valueOf(result.getErrorNumber()), "Total number of erors in whole vjetv operation");
        XMLReportGenerator.createSingleElement(xsw, "TotalWarnings", "value", String.valueOf(result.getWarningNumber()), "Total number of warnings in whole vjetv operation");
        XMLReportGenerator.createSingleElement(xsw, "StartTime", "value", String.valueOf(result.getStartTime()), null);
        XMLReportGenerator.createSingleElement(xsw, "EndTime", "value", String.valueOf(result.getEndTime()), null);
        xsw.writeEndElement();
    }

    private static void generateFiles(EVLauncherResult result, XmlStreamWriter xsw, String reportLevel) {
        HashMap data = result.getReportData();
        if (data == null) {
            return;
        }
        Set collections = data.keySet();
        File file2 = null;
        Object value = null;
        xsw.writeStartElement("data");
        xsw.writeComment("Problems detail metadata");
        for (File file2 : collections) {
            value = data.get(file2);
            xsw.writeStartElement("ValidatedFiles");
            xsw.writeAttribute("Location", file2.getAbsolutePath());
            if (value instanceof List) {
                XMLReportGenerator.generateValidatedFileWtihProblems((List)value, xsw, file2, reportLevel);
            } else {
                XMLReportGenerator.generateValidatedFileWtihException(value.toString(), xsw, file2);
            }
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    private static void generateValidatedFileWtihProblems(List<VjoSemanticProblem> actualProblemList, XmlStreamWriter xsw, File validatedFile, String reportLevel) {
        String sources = FileOperator.getSourceFromFile(validatedFile);
        Collections.sort(actualProblemList, BaseReporter.COMPARATOR);
        for (VjoSemanticProblem vjoSemanticProblem : actualProblemList) {
            if (vjoSemanticProblem.type().equals((Object)ProblemSeverity.warning) && "ERROR".equalsIgnoreCase(reportLevel)) continue;
            XMLReportGenerator.generateProblem(vjoSemanticProblem, xsw, sources);
        }
    }

    private static void generateValidatedFileWtihException(String exceptionMessages, XmlStreamWriter xsw, File validatedFile) {
        XMLReportGenerator.createSingleElement(xsw, "Exception", null, exceptionMessages, "Exception when launching vjetv");
    }

    private static void generateProblem(VjoSemanticProblem problem, XmlStreamWriter xsw, String sources) {
        xsw.writeStartElement(problem.type().toString());
        XMLReportGenerator.createSingleElement(xsw, "id", null, problem.getID().getName(), "Problem ID");
        XMLReportGenerator.createSingleElement(xsw, "LineNumber", null, String.valueOf(problem.getSourceLineNumber()), null);
        XMLReportGenerator.createSingleElement(xsw, "SourceCodes", null, FileOperator.getSourceLineFromFile(sources, problem.getSourceStart(), problem.getSourceEnd() + 1).trim(), null);
        XMLReportGenerator.createSingleElement(xsw, "Messages", null, problem.getMessage().trim(), null);
        XMLReportGenerator.createSingleElement(xsw, "StartPosition", null, String.valueOf(problem.getSourceStart()), null);
        XMLReportGenerator.createSingleElement(xsw, "EndPosition", null, String.valueOf(problem.getSourceEnd()), null);
        xsw.writeEndElement();
    }

    private static void createSingleElement(XmlStreamWriter xsw, String elementName, String attributeName, String value, String comment) {
        xsw.writeStartElement(elementName);
        if (attributeName != null) {
            xsw.writeAttribute(attributeName, value);
        } else {
            xsw.writeAttribute("value", value);
        }
        if (comment != null) {
            xsw.writeComment(comment);
        }
        xsw.writeEndElement();
    }

    private static void generateStartInformation(XmlStreamWriter xsw) {
        xsw.writeRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xsw.writeComment("Ebay vjet validation Result reporter");
    }

    public static void generateXMLFile(IHeadlessLauncherConfigure conf, EVLauncherResult result) {
        String reportLevel = conf.getReportLevel();
        File reportedFile = new File(conf.getReportPath());
        try {
            if (ArgumentsParser.isPathValid(reportedFile.getAbsolutePath(), false) && reportedFile.isDirectory()) {
                reportedFile = new File(String.valueOf(reportedFile.getPath()) + File.separatorChar + "VjoValidation.xml");
            }
            FileWriter fw = new FileWriter(reportedFile);
            XmlStreamWriter xsw = new XmlStreamWriter((Writer)fw);
            XMLReportGenerator.generateStartInformation(xsw);
            xsw.writeStartElement("Report");
            xsw.writeComment("Overall statistics for vjetv results");
            XMLReportGenerator.generateTotalStatus(result, xsw, conf);
            XMLReportGenerator.generateFiles(result, xsw, reportLevel);
            xsw.writeEndElement();
            xsw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

