/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;

public class VjoSourceHelper {
    public static void getAllSourceModulesFromJst(List<ISourceModule> selectedSourceModules, List<IJstType> jstTypes, ScriptProject scriptProject) {
        for (IJstType type : jstTypes) {
            ISourceModule sourceModule;
            IType found = CodeassistUtils.findType(scriptProject, type);
            if (found == null || !(found instanceof VjoSourceType) || !((sourceModule = ((VjoSourceType)found).getSourceModule()) instanceof VjoSourceModule)) continue;
            selectedSourceModules.add(sourceModule);
        }
    }

    public static void getAllSourceModulesFromProject(List<ISourceModule> selectedSourceModules, ScriptProject sp) {
        try {
            IModelElement[] frags = sp.getChildren();
            VjoSourceHelper.getChildrenFromFragment(selectedSourceModules, frags, sp);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
    }

    public static void getChildrenFromFragment(List<ISourceModule> resourceList, IModelElement[] element, ScriptProject sProject) throws ModelException {
        IResource resource = null;
        IModelElement[] iModelElementArray = element;
        int n = element.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement[] elements;
            IModelElement pf = iModelElementArray[n2];
            IModelElement[] iModelElementArray2 = elements = ((ModelElement)pf).getChildren();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IModelElement[] files;
                IModelElement modelElement = iModelElementArray2[n4];
                IModelElement[] iModelElementArray3 = files = ((ModelElement)modelElement).getChildren();
                int n5 = files.length;
                int n6 = 0;
                while (n6 < n5) {
                    IModelElement file = iModelElementArray3[n6];
                    if (file.getElementType() == 5 && (resource = file.getResource()) != null && resource.getLocation().toOSString().endsWith(".js")) {
                        VjoSourceHelper.addSourceModules(resourceList, resource, sProject);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void addSourceModules(List<ISourceModule> selectedSourceModules, IResource selectionElement, ScriptProject sProject) {
        ISourceModule module = null;
        if (!selectedSourceModules.contains(selectionElement) && (module = VjoSourceHelper.getModuleFromResource(selectionElement, sProject)) != null && module.getElementType() == 5) {
            selectedSourceModules.add(module);
        }
    }

    public static ISourceModule getModuleFromResource(IResource selectionElement, ScriptProject sProject) {
        SourceTypeName typeName = null;
        ISourceModule module = null;
        IType type = null;
        typeName = VjoSourceHelper.getFileQulifieName(selectionElement);
        if (typeName != null && (type = CodeassistUtils.findType(sProject, typeName.typeName())) != null) {
            module = type.getSourceModule();
        }
        return module;
    }

    public static SourceTypeName getFileQulifieName(IResource resource) {
        if (resource instanceof IFile && resource.getLocation().toOSString().endsWith(".js")) {
            return CodeassistUtils.getTypeName(resource);
        }
        return null;
    }
}

