/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.compiler.ISourceElementRequestor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.IJSModelElementInfo;
import org.eclipse.dltk.mod.internal.core.IJSSourceRefModelElementInfo;
import org.eclipse.dltk.mod.internal.core.ImportContainer;
import org.eclipse.dltk.mod.internal.core.ImportDeclaration;
import org.eclipse.dltk.mod.internal.core.ImportDeclarationElementInfo;
import org.eclipse.dltk.mod.internal.core.JSInitializer;
import org.eclipse.dltk.mod.internal.core.JSInitializerElementInfo;
import org.eclipse.dltk.mod.internal.core.JSModelElementInfo;
import org.eclipse.dltk.mod.internal.core.JSPackageDeclaration;
import org.eclipse.dltk.mod.internal.core.JSSourceField;
import org.eclipse.dltk.mod.internal.core.JSSourceFieldElementInfo;
import org.eclipse.dltk.mod.internal.core.JSSourceMethod;
import org.eclipse.dltk.mod.internal.core.JSSourceMethodElementInfo;
import org.eclipse.dltk.mod.internal.core.JSSourceModuleElementInfo;
import org.eclipse.dltk.mod.internal.core.JSSourceRefElementInfo;
import org.eclipse.dltk.mod.internal.core.JSSourceTypeElementInfo;
import org.eclipse.dltk.mod.internal.core.JSTypeParameter;
import org.eclipse.dltk.mod.internal.core.JSTypeParameterElementInfo;
import org.eclipse.dltk.mod.internal.core.MemberElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.SourceRefElement;
import org.eclipse.dltk.mod.internal.core.SourceType;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.vjet.eclipse.compiler.IJSSourceElementRequestor;
import org.eclipse.vjet.eclipse.core.IJSSourceModule;
import org.eclipse.vjet.eclipse.core.IJSTypeParameter;

public class VjoSourceModuleStructureRequestor
implements IJSSourceElementRequestor {
    private static final String[] EMPTY = new String[0];
    protected HashMap m_children;
    private Stack m_handleStack;
    protected boolean m_hasSyntaxErrors = false;
    protected JSModelElementInfo m_importContainerInfo;
    private Stack m_infoStack;
    private ISourceModule m_module;
    private JSSourceModuleElementInfo m_moduleInfo;
    private Map m_newElements;

    public VjoSourceModuleStructureRequestor(ISourceModule module, JSSourceModuleElementInfo moduleInfo, Map newElements) {
        this.m_module = module;
        this.m_moduleInfo = moduleInfo;
        this.m_newElements = newElements;
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
    }

    @Override
    public void acceptImport(int declarationStart, int declarationEnd, char[][] tokens, boolean onDemand, int modifiers) {
        ModelElement parentHandle = (ModelElement)this.m_handleStack.peek();
        if (parentHandle.getElementType() != 5) {
            Assert.isTrue((boolean)false);
        }
        IJSSourceModule parentCU = (IJSSourceModule)parentHandle;
        ImportContainer importContainer = (ImportContainer)parentCU.getImportContainer();
        if (this.m_importContainerInfo == null) {
            this.m_importContainerInfo = new JSModelElementInfo();
            IJSModelElementInfo parentInfo = (IJSModelElementInfo)this.m_infoStack.peek();
            parentInfo.addChild((IModelElement)importContainer);
            this.m_newElements.put(importContainer, this.m_importContainerInfo);
        }
        String elementName = ModelManager.getModelManager().intern(new String(CharOperation.concatWith((char[][])tokens, (char)'.')));
        ImportDeclaration handle = new ImportDeclaration(importContainer, elementName, onDemand);
        this.resolveDuplicates((SourceRefElement)handle);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        info.setFlags(modifiers);
        this.m_importContainerInfo.addChild((IModelElement)handle);
        this.m_newElements.put(handle, info);
    }

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition, int sourceEndPosition) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        IJSModelElementInfo parentInfo = (IJSModelElementInfo)this.m_infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.m_handleStack.peek();
        JSPackageDeclaration handle = null;
        handle = new JSPackageDeclaration(parentHandle, new String(name));
        this.resolveDuplicates((SourceRefElement)handle);
        JSSourceRefElementInfo info = new JSSourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        parentInfo.addChild((IModelElement)handle);
        this.m_newElements.put(handle, info);
    }

    public void acceptTypeReference(char[] typeName, int sourcePosition) {
    }

    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
    }

    private void addToChildren(ModelElementInfo parentInfo, ModelElement handle) {
        ArrayList<ModelElement> childrenList = (ArrayList<ModelElement>)this.m_children.get(parentInfo);
        if (childrenList == null) {
            childrenList = new ArrayList<ModelElement>();
            this.m_children.put(parentInfo, childrenList);
        }
        childrenList.add(handle);
    }

    private void createField(ISourceElementRequestor.FieldInfo fieldInfo, MemberElementInfo parentInfo, ModelElement parentHandle) {
        ModelManager manager = ModelManager.getModelManager();
        IJSSourceElementRequestor.JSFieldInfo jsFieldInfo = (IJSSourceElementRequestor.JSFieldInfo)fieldInfo;
        JSSourceField handle = new JSSourceField(parentHandle, manager.intern(fieldInfo.name));
        this.resolveDuplicates((SourceRefElement)handle);
        handle.setResource(jsFieldInfo.resource);
        JSSourceFieldElementInfo info = new JSSourceFieldElementInfo();
        info.setNameSourceStart(fieldInfo.nameSourceStart);
        info.setNameSourceEnd(fieldInfo.nameSourceEnd);
        info.setSourceRangeStart(fieldInfo.declarationStart);
        info.setFlags(fieldInfo.modifiers);
        info.setType(jsFieldInfo.m_type);
        info.setInitializationSource(jsFieldInfo.m_initializationSource);
        parentInfo.addChild((IModelElement)handle);
        this.m_newElements.put(handle, info);
        this.m_infoStack.push(info);
        this.m_handleStack.push(handle);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        MemberElementInfo parentInfo = (MemberElementInfo)this.m_infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.m_handleStack.peek();
        this.createField(fieldInfo, parentInfo, parentHandle);
    }

    public boolean enterFieldCheckDuplicates(ISourceElementRequestor.FieldInfo fieldInfo) {
        return false;
    }

    public boolean enterFieldWithParentType(ISourceElementRequestor.FieldInfo info, String parentName, String delimiter) {
        return false;
    }

    @Override
    public void enterInitializer(int declarationSourceStart, int modifiers) {
        MemberElementInfo parentInfo = (MemberElementInfo)this.m_infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.m_handleStack.peek();
        JSInitializer handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = new JSInitializer(parentHandle, 1);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates((SourceRefElement)handle);
        JSInitializerElementInfo info = new JSInitializerElementInfo();
        info.setSourceRangeStart(declarationSourceStart);
        info.setFlags(modifiers);
        parentInfo.addChild((IModelElement)handle);
        this.m_newElements.put(handle, info);
        this.m_infoStack.push(info);
        this.m_handleStack.push(handle);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        IJSModelElementInfo parentInfo = (IJSModelElementInfo)this.m_infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.m_handleStack.peek();
        this.processMethod(methodInfo, parentInfo, parentHandle);
    }

    public void enterMethodRemoveSame(ISourceElementRequestor.MethodInfo methodInfo) {
        IJSModelElementInfo parentInfo = (IJSModelElementInfo)this.m_infoStack.peek();
        IModelElement[] childrens = parentInfo.getChildren();
        int i = 0;
        while (i < childrens.length) {
            if (childrens[i].getElementName().equals(methodInfo.name)) {
                parentInfo.removeChild(childrens[i]);
            }
            ++i;
        }
        this.enterMethod(methodInfo);
    }

    public boolean enterMethodWithParentType(ISourceElementRequestor.MethodInfo info, String parentName, String delimiter) {
        SourceType element;
        block5: {
            element = this.getExistentType(parentName, delimiter);
            if (element != null) break block5;
            return false;
        }
        try {
            IJSModelElementInfo typeInfo = (IJSModelElementInfo)element.getElementInfo();
            IModelElement[] childrens = typeInfo.getChildren();
            int i = 0;
            while (i < childrens.length) {
                if (childrens[i].getElementName().equals(info.name)) {
                    typeInfo.removeChild(childrens[i]);
                }
                ++i;
            }
            this.processMethod(info, typeInfo, (ModelElement)element);
            return true;
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
            return false;
        }
    }

    public void enterModule() {
        this.m_infoStack = new Stack();
        this.m_handleStack = new Stack();
        this.m_children = new HashMap();
        this.enterModuleRoot();
    }

    public void enterModuleRoot() {
        this.m_infoStack.push(this.m_moduleInfo);
        this.m_handleStack.push(this.m_module);
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        IJSModelElementInfo parentInfo = (IJSModelElementInfo)this.m_infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.m_handleStack.peek();
        this.processType(typeInfo, parentInfo, parentHandle);
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        SourceType element;
        block3: {
            try {
                element = this.getExistentType(fullName, delimiter);
                if (element != null) break block3;
                return false;
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
                return false;
            }
        }
        IJSModelElementInfo info = (IJSModelElementInfo)element.getElementInfo();
        this.m_infoStack.push(info);
        this.m_handleStack.push(element);
        return true;
    }

    public void enterTypeParameter(IJSSourceElementRequestor.JSTypeParameterInfo typeParameterInfo) {
        IJSModelElementInfo parentInfo = (IJSModelElementInfo)this.m_infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.m_handleStack.peek();
        String nameString = new String(typeParameterInfo.name);
        JSTypeParameter handle = new JSTypeParameter(parentHandle, nameString);
        this.resolveDuplicates((SourceRefElement)handle);
        JSTypeParameterElementInfo info = new JSTypeParameterElementInfo();
        info.setSourceRangeStart(typeParameterInfo.declarationStart);
        info.m_nameStart = typeParameterInfo.nameSourceStart;
        info.m_nameEnd = typeParameterInfo.nameSourceEnd;
        info.m_bounds = typeParameterInfo.m_bounds;
        if (parentInfo instanceof JSSourceTypeElementInfo) {
            JSSourceTypeElementInfo elementInfo = (JSSourceTypeElementInfo)parentInfo;
            IJSTypeParameter[] typeParameters = elementInfo.m_typeParameters;
            int length = typeParameters.length;
            IJSTypeParameter[] iJSTypeParameterArray = typeParameters;
            typeParameters = new IJSTypeParameter[length + 1];
            System.arraycopy(iJSTypeParameterArray, 0, typeParameters, 0, length);
            typeParameters[length] = handle;
            elementInfo.m_typeParameters = typeParameters;
        } else {
            JSSourceMethodElementInfo elementInfo = (JSSourceMethodElementInfo)parentInfo;
            IJSTypeParameter[] typeParameters = elementInfo.typeParameters;
            int length = typeParameters.length;
            IJSTypeParameter[] iJSTypeParameterArray = typeParameters;
            typeParameters = new IJSTypeParameter[length + 1];
            System.arraycopy(iJSTypeParameterArray, 0, typeParameters, 0, length);
            typeParameters[length] = handle;
            elementInfo.typeParameters = typeParameters;
        }
        this.m_newElements.put(handle, info);
        this.m_infoStack.push(info);
        this.m_handleStack.push(handle);
    }

    public void exitField(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    @Override
    public void exitInitializer(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        Object object = this.m_infoStack.pop();
        IJSSourceRefModelElementInfo info = (IJSSourceRefModelElementInfo)object;
        info.setSourceRangeEnd(declarationEnd);
        this.m_handleStack.pop();
    }

    public void exitMethod(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitModule(int declarationEnd) {
        this.m_moduleInfo.setSourceLength(declarationEnd + 1);
        this.m_moduleInfo.setIsStructureKnown(!this.m_hasSyntaxErrors);
    }

    public void exitModuleRoot() {
        this.m_infoStack.pop();
        this.m_handleStack.pop();
    }

    public void exitType(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    private SourceType findTypeFrom(IModelElement[] children, String name, String parentName, String delimiter) {
        try {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof SourceType) {
                    SourceType type = (SourceType)children[i];
                    String qname = String.valueOf(name) + delimiter + type.getElementName();
                    if (qname.equals(parentName)) {
                        return type;
                    }
                    SourceType val = this.findTypeFrom(type.getChildren(), qname, parentName, delimiter);
                    if (val != null) {
                        return val;
                    }
                }
                ++i;
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return null;
    }

    private SourceType getCurrentType() {
        SourceType t = null;
        for (Object o : this.m_handleStack) {
            if (!(o instanceof SourceType)) continue;
            t = (SourceType)o;
        }
        return t;
    }

    private SourceType getExistentType(String parentName, String delimiter) {
        try {
            SourceType element = null;
            if (parentName.startsWith(delimiter)) {
                element = this.findTypeFrom(this.m_module.getChildren(), "", parentName, delimiter);
                return element;
            }
            parentName = String.valueOf(delimiter) + parentName;
            SourceType enc = this.getCurrentType();
            element = enc == null ? this.findTypeFrom(this.m_module.getChildren(), "", parentName, delimiter) : this.findTypeFrom(enc.getChildren(), "", parentName, delimiter);
            return element;
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
            return null;
        }
    }

    private void processMethod(ISourceElementRequestor.MethodInfo methodInfo, IJSModelElementInfo parentInfo, ModelElement parentHandle) {
        String[] parameterInitializers;
        IJSSourceElementRequestor.JSMethodInfo jsMethodInfo = (IJSSourceElementRequestor.JSMethodInfo)methodInfo;
        if (jsMethodInfo.m_parameterTypes == null) {
            jsMethodInfo.m_parameterTypes = CharOperation.NO_STRINGS;
        }
        if (methodInfo.parameterNames == null) {
            methodInfo.parameterNames = CharOperation.NO_STRINGS;
        }
        if (methodInfo.exceptionTypes == null) {
            methodInfo.exceptionTypes = CharOperation.NO_STRINGS;
        }
        String nameString = methodInfo.name;
        ModelManager manager = ModelManager.getModelManager();
        JSSourceMethod handle = null;
        if (parentHandle.getElementType() == 7 || parentHandle.getElementType() == 11) {
            if (parentHandle.getElementType() == 11) {
                parentHandle = (ModelElement)parentHandle.getParent();
            }
            handle = new JSSourceMethod(parentHandle, manager.intern(nameString), jsMethodInfo.m_parameterTypes);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates((SourceRefElement)handle);
        handle.setResource(jsMethodInfo.resource);
        JSSourceMethodElementInfo info = new JSSourceMethodElementInfo();
        info.setConstructor(jsMethodInfo.m_isConstructor);
        info.setSourceRangeStart(methodInfo.nameSourceStart);
        info.setFlags(methodInfo.modifiers);
        info.setNameSourceStart(methodInfo.nameSourceStart);
        info.setNameSourceEnd(methodInfo.nameSourceEnd);
        String[] parameterNames = methodInfo.parameterNames == null ? EMPTY : methodInfo.parameterNames;
        String[] stringArray = parameterInitializers = methodInfo.parameterInitializers == null ? EMPTY : methodInfo.parameterInitializers;
        if (parameterNames.length != parameterInitializers.length) {
            parameterInitializers = new String[parameterNames.length];
        }
        int i = 0;
        int length = parameterNames.length;
        while (i < length) {
            if (parameterNames[i] == null) {
                parameterNames[i] = "";
            }
            if (parameterInitializers[i] != null) {
                parameterInitializers[i] = manager.intern(parameterInitializers[i]);
            }
            ++i;
        }
        info.setArgumentNames(parameterNames);
        info.setArgumentInializers(parameterInitializers);
        info.setReturnType(manager.intern(jsMethodInfo.m_returnType).toCharArray());
        info.setIsVariables(jsMethodInfo.b_isVariables);
        parentInfo.addChild((IModelElement)handle);
        this.m_newElements.put(handle, info);
        this.m_infoStack.push(info);
        this.m_handleStack.push(handle);
        if (jsMethodInfo.m_typeParameters != null) {
            i = 0;
            length = jsMethodInfo.m_typeParameters.length;
            while (i < length) {
                IJSSourceElementRequestor.JSTypeParameterInfo typeParameterInfo = jsMethodInfo.m_typeParameters[i];
                this.enterTypeParameter(typeParameterInfo);
                ++i;
            }
        }
    }

    private void processType(ISourceElementRequestor.TypeInfo typeInfo, IJSModelElementInfo parentInfo, ModelElement parentHandle) {
        String nameString = typeInfo.name;
        IJSSourceElementRequestor.JSTypeInfo jsTypeInfo = (IJSSourceElementRequestor.JSTypeInfo)typeInfo;
        VjoSourceType handle = new VjoSourceType(parentHandle, nameString);
        this.resolveDuplicates((SourceRefElement)handle);
        JSSourceTypeElementInfo info = new JSSourceTypeElementInfo();
        info.setHandle((IType)handle);
        info.setSourceRangeStart(typeInfo.declarationStart);
        info.setFlags(typeInfo.modifiers);
        info.setNameSourceStart(typeInfo.nameSourceStart);
        info.setNameSourceEnd(typeInfo.nameSourceEnd);
        ModelManager manager = ModelManager.getModelManager();
        String[] superclasses = typeInfo.superclasses;
        int i = 0;
        int length = superclasses == null ? 0 : superclasses.length;
        while (i < length) {
            superclasses[i] = manager.intern(superclasses[i]);
            ++i;
        }
        info.setSuperclassNames(superclasses);
        String[] superinterfaceses = jsTypeInfo.superinterfaces;
        int i2 = 0;
        int length2 = superinterfaceses == null ? 0 : superinterfaceses.length;
        while (i2 < length2) {
            superinterfaceses[i2] = manager.intern(superinterfaceses[i2]);
            ++i2;
        }
        info.setSuperInterfaceNames(superinterfaceses);
        parentInfo.addChild((IModelElement)handle);
        this.m_newElements.put(handle, info);
        this.m_infoStack.push(info);
        this.m_handleStack.push(handle);
    }

    protected void resolveDuplicates(SourceRefElement handle) {
        while (this.m_newElements.containsKey(handle)) {
            ++handle.occurrenceCount;
        }
    }

    private void setChildren(IJSModelElementInfo info) {
        ArrayList childrenList = (ArrayList)this.m_children.get(info);
        if (childrenList != null) {
            int length = childrenList.size();
            IModelElement[] elements = new IModelElement[length];
            childrenList.toArray(elements);
            info.setChildren(elements);
        }
    }
}

