/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.List;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMatchFactory;

public class VjoFieldReferenceVistor
implements IJstVisitor {
    private IField field;
    private IJstNode searchNode;
    private List<VjoMatch> result;
    private boolean isMethodArgument;
    private boolean isLocalVar;
    private boolean isTypeProperty;

    public VjoFieldReferenceVistor(IField field, IJstNode searchNode, List<VjoMatch> result) {
        this.field = field;
        this.searchNode = searchNode;
        this.result = result;
        this.isMethodArgument = this.isMethodArgument();
        this.isLocalVar = this.isLocalVar();
        this.isTypeProperty = this.isTypeProperty();
    }

    public void endVisit(IJstNode node) {
    }

    public void postVisit(IJstNode node) {
    }

    public void preVisit(IJstNode node) {
    }

    public boolean visit(IJstNode node) {
        if (this.isMethodArgument && node instanceof JstIdentifier) {
            this.processMethodArgumentReference((JstIdentifier)node);
        }
        if (this.isLocalVar && node instanceof JstIdentifier) {
            this.processLocalVarReference((JstIdentifier)node);
        }
        if (this.isTypeProperty && node instanceof JstIdentifier) {
            this.processTypePropertyReference((JstIdentifier)node);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMethodArgument() {
        if (!(this.field.getParent() instanceof IMethod)) {
            return false;
        }
        try {
            IMethod method = (IMethod)this.field.getParent();
            String[] parameters = method.getParameters();
            int i = 0;
            while (true) {
                if (i >= parameters.length) {
                    return false;
                }
                if (this.field.getElementName().equals(parameters[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isLocalVar() {
        return this.field.getParent().getElementType() == 9;
    }

    private boolean isTypeProperty() {
        return this.field.getParent().getElementType() == 7;
    }

    private void processMethodArgumentReference(JstIdentifier jstIdentifier) {
        String argName;
        if (jstIdentifier.getJstBinding() instanceof JstArg && (argName = jstIdentifier.getName()).equals(this.field.getElementName())) {
            this.createMatch((IJstNode)jstIdentifier);
        }
    }

    private void processLocalVarReference(JstIdentifier jstIdentifier) {
        String varName;
        if (jstIdentifier.getJstBinding() instanceof JstVars && (varName = jstIdentifier.getName()).equals(this.field.getElementName())) {
            this.createMatch((IJstNode)jstIdentifier);
        }
    }

    private void processTypePropertyReference(JstIdentifier jstIdentifier) {
        this.createMatch((IJstNode)jstIdentifier);
    }

    private void createMatch(IJstNode jstNode) {
        IType dltkType = CodeassistUtils.findType(this.searchNode.getRootType());
        if (dltkType == null) {
            return;
        }
        JstSource jstSource = jstNode.getSource();
        IType declareType = CodeassistUtils.findType((ScriptProject)dltkType.getScriptProject(), this.field.getDeclaringType().getFullyQualifiedName());
        if (declareType == null) {
            return;
        }
        VjoMatch match = VjoMatchFactory.createTypeMatch(dltkType, jstSource.getStartOffSet(), jstSource.getLength());
        try {
            try {
                match.setIsPublic(Flags.isPublic((int)this.field.getFlags()));
                match.setIsStatic(Flags.isStatic((int)this.field.getFlags()));
            }
            catch (ModelException e) {
                e.printStackTrace();
                this.result.add(match);
            }
        }
        finally {
            this.result.add(match);
        }
    }
}

