/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.List;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.internal.core.JSSourceMethod;
import org.eclipse.dltk.mod.internal.core.NativeVjoSourceModule;
import org.eclipse.dltk.mod.internal.core.search.matching.MethodPattern;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.ts.method.MethodName;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.search.AbstractVjoElementSearcher;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMatchFactory;
import org.eclipse.vjet.eclipse.core.search.VjoMehtodOccurrenceVisitor;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoMethodSearcher
extends AbstractVjoElementSearcher {
    private static final String ENCLOSING_TYPE_SEPARATOR = ".";

    @Override
    public Class<? extends SearchPattern> getSearchPatternClass() {
        return MethodPattern.class;
    }

    @Override
    protected void searchDeclarations(SearchQueryParameters params, List<VjoMatch> result) {
        TypeName typeName;
        JSSourceMethod method = (JSSourceMethod)params.getElement();
        IVjoSourceModule module = (IVjoSourceModule)method.getSourceModule();
        IType type = CodeassistUtils.findType(module, (typeName = module.getTypeName()).typeName());
        if (this.isInScope(type)) {
            try {
                ISourceRange nameRange = method.getNameRange();
                VjoMatch match = VjoMatchFactory.createMethodMatch(type, nameRange.getOffset(), nameRange.getLength());
                try {
                    match.setIsPublic(Flags.isPublic((int)method.getFlags()));
                    match.setIsStatic(Flags.isStatic((int)method.getFlags()));
                }
                catch (ModelException modelException) {}
                result.add(match);
            }
            catch (ModelException modelException) {}
        }
    }

    @Override
    protected void searchReferences(SearchQueryParameters params, List<VjoMatch> result) {
        IMethod method = (IMethod)params.getElement();
        if (method.getSourceModule() instanceof NativeVjoSourceModule) {
            this.processNativeMethodReference(method, result);
        } else {
            this.processSourceMethodReference(method, result);
        }
    }

    private void processSourceMethodReference(IMethod method, List<VjoMatch> result) {
        String dltkTypeName;
        IVjoSourceModule module = (IVjoSourceModule)method.getSourceModule();
        IJstType jstType = TypeSpaceMgr.findType((String)module.getTypeName().groupName(), (String)module.getTypeName().typeName());
        IJstMethod jstMethod = this.getJstMethod(jstType, dltkTypeName = ((IType)method.getParent()).getFullyQualifiedName(ENCLOSING_TYPE_SEPARATOR), method.getElementName(), true);
        if (jstMethod == null) {
            return;
        }
        String grouName = jstMethod.getOwnerType().getPackage().getGroupName();
        String typeName = jstMethod.getOwnerType().getName();
        MethodName methodName = new MethodName(new TypeName(grouName, typeName), method.getElementName());
        List list = this.mgr.getMethodDependents(methodName);
        for (IJstNode jstNode : list) {
            this.createMatch(jstNode, method, result);
        }
    }

    private void processNativeMethodReference(IMethod method, List<VjoMatch> result) {
        NativeVjoSourceModule nativeVjoSourceModule = (NativeVjoSourceModule)method.getSourceModule();
        String groupName = nativeVjoSourceModule.getTypeName().groupName();
        String typeName = nativeVjoSourceModule.getJstType().getName();
        method.getParent();
        MethodName methodNameTest = new MethodName(new TypeName(groupName, typeName), method.getElementName());
        List list = this.mgr.getMethodDependents(methodNameTest);
        for (IJstNode jstNode : list) {
            this.createMatch(jstNode, method, result);
        }
    }

    private IJstMethod getJstMethod(IJstType type, String typeName, String methodName, boolean alias) {
        if (type == null) {
            return null;
        }
        if (alias || !alias && type.getName().equals(typeName)) {
            IJstGlobalVar gvar;
            IJstMethod jstMethod = type.getMethod(methodName);
            if (jstMethod == null && "constructs".equals(methodName)) {
                jstMethod = type.getConstructor();
            }
            if (jstMethod == null && (gvar = type.getGlobalVar(methodName)) != null) {
                jstMethod = gvar.getFunction();
            }
            return jstMethod;
        }
        for (IJstType innerType : type.getEmbededTypes()) {
            IJstMethod jstMethod = this.getJstMethod(innerType, typeName, methodName, alias);
            if (jstMethod == null) continue;
            return jstMethod;
        }
        return null;
    }

    private void createMatch(IJstNode jstNode, IMethod method, List<VjoMatch> result) {
        IType dltkType = CodeassistUtils.findType(jstNode.getRootType());
        if (dltkType == null) {
            return;
        }
        JstSource jstSource = jstNode.getSource();
        int length = jstSource.getEndOffSet() - jstSource.getStartOffSet() + 1;
        VjoMatch match = VjoMatchFactory.createTypeMatch(dltkType, jstSource.getStartOffSet(), length);
        result.add(match);
    }

    private boolean isValidNode(IJstNode node) {
        IJstMethod jstMethod = CodeassistUtils.findDeclaringMethod(node);
        if (jstMethod == null) {
            return true;
        }
        if (jstMethod.isConstructor()) {
            return jstMethod.getOwnerType().getConstructor() != null;
        }
        IJstMethod validJstMethod = jstMethod.getOwnerType().getMethod(jstMethod.getName().getName());
        return validJstMethod != null;
    }

    @Override
    public List<VjoMatch> findOccurrence(IJstNode searchedJstNode, IJstNode searchedTree) {
        if (searchedJstNode.getParentNode() instanceof IJstMethod) {
            searchedJstNode = (IJstMethod)searchedJstNode.getParentNode();
        }
        VjoMehtodOccurrenceVisitor visitor = new VjoMehtodOccurrenceVisitor((IJstMethod)searchedJstNode);
        searchedTree.accept((IJstNodeVisitor)visitor);
        return visitor.getMatches();
    }
}

