/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.validation.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.vjet.eclipse.core.validation.AbstractValidator;
import org.eclipse.vjet.eclipse.core.validation.IValidator;
import org.eclipse.vjet.eclipse.core.validation.PersistablePreferenceObjectSupport;

public class ValidatorDefinition
extends PersistablePreferenceObjectSupport {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabledByDefault";
    private static final String ENABLEMENT_PREFIX = "validator.enable.";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ORDER_ATTRIBUTE = "order";
    private String description;
    private String iconUri;
    private String id;
    private String name;
    private String namespaceUri;
    private int order;
    private IValidator validator;

    public ValidatorDefinition(IConfigurationElement element) throws CoreException {
        this.init(element);
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public String getID() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    protected String getPreferenceId() {
        return ENABLEMENT_PREFIX + this.id;
    }

    public IValidator getValidator() {
        return this.validator;
    }

    private void init(IConfigurationElement element) throws CoreException {
        Object executable = element.createExecutableExtension(CLASS_ATTRIBUTE);
        if (executable instanceof IValidator) {
            this.validator = (IValidator)executable;
        }
        this.id = String.valueOf(element.getContributor().getName()) + "." + element.getAttribute(ID_ATTRIBUTE);
        this.name = element.getAttribute(NAME_ATTRIBUTE);
        this.description = element.getAttribute(DESCRIPTION_ATTRIBUTE);
        this.iconUri = element.getAttribute(ICON_ATTRIBUTE);
        this.initValidator();
    }

    private void initValidator() {
        if (this.validator instanceof AbstractValidator) {
            ((AbstractValidator)this.validator).setValidatorId(this.id);
        }
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.validator.getClass().getName() + ")";
    }
}

