/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.formatter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mod.wst.jsdt.core.compiler.IScanner;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.mod.wst.jsdt.internal.core.util.PublicScanner;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.formatter.CodeFormatter;
import org.eclipse.vjet.eclipse.internal.formatter.DefaultCodeFormatter;

public class JSFormatterFactory {
    public static final int M_FORMAT_NEW = new Integer(0);
    public static final int M_FORMAT_EXISTING = new Integer(1);

    public static CodeFormatter createCodeFormatter(Map options) {
        return JSFormatterFactory.createCodeFormatter(options, M_FORMAT_NEW);
    }

    public static CodeFormatter createCodeFormatter(Map options, int mode) {
        if (options == null) {
            options = VjetPlugin.getOptions();
        }
        HashMap<String, String> currentOptions = new HashMap<String, String>(options);
        if (mode == M_FORMAT_NEW) {
            currentOptions.put("org.eclipse.vjet.eclipse.core.formatter.never_indent_block_comments_on_first_column", "false");
            currentOptions.put("org.eclipse.vjet.eclipse.core.formatter.never_indent_line_comments_on_first_column", "false");
        }
        return new DefaultCodeFormatter(currentOptions);
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, assertMode ? 0x300000L : 0x2F0000L, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel) {
        PublicScanner scanner = null;
        long level = CompilerOptions.versionToJdkLevel((Object)sourceLevel);
        if (level == 0L) {
            level = 0x2F0000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, level, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel, String complianceLevel) {
        long complianceLevelValue;
        PublicScanner scanner = null;
        long sourceLevelValue = CompilerOptions.versionToJdkLevel((Object)sourceLevel);
        if (sourceLevelValue == 0L) {
            sourceLevelValue = 0x2F0000L;
        }
        if ((complianceLevelValue = CompilerOptions.versionToJdkLevel((Object)complianceLevel)) == 0L) {
            complianceLevelValue = 0x2F0000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, sourceLevelValue, complianceLevelValue, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }
}

