/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.codeassist.select;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.mod.codeassist.IAssistParser;
import org.eclipse.dltk.mod.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.internal.codeassist.select.JstNodeDLTKElementResolver;
import org.eclipse.vjet.eclipse.internal.codeassist.select.SelectionParser;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoSelectionEngine
extends ScriptSelectionEngine {
    private SelectionParser m_parser = new SelectionParser();

    public IModelElement[] convert(IVjoSourceModule module, IJstNode jstNode) {
        return JstNodeDLTKElementResolver.convert(module, jstNode);
    }

    public IJstNode convertSelection2JstNode(ISourceModule module, int startOffset, int endOffset) {
        IVjoSourceModule sourceModule = (IVjoSourceModule)module;
        IJstType jstType = sourceModule.getJstType();
        if (jstType == null) {
            IResource resource = sourceModule.getResource();
            if (resource == null || !resource.exists() || !(resource instanceof IFile)) {
                jstType = CodeassistUtils.findNativeJstType(sourceModule.getElementName());
            } else {
                String typeName = CodeassistUtils.getClassName((IFile)sourceModule.getResource());
                jstType = TypeSpaceMgr.findType((String)sourceModule.getScriptProject().getElementName(), (String)typeName);
            }
        }
        endOffset = startOffset = this.repairOffset(sourceModule, startOffset);
        BaseJstNode selection = JstUtil.getLeafNode((IJstType)jstType, (int)startOffset, (int)endOffset, (boolean)true);
        IJstNode jstBinding = JstNodeDLTKElementResolver.lookupBinding((IJstNode)selection);
        return jstBinding;
    }

    public IAssistParser getParser() {
        return this.m_parser;
    }

    public IModelElement[] select(ISourceModule module, int startOffset, int endOffset) {
        IJstNode jstNode = this.convertSelection2JstNode(module, startOffset, endOffset);
        IVjoSourceModule vjoModule = null;
        if (module instanceof IVjoSourceModule) {
            vjoModule = (IVjoSourceModule)module;
        }
        return this.convert(vjoModule, jstNode);
    }

    private int repairOffset(IVjoSourceModule module, int offset) {
        if (offset == 0) {
            return offset;
        }
        try {
            char[] sourceChar = module.getSourceAsCharArray();
            if (sourceChar == null || offset >= sourceChar.length) {
                return offset;
            }
            char selectedChar = sourceChar[offset];
            if (Character.isWhitespace(selectedChar)) {
                --offset;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return offset;
    }
}

