/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui;

import java.net.URI;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.mod.debug.core.ISmartStepEvaluator;
import org.eclipse.dltk.mod.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.mod.debug.core.model.IScriptThread;
import org.eclipse.vjet.eclipse.debug.ui.VjetDebugUIPlugin;

public class VjetSmartStepEvaluator
implements ISmartStepEvaluator {
    public static final String MODIFIER_SPLITTER = "::";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean skipSuspend(String[] filters, IScriptThread thread) {
        try {
            if (!thread.hasStackFrames()) {
                return false;
            }
            IScriptStackFrame stackFrame = (IScriptStackFrame)thread.getTopStackFrame();
            URI sourceURI = stackFrame.getSourceURI();
            String sourceLocation = sourceURI.toString();
            String[] stringArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String filter = stringArray[n2];
                if (this.match(sourceLocation, filter)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (DebugException e) {
            VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
        }
        return false;
    }

    private boolean match(String sourceLocation, String filter) {
        return sourceLocation.matches(filter.split(MODIFIER_SPLITTER)[0]);
    }
}

