/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.command;

import java.net.URI;
import java.util.HashSet;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpBaseCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.mod.dbgp.internal.utils.DbgpXmlParser;
import org.eclipse.vjet.eclipse.internal.debug.command.IVjetSourceCommands;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VjetSourceCommands
extends DbgpBaseCommands
implements IVjetSourceCommands {
    private static final String SOURCE_LIST = "source_list";
    private static final String FILE_SCHEME = "file:///";
    private static final String ATTR_FILENAME = "name";

    public VjetSourceCommands(IDbgpCommunicator communicator) {
        super(communicator);
    }

    @Override
    public URI[] list() throws DbgpException {
        DbgpRequest request = this.createRequest(SOURCE_LIST);
        Element response = this.communicate(request);
        return this.parseFilesFromResponseXml(response);
    }

    private URI[] parseFilesFromResponseXml(Element response) {
        boolean success = DbgpXmlParser.parseSuccess((Element)response);
        if (!success) {
            return new URI[0];
        }
        HashSet<URI> fileURIs = new HashSet<URI>();
        Node node = response.getFirstChild();
        while ((node = this.getFileNode(node.getNextSibling())) != null) {
            URI uri = VjetSourceCommands.parseURI(node.getAttributes().getNamedItem(ATTR_FILENAME).getNodeValue());
            if (uri == null) continue;
            fileURIs.add(uri);
        }
        return fileURIs.toArray(new URI[0]);
    }

    private Node getFileNode(Node node) {
        while (node != null && 3 == node.getNodeType()) {
            node = node.getNextSibling();
        }
        return node;
    }

    private static URI parseURI(String fileName) {
        if (fileName.startsWith(FILE_SCHEME)) {
            int pos = FILE_SCHEME.length();
            if (fileName.length() > pos + 3 && Character.isLetter(fileName.charAt(pos)) && fileName.charAt(pos + 1) == '|' && fileName.charAt(pos + 2) == '/') {
                fileName = String.valueOf(fileName.substring(0, pos + 1)) + ':' + fileName.substring(pos + 2);
            }
        }
        return URI.create(fileName);
    }
}

