/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import org.eclipse.vjet.dsf.jsdebugger.gui.BreakpointCache;
import org.eclipse.vjet.dsf.jsdebugger.gui.FileHeader;
import org.eclipse.vjet.dsf.jsdebugger.gui.FileTextArea;
import org.eclipse.vjet.dsf.jsdebugger.gui.RunProxy;
import org.eclipse.vjet.dsf.jsdebugger.gui.SwingGui;
import org.eclipse.vjet.dsf.jsdi.ISourceInfo;

class FileWindow
extends JInternalFrame
implements ActionListener {
    private static final long serialVersionUID = -6212382604952082370L;
    private SwingGui m_debugGui;
    private ISourceInfo m_sourceInfo;
    private String m_url;
    FileTextArea m_textArea;
    private FileHeader m_fileHeader;
    private JScrollPane m_p;
    int m_currentPos;

    void load() {
        String url = this.getUrl();
        if (url != null) {
            RunProxy proxy = new RunProxy(this.m_debugGui, 2);
            proxy.m_fileName = url;
            try {
                proxy.m_text = this.m_sourceInfo.getText();
            }
            catch (RemoteException re) {
                throw new RuntimeException(re);
            }
            new Thread(proxy).start();
        }
    }

    public int getPosition(int line) {
        int result = -1;
        try {
            result = this.m_textArea.getLineStartOffset(line);
        }
        catch (BadLocationException badLocationException) {}
        return result;
    }

    public boolean isBreakPoint(int line) {
        try {
            return this.m_sourceInfo.isBreakableLine(line) && this.m_sourceInfo.isBreakpoint(line);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void toggleBreakPoint(int line) {
        if (!this.isBreakPoint(line)) {
            this.setBreakPoint(line);
        } else {
            this.clearBreakPoint(line);
        }
    }

    public void setBreakPoint(int line) {
        try {
            boolean changed;
            if (this.m_sourceInfo.isBreakableLine(line) && (changed = this.m_sourceInfo.setBreakpoint(line, true))) {
                BreakpointCache.Breakpoints bpCache = BreakpointCache.getBreakpoints(this.m_sourceInfo.getUri());
                if (bpCache == null) {
                    bpCache = BreakpointCache.createBreakpoints(this.m_sourceInfo.getUri());
                }
                bpCache.setBreakpoint(line, true);
                this.m_fileHeader.repaint();
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
    }

    public void clearBreakPoint(int line) {
        try {
            boolean changed;
            if (this.m_sourceInfo.isBreakableLine(line) && (changed = this.m_sourceInfo.setBreakpoint(line, false))) {
                BreakpointCache.Breakpoints bpCache = BreakpointCache.getBreakpoints(this.m_sourceInfo.getUri());
                if (bpCache != null) {
                    bpCache.setBreakpoint(line, false);
                }
                this.m_fileHeader.repaint();
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
    }

    public FileWindow(SwingGui debugGui, ISourceInfo sourceInfo) throws RemoteException {
        super(SwingGui.getShortName(sourceInfo.getUri()), true, true, true, true);
        this.m_debugGui = debugGui;
        this.m_sourceInfo = sourceInfo;
        this.m_url = this.m_sourceInfo.getUri();
        this.updateToolTip();
        this.m_currentPos = -1;
        this.m_textArea = new FileTextArea(this);
        this.m_textArea.setRows(24);
        this.m_textArea.setColumns(80);
        this.m_p = new JScrollPane();
        this.m_fileHeader = new FileHeader(this);
        this.m_p.setViewportView(this.m_textArea);
        this.m_p.setRowHeaderView(this.m_fileHeader);
        this.setContentPane(this.m_p);
        this.pack();
        this.updateText(sourceInfo);
        this.m_textArea.select(0);
    }

    private void updateToolTip() {
        int n = this.getComponentCount() - 1;
        if (n > 1) {
            n = 1;
        } else if (n < 0) {
            return;
        }
        Component c = this.getComponent(n);
        if (c != null && c instanceof JComponent) {
            ((JComponent)c).setToolTipText(this.getUrl());
        }
    }

    public String getUrl() {
        return this.m_url;
    }

    public void updateText(ISourceInfo sourceInfo) throws RemoteException {
        this.m_sourceInfo = sourceInfo;
        this.m_url = this.m_sourceInfo.getUri();
        String newText = sourceInfo.getText();
        if (!this.m_textArea.getText().equals(newText)) {
            this.m_textArea.setText(newText);
            int pos = 0;
            if (this.m_currentPos != -1) {
                pos = this.m_currentPos;
            }
            this.m_textArea.select(pos);
        }
        this.m_fileHeader.update();
        this.m_fileHeader.repaint();
    }

    public void setPosition(int pos) {
        this.m_textArea.select(pos);
        this.m_currentPos = pos;
        this.m_fileHeader.repaint();
    }

    public void select(int start, int end) {
        int docEnd = this.m_textArea.getDocument().getLength();
        this.m_textArea.select(docEnd, docEnd);
        this.m_textArea.select(start, end);
    }

    @Override
    public void dispose() {
        this.m_debugGui.removeWindow(this);
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (!cmd.equals("Cut")) {
            if (cmd.equals("Copy")) {
                this.m_textArea.copy();
            } else {
                cmd.equals("Paste");
            }
        }
    }
}

