/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.docprocessing;

import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.html.dom.DHead;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.vsf.docprocessing.IDocModifier;
import org.w3c.dom.Node;

public class BaseSiteSpeedDocModifier
implements IDocModifier {
    public static final String NAME = "oGaugeInfo";
    protected static final String TOKEN = "#URL#";
    protected static final String JS_STRING_CORE = "var oGaugeInfo = {sUrl:'#URL#',iST:(new Date()).getTime()};";
    protected static final String JS_STRING = "var oGaugeInfo = {sUrl:'#URL#',iST:(new Date()).getTime(),ebox:1};";
    protected String m_url;
    protected boolean m_isCore = true;

    public BaseSiteSpeedDocModifier(String url, boolean isCore) {
        this.m_url = url;
        this.m_isCore = isCore;
    }

    protected DScript getScript() {
        DScript script = new DScript();
        if (this.m_isCore) {
            script.setHtmlText(JS_STRING_CORE.replace(TOKEN, this.m_url));
        } else {
            script.setHtmlText(JS_STRING.replace(TOKEN, this.m_url));
        }
        return script;
    }

    @Override
    public void modify(DDocument ddoc) {
        if (ddoc instanceof DHtmlDocument) {
            DHtmlDocument doc = (DHtmlDocument)ddoc;
            DHead head = doc.getHead();
            head.insertBefore((Node)this.getScript(), head.getFirstChild());
        }
    }

    public String getUrl() {
        return this.m_url;
    }

    public boolean isCore() {
        return this.m_isCore;
    }
}

