/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.util.DomToRawSaxGenerator;
import org.eclipse.vjet.dsf.dom.util.DomToRawSaxTraceGenerator;
import org.eclipse.vjet.dsf.html.dom.util.HtmlStreamWriter;
import org.eclipse.vjet.dsf.html.dom.util.HtmlWriter;
import org.eclipse.vjet.dsf.html.dom.util.IRawSaxHandler;
import org.eclipse.vjet.dsf.html.schemas.Xhtml10Transitional;
import org.w3c.dom.Node;

public class XHtmlWriterHelper {
    public static String asString(Node node) {
        StringWriter sw = new StringWriter(128);
        XHtmlWriterHelper.write(node, sw);
        return sw.toString();
    }

    public static String asString(Node node, IIndenter indenter) {
        StringWriter sw = new StringWriter();
        XHtmlWriterHelper.write(node, sw, indenter);
        return sw.toString();
    }

    public static void write(Node node, Writer writer) {
        XHtmlWriterHelper.write(node, writer, IIndenter.COMPACT);
    }

    public static void write(Node node, Writer writer, IIndenter indenter) {
        boolean haveInstrumenter = TraceCtx.ctx().haveInstrumenter();
        HtmlStreamWriter htmlStreamWriter = new HtmlStreamWriter(writer, indenter);
        HtmlWriter htmlWriter = new HtmlWriter(Xhtml10Transitional.getInstance(), htmlStreamWriter);
        if (haveInstrumenter) {
            DomToRawSaxTraceGenerator saxGenerator = new DomToRawSaxTraceGenerator((IRawSaxHandler)htmlWriter);
            try {
                saxGenerator.genEvents(node, (IXmlStreamWriter)htmlStreamWriter);
            }
            catch (Exception e) {
                throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        DomToRawSaxGenerator saxGenerator = new DomToRawSaxGenerator((IRawSaxHandler)htmlWriter);
        try {
            saxGenerator.genEvents(node, (IXmlStreamWriter)htmlStreamWriter);
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] asBytes(Node node, String encoding, IIndenter indenter) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, encoding);
        XHtmlWriterHelper.write(node, w, indenter);
        return baos.toByteArray();
    }
}

