/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.naming;

import org.eclipse.vjet.dsf.common.naming.BaseNameCheckerVisitor;
import org.eclipse.vjet.dsf.common.naming.DsfInvalidNameException;
import org.eclipse.vjet.dsf.common.node.NameBasedDNodeFinder;
import org.eclipse.vjet.dsf.common.node.visitor.AbortDNodeTraversalException;
import org.eclipse.vjet.dsf.common.node.visitor.DNodeVisitStatus;
import org.eclipse.vjet.dsf.dom.DNode;

class LocalNameCheckerVisitor
extends BaseNameCheckerVisitor {
    LocalNameCheckerVisitor(DNode child, DNode enclosingScope) {
        super(child, enclosingScope);
    }

    @Override
    public DNodeVisitStatus preVisit(DNode node) throws AbortDNodeTraversalException {
        String localName;
        if (node == this.m_child) {
            return DNodeVisitStatus.CONTINUE;
        }
        DNodeVisitStatus status = node.isDsfExportingLocalNames() ? DNodeVisitStatus.CONTINUE : DNodeVisitStatus.ABORT_SUBTREE;
        if (!node.hasDsfName()) {
            return status;
        }
        if (node.getDsfName().getScopeName() != null) {
            status = DNodeVisitStatus.ABORT_SUBTREE;
        }
        if ((localName = node.getDsfName().getLocalName()) == null) {
            return status;
        }
        DNode foundConflict = NameBasedDNodeFinder.getByLocalName(localName, this.m_enclosingScope);
        if (foundConflict != null) {
            throw new DsfInvalidNameException("can't add child (" + node.getClass() + ")  with local name '" + localName + "' because the scope is already used in parent");
        }
        return status;
    }
}

