/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.naming;

import org.eclipse.vjet.dsf.common.naming.DElementId;
import org.eclipse.vjet.dsf.common.naming.DsfInvalidNameException;
import org.eclipse.vjet.dsf.common.naming.IDsfName;
import org.eclipse.vjet.dsf.common.naming.LocalNameCheckerVisitor;
import org.eclipse.vjet.dsf.common.naming.ParentScopes;
import org.eclipse.vjet.dsf.common.naming.ScopeNameCheckerVisitor;
import org.eclipse.vjet.dsf.common.node.NameBasedDNodeFinder;
import org.eclipse.vjet.dsf.common.node.visitor.AbortDNodeTraversalException;
import org.eclipse.vjet.dsf.dom.DNode;

public class NameChecker {
    public static void assertNamesUnique(DNode parent, DNode child) {
        if (!child.hasDsfName()) {
            return;
        }
        NameChecker.assertLocalNameUnique(parent, child);
        NameChecker.assertScopeNameUnique(parent, child);
    }

    public static void assertLocalNameUnique(DNode parent, DNode child) {
        if (!child.hasDsfName()) {
            return;
        }
        IDsfName name = child.getDsfName();
        if (name.getLocalName() == null) {
            return;
        }
        DNode component = NameBasedDNodeFinder.getByLocalName(name.getLocalName(), parent);
        if (component != null) {
            throw new DsfInvalidNameException("local name '" + name.getLocalName() + "' is already in use");
        }
    }

    public static void assertScopeNameUnique(DNode parent, DNode child) {
        if (!child.hasDsfName()) {
            return;
        }
        IDsfName name = child.getDsfName();
        if (name.getScopeName() == null) {
            return;
        }
        DNode enclosingScope = NameChecker.getEnclosingScoped(parent);
        ParentScopes scopes = new ParentScopes();
        scopes.appendScope(new DElementId(name.getScopeName()).toString());
        DNode component = NameBasedDNodeFinder.get(scopes, null, enclosingScope);
        if (component != null) {
            throw new DsfInvalidNameException("scope name '" + name.getScopeName() + "' is already in use");
        }
    }

    public static void assertChildrenNamesUnique(DNode parent, DNode child) {
        IDsfName name;
        if (child.hasDsfName() && (name = child.getDsfName()).getScopeName() != null) {
            return;
        }
        if (!child.isDsfExportingLocalNames()) {
            return;
        }
        DNode enclosingScope = NameChecker.getEnclosingScoped(parent);
        ScopeNameCheckerVisitor scopeVisitor = new ScopeNameCheckerVisitor(child, enclosingScope);
        try {
            child.dsfAccept(scopeVisitor);
        }
        catch (AbortDNodeTraversalException abortDNodeTraversalException) {}
        LocalNameCheckerVisitor localVisitor = new LocalNameCheckerVisitor(child, enclosingScope);
        try {
            child.dsfAccept(localVisitor);
        }
        catch (AbortDNodeTraversalException abortDNodeTraversalException) {}
    }

    public static DNode getEnclosingScoped(DNode parent) {
        DNode component = parent;
        while (component.getDsfParentNode() != null) {
            IDsfName name;
            if (component.hasDsfName() && (name = component.getDsfName()).getScopeName() != null) {
                return component;
            }
            component = component.getDsfParentNode();
        }
        return component;
    }
}

