/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.node;

import org.eclipse.vjet.dsf.common.DsfVerifierConfig;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.naming.DsfInvalidNameException;
import org.eclipse.vjet.dsf.common.naming.IDsfName;
import org.eclipse.vjet.dsf.common.naming.IDsfNamingFamily;
import org.eclipse.vjet.dsf.common.naming.NameChecker;
import org.eclipse.vjet.dsf.common.naming.NameStatusCheck;
import org.eclipse.vjet.dsf.common.naming.ParentScopes;
import org.eclipse.vjet.dsf.common.naming.ResolvedNamePath;
import org.eclipse.vjet.dsf.common.node.NameBasedDNodeFinder;
import org.eclipse.vjet.dsf.dom.DNode;

public class DNodeName
implements IDsfName {
    private static final long serialVersionUID = -4458564866139801250L;
    private String m_localName = null;
    private String m_scopeName = null;
    private final DNode m_node;

    public DNodeName(DNode node) {
        if (node == null) {
            this.chuck("node can't be null");
        }
        this.m_node = node;
    }

    @Override
    public String getLocalName() {
        return this.m_localName;
    }

    @Override
    public void setLocalName(String localName) {
        if (this.m_localName != null && this.m_localName.equals(localName)) {
            return;
        }
        DsfVerifierConfig config = DsfVerifierConfig.getInstance();
        boolean verifyNaming = config.isVerifyNaming();
        if (verifyNaming) {
            NameStatusCheck status = this.m_node.getDsfNamingFamily().verifyLocalName(localName);
            if (!status.isOk()) {
                throw new DsfInvalidNameException(status.getErrorMessage());
            }
            this.assertLocalNameIsNotInUse(localName);
        }
        if (this.m_localName == null) {
            this.m_localName = localName;
            return;
        }
        DNode parent = this.m_node.getDsfParentNode();
        if (parent != null && parent.hasDsfFacets() && parent.getDsfFacets().get(this.m_localName) == this.m_node) {
            this.chuck("can't override localName for facet");
        }
        this.m_localName = localName;
    }

    @Override
    public String getScopeName() {
        return this.m_scopeName;
    }

    @Override
    public String getFullName() {
        return this.getFullName(this.m_node.getDsfNamingFamily());
    }

    @Override
    public String getFullName(IDsfNamingFamily namingFamily) {
        if (this.m_localName == null && this.m_scopeName == null) {
            return null;
        }
        ParentScopes scopes = this.getParentScopes();
        if (this.m_localName == null && this.m_scopeName != null) {
            scopes.appendScope(this.m_scopeName);
        }
        ResolvedNamePath rpn = new ResolvedNamePath(scopes, this.getLocalName());
        String fullname = namingFamily.compose(rpn);
        return fullname;
    }

    @Override
    public void setScopeName(String localScopeName) {
        NameStatusCheck status;
        DsfVerifierConfig config = DsfVerifierConfig.getInstance();
        boolean verifyNaming = config.isVerifyNaming();
        if (verifyNaming && !(status = this.m_node.getDsfNamingFamily().verifyLocalName(localScopeName)).isOk()) {
            throw new DsfInvalidNameException(status.getErrorMessage());
        }
        if (localScopeName.equals(this.m_scopeName)) {
            return;
        }
        if (verifyNaming) {
            this.assertScopeNameNotInUse(localScopeName);
        }
        this.m_scopeName = localScopeName;
    }

    @Override
    public ParentScopes getParentScopes() {
        ParentScopes scopes = new ParentScopes();
        DNode parent = this.m_node.getDsfParentNode();
        if (parent == null) {
            return scopes;
        }
        if (parent.getDsfName().getScopeName() != null) {
            scopes.setHasScopedParent(true);
        }
        this.collectScope(scopes);
        return scopes;
    }

    public String toString() {
        Z z = new Z();
        z.format("local name", (Object)this.m_localName);
        z.format("local scope name", (Object)this.m_scopeName);
        z.format("node name", (Object)this.m_node.getNodeName());
        z.format("node value", (Object)this.m_node.getNodeValue());
        return z.toString();
    }

    protected void collectScope(ParentScopes scopes) {
        DNode parent = this.m_node.getDsfParentNode();
        while (parent != null) {
            DNodeName dsfName = (DNodeName)parent.getDsfName();
            String scopeName = dsfName.getScopeName();
            if (scopeName != null) {
                scopes.addParentToCurrentScope(scopeName);
            }
            parent = parent.getDsfParentNode();
        }
    }

    protected void assertScopeNameNotInUse(String scopeName) {
        if (!DsfVerifierConfig.getInstance().isVerifyNaming()) {
            return;
        }
        DNode parent = this.m_node.getDsfParentNode();
        if (parent == null) {
            return;
        }
        DNode enclosingScope = NameChecker.getEnclosingScoped(parent);
        ParentScopes scopes = new ParentScopes();
        scopes.appendScope(scopeName);
        DNode component = NameBasedDNodeFinder.get(scopes, null, enclosingScope);
        if (component == null) {
            return;
        }
        throw new DsfInvalidNameException(String.valueOf(scopeName) + " has conflict with existing component");
    }

    private void assertLocalNameIsNotInUse(String localName) {
        if (!DsfVerifierConfig.getInstance().isVerifyNaming()) {
            return;
        }
        DNode parent = this.m_node.getDsfParentNode();
        if (parent == null) {
            return;
        }
        DNode enclosingScope = NameChecker.getEnclosingScoped(parent);
        DNode component = NameBasedDNodeFinder.getByLocalName(localName, enclosingScope);
        if (component == null) {
            return;
        }
        throw new DsfInvalidNameException("parent has child or facet with local name '" + localName + "'");
    }

    private void chuck(String msg) {
        throw new DsfRuntimeException(msg);
    }
}

