/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.node;

import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.naming.IDsfName;
import org.eclipse.vjet.dsf.common.naming.IDsfNamingFamily;
import org.eclipse.vjet.dsf.common.naming.ParentScopes;
import org.eclipse.vjet.dsf.common.naming.ResolvedNamePath;
import org.eclipse.vjet.dsf.common.node.visitor.AbortDNodeTraversalException;
import org.eclipse.vjet.dsf.common.node.visitor.DNodeVisitStatus;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeHandlingStrategy;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.common.node.visitor.PreOrderDNodeTraversal;
import org.eclipse.vjet.dsf.dom.DNode;

public class NameBasedDNodeFinder {
    public static DNode get(String relativePath, DNode component) {
        IDsfNamingFamily nf = component.getDsfNamingFamily();
        ResolvedNamePath rnp = nf.decomposeName(relativePath);
        return NameBasedDNodeFinder.get(rnp, component);
    }

    public static DNode get(ResolvedNamePath resolvedNamePath, DNode component) {
        ParentScopes scopes = resolvedNamePath.getScopes();
        String localName = resolvedNamePath.getLocalName();
        return NameBasedDNodeFinder.get(scopes, localName, component);
    }

    public static DNode get(ParentScopes scopes, String localName, DNode component) {
        if ((scopes == null || scopes.size() <= 0) && localName != null) {
            return NameBasedDNodeFinder.getByLocalName(localName, component);
        }
        NameFinder finder = new NameFinder(scopes, localName);
        try {
            component.dsfAccept(finder);
        }
        catch (AbortDNodeTraversalException abortDNodeTraversalException) {}
        return finder.getMatchedComponent();
    }

    public static DNode getByLocalName(String localName, DNode component) {
        LocalNameFinder finder = new LocalNameFinder(localName, component);
        try {
            component.dsfAccept(finder);
        }
        catch (AbortDNodeTraversalException abortDNodeTraversalException) {}
        return finder.getMatchedComponent();
    }

    private static class LocalNameFinder
    implements IDNodeVisitor {
        private final IDNodeHandlingStrategy m_strategy = new PreOrderDNodeTraversal();
        private final DNode m_rootComponent;
        private final String m_localName;
        private DNode m_matchedComponent = null;

        LocalNameFinder(String localName, DNode rootComponent) {
            if (localName == null || localName.length() == 0) {
                throw new DsfRuntimeException("must supply local name");
            }
            this.m_localName = localName;
            this.m_rootComponent = rootComponent;
        }

        DNode getMatchedComponent() {
            return this.m_matchedComponent;
        }

        @Override
        public DNodeVisitStatus preVisit(DNode component) throws AbortDNodeTraversalException {
            if (!component.hasDsfName()) {
                if (component.isDsfExportingLocalNames()) {
                    return DNodeVisitStatus.CONTINUE;
                }
                if (component == this.m_rootComponent) {
                    return DNodeVisitStatus.CONTINUE;
                }
                return DNodeVisitStatus.ABORT_SUBTREE;
            }
            IDsfName dsfName = component.getDsfName();
            if (this.m_localName.equals(dsfName.getLocalName())) {
                this.m_matchedComponent = component;
                throw new AbortDNodeTraversalException("matched");
            }
            if (dsfName.getScopeName() == null || component == this.m_rootComponent) {
                return DNodeVisitStatus.CONTINUE;
            }
            return DNodeVisitStatus.ABORT_SUBTREE;
        }

        @Override
        public DNodeVisitStatus visit(DNode component) {
            return DNodeVisitStatus.CONTINUE;
        }

        @Override
        public DNodeVisitStatus postVisit(DNode component) {
            return DNodeVisitStatus.CONTINUE;
        }

        @Override
        public IDNodeHandlingStrategy getStrategy() {
            return this.m_strategy;
        }
    }

    private static class NameFinder
    implements IDNodeVisitor {
        private final IDNodeHandlingStrategy m_strategy = new PreOrderDNodeTraversal();
        private final ParentScopes m_scopes;
        private int m_scopeIndex = 0;
        private final String m_localName;
        private DNode m_matchedComponent = null;

        NameFinder(ParentScopes scopes, String localName) {
            this.m_scopes = scopes;
            this.m_localName = localName;
        }

        DNode getMatchedComponent() {
            return this.m_matchedComponent;
        }

        @Override
        public DNodeVisitStatus preVisit(DNode component) throws AbortDNodeTraversalException {
            if (this.m_scopeIndex >= this.m_scopes.size()) {
                this.m_matchedComponent = null;
                throw new AbortDNodeTraversalException("nomatch");
            }
            if (!component.hasDsfName()) {
                return DNodeVisitStatus.CONTINUE;
            }
            String componentScopeName = component.getDsfName().getScopeName();
            if (componentScopeName == null) {
                return DNodeVisitStatus.CONTINUE;
            }
            String scopeName = this.m_scopes.get(this.m_scopeIndex);
            if (scopeName.equals(componentScopeName)) {
                return this.handlePartialScopeMatch(component);
            }
            return DNodeVisitStatus.CONTINUE;
        }

        private DNodeVisitStatus handlePartialScopeMatch(DNode component) throws AbortDNodeTraversalException {
            ++this.m_scopeIndex;
            if (this.m_scopeIndex < this.m_scopes.size()) {
                return DNodeVisitStatus.CONTINUE;
            }
            if (this.m_localName == null) {
                this.m_matchedComponent = component;
                throw new AbortDNodeTraversalException("matched");
            }
            this.m_matchedComponent = NameBasedDNodeFinder.getByLocalName(this.m_localName, component);
            if (this.m_matchedComponent == null) {
                throw new AbortDNodeTraversalException("localName is not matched");
            }
            throw new AbortDNodeTraversalException("matched");
        }

        @Override
        public DNodeVisitStatus visit(DNode component) throws AbortDNodeTraversalException {
            return DNodeVisitStatus.CONTINUE;
        }

        @Override
        public DNodeVisitStatus postVisit(DNode component) throws AbortDNodeTraversalException {
            if (this.m_matchedComponent == component) {
                this.m_matchedComponent = null;
                throw new AbortDNodeTraversalException("ScopePath not matched");
            }
            return DNodeVisitStatus.CONTINUE;
        }

        @Override
        public IDNodeHandlingStrategy getStrategy() {
            return this.m_strategy;
        }
    }
}

