/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.binding.SimpleValueBinding;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.node.IDNodeList;
import org.eclipse.vjet.dsf.dom.AttributeMap;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DCDATASection;
import org.eclipse.vjet.dsf.dom.DComment;
import org.eclipse.vjet.dsf.dom.DDocumentFragment;
import org.eclipse.vjet.dsf.dom.DDocumentType;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DEntity;
import org.eclipse.vjet.dsf.dom.DEntityReference;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DNodeList;
import org.eclipse.vjet.dsf.dom.DNotation;
import org.eclipse.vjet.dsf.dom.DProcessingInstruction;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.dom.support.DsfDomLevelNotSupportedException;
import org.eclipse.vjet.dsf.dom.support.DsfDomNotSupportedRuntimeException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DDocument
extends DNode
implements Document {
    private static final long serialVersionUID = 1L;
    private String m_xmlVersion;
    private boolean m_bDsfXml11Version;
    private Map<String, DElement> m_idToElement = new HashMap<String, DElement>();
    private Set<DNamespace> m_dsfNamespaceDeclarations;
    private DNamespace m_dsfDocumentURI;
    private String m_xmlEncoding;
    private String m_inputEncoding;
    private DOMImplementation m_implementation;
    static final List<String> ENCODEINGS = new ArrayList<String>(4);
    static final List<String> XML_VERSIONS = new ArrayList<String>(2);

    static {
        ENCODEINGS.add("utf-8");
        ENCODEINGS.add("utf-16");
        ENCODEINGS.add("iso-8859-1");
        ENCODEINGS.add("cp1252");
        XML_VERSIONS.add("1.0");
        XML_VERSIONS.add("1.1");
    }

    public DDocument() {
        this((DDocumentType)null);
    }

    public DDocument(DDocumentType docType) {
        this.setDsfOwnerDocument(this);
        if (docType != null) {
            docType.setDsfOwnerDocument(this);
            this.add(docType);
        }
    }

    public DDocument add(DNamespace ns) {
        this.getDsfNamespaceDeclarations().add(ns);
        return this;
    }

    @Override
    public DDocument add(DNode node) {
        super.add(node);
        return this;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild == null) {
            throw new DOMException(16, "Document add(...) expects a non-null");
        }
        Class<?> newChildsClass = newChild.getClass();
        if (DocumentFragment.class.isAssignableFrom(newChildsClass)) {
            DocumentFragment frag = (DocumentFragment)newChild;
            if (!frag.hasChildNodes()) {
                return this;
            }
            if (this.getDocumentElement() != null) {
                throw new DOMException(16, "Document already has a document element");
            }
            if (frag.getOwnerDocument() != null && frag.getOwnerDocument() != this) {
                throw new DOMException(16, "The added fragment is from another document");
            }
            NodeList children = frag.getChildNodes();
            int size = children.getLength();
            if (size > 1) {
                throw new DOMException(16, "Documents only support a single root node.  The added fragment has more than 1 child.");
            }
            Node child = children.item(0);
            super.appendChild(child);
            return newChild;
        }
        if (Element.class.isAssignableFrom(newChildsClass) || Comment.class.isAssignableFrom(newChildsClass) || ProcessingInstruction.class.isAssignableFrom(newChildsClass)) {
            super.appendChild(newChild);
            return this;
        }
        if (DElement.class.isAssignableFrom(newChildsClass) && this.getDocumentElement() != null) {
            throw new DOMException(16, "Document already has a document element");
        }
        if (DocumentType.class.isAssignableFrom(newChildsClass)) {
            if (this.getDoctype() != null) {
                throw new DOMException(16, "Document already has a doc type");
            }
            DDocumentType docType = (DDocumentType)newChild;
            this.getDsfChildNodes().add(0, docType);
            docType.setParent(this);
            docType.setDsfOwnerDocument(this);
            return this;
        }
        super.appendChild(newChild);
        return this;
    }

    @Override
    public DDocumentType getDoctype() {
        Node firstChild = this.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        if (firstChild instanceof DDocumentType) {
            return (DDocumentType)firstChild;
        }
        return null;
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.m_implementation;
    }

    protected DDocument setDOMImplementation(DOMImplementation impl) {
        this.m_implementation = impl;
        return this;
    }

    @Override
    public Element getDocumentElement() {
        if (!this.hasChildNodes()) {
            return null;
        }
        IDNodeList kids = this.getDsfChildNodes();
        int len = kids.getLength();
        int i = 0;
        while (i < len) {
            DNode node = (DNode)kids.get(i);
            if (node instanceof Element) {
                return (Element)((Object)node);
            }
            ++i;
        }
        return null;
    }

    public DElement dsfGetDocumentElement() {
        return (DElement)this.getDocumentElement();
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return new DElement(this, tagName);
    }

    public <T> T element(String tagName) {
        return (T)this.createElement(tagName);
    }

    public DElement dsfCreateElement(String tagName) throws DOMException {
        return (DElement)this.createElement(tagName);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DDocumentFragment(this);
    }

    public DDocumentFragment dsfCreateDocumentFragment() {
        return (DDocumentFragment)this.createDocumentFragment();
    }

    @Override
    public Text createTextNode(String data) {
        return new DText(this, data);
    }

    public DText dsfCreateTextNode(String data) {
        return (DText)this.createTextNode(data);
    }

    @Override
    public Comment createComment(String data) {
        return new DComment(this, data);
    }

    public DComment dsfCreateComment(String data) {
        return (DComment)this.createComment(data);
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return new DCDATASection(this, data);
    }

    public DCDATASection dsfCreateCDATASection(String data) throws DOMException {
        return (DCDATASection)this.createCDATASection(data);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (target == null) {
            DDocument.chuck("The target for a processing instruction must not be null");
        }
        if (data == null) {
            DDocument.chuck("The data for a processing instruction must not be null");
        }
        DProcessingInstruction pi = new DProcessingInstruction(this, target, data);
        this.appendChild(pi);
        return pi;
    }

    public DProcessingInstruction dsfCreateProcessingInstruction(String target, String data) throws DOMException {
        return (DProcessingInstruction)this.createProcessingInstruction(target, data);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return new DAttr(this, name);
    }

    public DAttr dsfCreateAttribute(String name) throws DOMException {
        return (DAttr)this.createAttribute(name);
    }

    public Attr createAttribute(String name, String value) throws DOMException {
        return new DAttr(this, name, value);
    }

    public DAttr dsfCreateAttribute(String name, String value) throws DOMException {
        return (DAttr)this.createAttribute(name, value);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return new DEntityReference(this, name);
    }

    public DEntityReference dsfCreateEntityReference(String name) throws DOMException {
        return (DEntityReference)this.createEntityReference(name);
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String tagName) {
        Element root = this.getDocumentElement();
        if (root == null) {
            return new DNodeList(this, 0);
        }
        return root.getElementsByTagName(tagName);
    }

    @Override
    public Node importNode(Node source, boolean deep) throws DOMException {
        return this.importNode((DNode)source, deep, true, null);
    }

    public DNode dsfImportNode(Node source, boolean deep) throws DOMException {
        return (DNode)this.importNode(source, deep);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return new DElement(this, namespaceURI, qualifiedName);
    }

    public DElement dsfCreateElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return (DElement)this.createElementNS(namespaceURI, qualifiedName);
    }

    public Element createElementNS(DNamespace namespace, String localName) throws DOMException {
        return new DElement(this, namespace, localName);
    }

    public DElement dsfCreateElementNS(DNamespace namespace, String localName) throws DOMException {
        return (DElement)this.createElementNS(namespace, localName);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("createAttributeNS(String namespaceURI, String qualifiedName)");
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        Element root = this.getDocumentElement();
        if (root == null) {
            return new DNodeList(this, 0);
        }
        return root.getElementsByTagNameNS(namespaceURI, localName);
    }

    public NodeList dsfGetElementsByTagNameNS(DNamespace namespace, String localName) {
        DElement root = (DElement)this.getDocumentElement();
        if (root == null) {
            return new DNodeList(this, 0);
        }
        return root.dsfGetElementsByTagNameNS(namespace, localName);
    }

    @Override
    public Element getElementById(String elementId) {
        DElement element = this.m_idToElement.get(elementId);
        return element;
    }

    public DElement dsfGetElementById(String elementId) {
        return (DElement)this.getElementById(elementId);
    }

    @Override
    public String getInputEncoding() {
        return this.m_inputEncoding;
    }

    @Override
    public String getXmlEncoding() {
        return this.m_xmlEncoding;
    }

    @Override
    public boolean getXmlStandalone() {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public String getXmlVersion() {
        return this.m_xmlVersion == null ? "1.0" : this.m_xmlVersion;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        if (xmlVersion == null || XML_VERSIONS.indexOf(xmlVersion) == -1) {
            throw new DOMException(9, "unknown xml version " + xmlVersion);
        }
        this.m_xmlVersion = xmlVersion;
        this.m_bDsfXml11Version = this.m_xmlVersion.equals("1.1");
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public String getDocumentURI() {
        return this.m_dsfDocumentURI != null ? this.m_dsfDocumentURI.getNamespaceKey() : null;
    }

    public DNamespace getDsfDocumentURI() {
        return this.m_dsfDocumentURI;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        if (documentURI == null) {
            throw new DOMException(14, "namespaceUri is null.");
        }
        this.m_dsfDocumentURI = DNamespace.getNamespace(null, documentURI);
    }

    public DDocument setDsfDocumentURI(DNamespace namespace) {
        this.m_dsfDocumentURI = namespace;
        return this;
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public void normalizeDocument() {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String name) throws DOMException {
        throw new DsfDomLevelNotSupportedException(3);
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        DDocumentType dt = new DDocumentType(this, qualifiedName, publicId, systemId);
        return dt;
    }

    public DDocumentType dsfCreateDocumentType(String qualifiedName, String publicId, String systemId) {
        return (DDocumentType)this.createDocumentType(qualifiedName, publicId, systemId);
    }

    public Entity createEntity(String name) {
        return new DEntity(this, name);
    }

    public DEntity dsfCreateEntity(String name) {
        return (DEntity)this.createEntity(name);
    }

    public Notation createNotation(String name) {
        return new DNotation(this, name);
    }

    public DNotation dsfCreateNotation(String name) {
        return (DNotation)this.createNotation(name);
    }

    @Override
    protected void checkChildForAdd(Node newChild) {
        super.checkChildForAdd(newChild);
        if (newChild instanceof DocumentType) {
            if (this.getDoctype() != null) {
                throw new DOMException(3, "HIERARCHY_REQUEST_ERR: Document already has a DocumentType.");
            }
        } else if (newChild instanceof Element && this.getDocumentElement() != null) {
            throw new DOMException(3, "HIERARCHY_REQUEST_ERR: Document already has a Document Element.");
        }
    }

    @Override
    protected void postChildAdd(DNode node) {
        super.postChildAdd(node);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild == null) {
            throw new DOMException(16, "removeChild() does not expect a null");
        }
        Node result = super.removeChild(oldChild);
        if (result == null) {
            return result;
        }
        return result;
    }

    @Override
    public final short getNodeType() {
        return 9;
    }

    void putIdentifier(String id, DElement element) {
        DElement old = this.m_idToElement.get(id);
        if (old != null && old != element) {
            throw new DOMException(16, "duplicate ID of " + id);
        }
        this.m_idToElement.put(id, element);
    }

    void removeIdentifier(String id) {
        this.m_idToElement.remove(id);
    }

    void removeIdentifiedElement(DNode node) {
        String id;
        if (node instanceof DElement && (id = ((DElement)node).getAttribute("id")) != null) {
            this.m_idToElement.remove(id);
        }
    }

    protected void cloneNode(DDocument copyDoc) {
        HashMap<DElement, String> elementToId = new HashMap<DElement, String>();
        for (Map.Entry<String, DElement> entry : this.m_idToElement.entrySet()) {
            elementToId.put(entry.getValue(), entry.getKey());
        }
        if (this.m_childNodes != null) {
            for (DNode kid : this.m_childNodes) {
                DNode importedNode = (DNode)copyDoc.importNode(kid, true, true, elementToId);
                copyDoc.add(importedNode);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DDocument copyDoc = new DDocument();
        this.cloneNode(copyDoc);
        return copyDoc;
    }

    private Node importNode(DNode source, boolean deep, boolean cloningDoc, Map<DElement, String> elementToId) throws DOMException {
        DNode newnode = null;
        short type = source.getNodeType();
        switch (type) {
            case 1: {
                newnode = this.importElement((DElement)source, cloningDoc, elementToId);
                break;
            }
            case 2: {
                newnode = source.getLocalName() == null ? (DAttr)this.createAttribute(source.getNodeName()) : (DAttr)this.createAttributeNS(source.getNamespaceURI(), source.getNodeName());
                if (source.getFirstChild() == null) {
                    DAttr sourceAttr = (DAttr)source;
                    DAttr newAttr = (DAttr)newnode;
                    IValueBinding<Object> binding = sourceAttr.getValueBinding();
                    if (binding == null) {
                        newnode.setNodeValue(source.getNodeValue());
                    } else {
                        SimpleValueBinding<Object> newBinding = new SimpleValueBinding<Object>(Object.class, binding.getValue());
                        newAttr.setValueBinding(newBinding);
                    }
                    ((DAttr)newnode).setId(((DAttr)source).isId());
                    deep = false;
                    break;
                }
                deep = true;
                break;
            }
            case 3: {
                newnode = (DText)this.createTextNode(source.getNodeValue());
                break;
            }
            case 4: {
                newnode = (DCDATASection)this.createCDATASection(source.getNodeValue());
                break;
            }
            case 5: {
                newnode = (DEntityReference)this.createEntityReference(source.getNodeName());
                deep = false;
                break;
            }
            case 6: {
                Entity srcentity = (Entity)((Object)source);
                DEntity newentity = new DEntity(this, source.getNodeName());
                newentity.setPublicId(srcentity.getPublicId());
                newentity.setSystemId(srcentity.getSystemId());
                newentity.setNotationName(srcentity.getNotationName());
                newnode = newentity;
                break;
            }
            case 7: {
                newnode = (DProcessingInstruction)this.createProcessingInstruction(source.getNodeName(), source.getNodeValue());
                break;
            }
            case 8: {
                newnode = (DComment)this.createComment(source.getNodeValue());
                break;
            }
            case 10: {
                DNode nodeToImport;
                int i;
                if (!cloningDoc) {
                    throw new DOMException(9, "this is not supported");
                }
                DocumentType srcdoctype = (DocumentType)((Object)source);
                DDocumentType newdoctype = (DDocumentType)this.createDocumentType(srcdoctype.getNodeName(), srcdoctype.getPublicId(), srcdoctype.getSystemId());
                NamedNodeMap smap = srcdoctype.getEntities();
                NamedNodeMap tmap = newdoctype.getEntities();
                if (smap != null) {
                    i = 0;
                    while (i < smap.getLength()) {
                        nodeToImport = (DNode)smap.item(i);
                        tmap.setNamedItem(this.importNode(nodeToImport, true, true, elementToId));
                        ++i;
                    }
                }
                smap = srcdoctype.getNotations();
                tmap = newdoctype.getNotations();
                if (smap != null) {
                    i = 0;
                    while (i < smap.getLength()) {
                        nodeToImport = (DNode)smap.item(i);
                        tmap.setNamedItem(this.importNode(nodeToImport, true, true, elementToId));
                        ++i;
                    }
                }
                newnode = newdoctype;
                break;
            }
            case 11: {
                newnode = (DDocumentFragment)this.createDocumentFragment();
                break;
            }
            case 12: {
                Notation srcnotation = (Notation)((Object)source);
                DNotation newnotation = (DNotation)this.createNotation(source.getNodeName());
                newnotation.setPublicId(srcnotation.getPublicId());
                newnotation.setSystemId(srcnotation.getSystemId());
                newnode = newnotation;
                break;
            }
            default: {
                throw new DOMException(9, "this is not supported");
            }
        }
        if (deep && source.m_childNodes != null) {
            for (DNode srckid : source.m_childNodes) {
                newnode.appendChild(this.importNode(srckid, true, cloningDoc, elementToId));
            }
        }
        return newnode;
    }

    protected DElement createElementForImporting(DElement source) {
        if (source.getClass() != DElement.class) {
            return this.createBastardElement(source);
        }
        if (source.getLocalName() == null) {
            return (DElement)this.createElement(source.getNodeName());
        }
        return (DElement)this.createElementNS(source.getNamespaceURI(), source.getNodeName());
    }

    protected DElement createBastardElement(DElement source) {
        DElement newElement;
        Class<?> type = source.getClass();
        try {
            newElement = (DElement)type.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new DsfRuntimeException("unable to create instance of " + type.getName(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new DsfRuntimeException("unable to create instance of " + type.getName(), (Throwable)e);
        }
        newElement.m_nodeName = source.getNodeName();
        newElement.setDsfOwnerDocument(this);
        if (source.getLocalName() != null) {
            throw new DsfDomNotSupportedRuntimeException("name spaces not supported");
        }
        return newElement;
    }

    protected DElement importElement(DElement source, boolean cloningDoc, Map<DElement, String> reversedIdentifiers) {
        String elementId;
        DElement newElement = this.createElementForImporting(source);
        if (source.hasAttributes()) {
            AttributeMap attrs = source.m_attributes;
            for (Map.Entry<String, DAttr> entry : attrs.attrEntrySet()) {
                DAttr attr = entry.getValue();
                if (!attr.getSpecified() && !cloningDoc) continue;
                DAttr newAttr = (DAttr)this.importNode(attr, true, cloningDoc, reversedIdentifiers);
                if (attr.getLocalName() == null) {
                    newElement.setAttributeNode(newAttr);
                    continue;
                }
                newElement.setAttributeNodeNS(newAttr);
            }
        }
        if (reversedIdentifiers != null && (elementId = reversedIdentifiers.get(source)) != null) {
            this.m_idToElement.put(elementId, newElement);
        }
        return newElement;
    }

    @Override
    public DDocument jif(String jif) {
        super.jif(jif);
        return this;
    }

    @Override
    public String toString() {
        Z z = new Z();
        z.format("docType", (Object)this.getDoctype());
        z.format("documentElement", this.getDocumentElement() == null ? null : this.getDocumentElement().getTagName());
        z.format("length", this.getLength());
        z.format("ids", this.m_idToElement.keySet());
        return z.toString();
    }

    public Set<DNamespace> getDsfNamespaceDeclarations() {
        if (this.m_dsfNamespaceDeclarations == null) {
            this.m_dsfNamespaceDeclarations = new LinkedHashSet<DNamespace>(3);
        }
        return this.m_dsfNamespaceDeclarations;
    }

    @Override
    public String getBaseURI() {
        return this.getDocumentURI();
    }

    @Override
    public DNamespace getDsfBaseURI() {
        return this.getDsfDocumentURI();
    }

    public void setInputEncoding(String value) {
        if (value == null || ENCODEINGS.indexOf(value.toLowerCase()) == -1) {
            throw new DOMException(9, "unsupported InputEncoding " + value);
        }
        this.m_inputEncoding = value;
    }

    public void setXmlEncoding(String value) {
        if (value == null || ENCODEINGS.indexOf(value.toLowerCase()) == -1) {
            throw new DOMException(9, "unsupported XmlEncoding " + value);
        }
        this.m_xmlEncoding = value;
    }

    @Override
    public boolean isDsfXml11Version() {
        return this.m_bDsfXml11Version;
    }

    @Override
    public DNamespace dsfLookupNamespaceURI(String specifiedPrefix) {
        if (specifiedPrefix == null) {
            return this.m_dsfDocumentURI;
        }
        if (this.m_dsfNamespaceDeclarations == null) {
            return null;
        }
        for (DNamespace ns : this.m_dsfNamespaceDeclarations) {
            if (!specifiedPrefix.equals(ns.getPrefix())) continue;
            return ns;
        }
        return null;
    }
}

