/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TextChildOperationUtil {
    public static DText setTextValue(DNode element, String newTextValue) {
        int childCount = element.getLength();
        if (childCount == 0) {
            if (newTextValue == null) {
                return null;
            }
            DText newText = new DText(newTextValue);
            element.add(newText);
            return newText;
        }
        ArrayList<Node> textNodeChildren = new ArrayList<Node>(2);
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < childCount) {
            Node candidate = children.item(i);
            if (candidate instanceof DText) {
                textNodeChildren.add(candidate);
            }
            ++i;
        }
        if (textNodeChildren.size() == 1) {
            DText onlyTextNode = (DText)textNodeChildren.get(0);
            onlyTextNode.setData(newTextValue);
            return onlyTextNode;
        }
        Iterator iter = textNodeChildren.iterator();
        while (iter.hasNext()) {
            element.removeChild((Node)iter.next());
        }
        if (newTextValue == null) {
            return null;
        }
        DText newText = new DText(newTextValue);
        element.add(newText);
        return newText;
    }

    public static String getTextValue(DNode element) {
        int childCount = element.getLength();
        if (childCount == 0) {
            return null;
        }
        NodeList children = element.getChildNodes();
        String answer = null;
        int i = 0;
        while (i < childCount) {
            Node candidate = children.item(i);
            if (candidate instanceof DText) {
                DText dtextNode = (DText)candidate;
                answer = answer == null ? dtextNode.getData() : String.valueOf(answer) + dtextNode.getData();
            }
            ++i;
        }
        return answer;
    }
}

