/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public class ChildFirstClassLoader
extends URLClassLoader {
    private ClassLoader m_parent;

    public static Class load(Class clz) {
        String baseUri = clz.getName().replace(".", "/");
        String fileName = String.valueOf(baseUri) + ".class";
        URL url = clz.getResource("/" + fileName);
        String fullUrlName = url.toExternalForm();
        try {
            URL rootUrl = new URL(fullUrlName.substring(0, fullUrlName.length() - fileName.length()));
            ChildFirstClassLoader loader = new ChildFirstClassLoader(new URL[]{rootUrl}, ChildFirstClassLoader.class.getClassLoader());
            try {
                return Class.forName(clz.getName(), true, loader);
            }
            catch (ClassNotFoundException e) {
                throw new DsfRuntimeException((Throwable)e);
            }
        }
        catch (MalformedURLException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    private ChildFirstClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)null);
        this.m_parent = parent;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clz = null;
        try {
            clz = super.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (clz == null) {
            clz = this.m_parent.loadClass(name);
        }
        return clz;
    }
}

