/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.compiler.env;

import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.compiler.env.ISourceType;
import org.eclipse.dltk.mod.internal.compiler.env.AccessRestriction;

public class NameEnvironmentAnswer {
    private ISourceModule compilationUnit;
    private ISourceType[] sourceTypes;
    private AccessRestriction accessRestriction;

    public NameEnvironmentAnswer(ISourceModule compilationUnit, AccessRestriction accessRestriction) {
        this.compilationUnit = compilationUnit;
        this.accessRestriction = accessRestriction;
    }

    public NameEnvironmentAnswer(ISourceType[] sourceTypes, AccessRestriction accessRestriction) {
        this.sourceTypes = sourceTypes;
        this.accessRestriction = accessRestriction;
    }

    public AccessRestriction getAccessRestriction() {
        return this.accessRestriction;
    }

    public ISourceModule getSourceModule() {
        return this.compilationUnit;
    }

    public ISourceType[] getSourceTypes() {
        return this.sourceTypes;
    }

    public boolean isSourceModule() {
        return this.compilationUnit != null;
    }

    public boolean isSourceType() {
        return this.sourceTypes != null;
    }

    public boolean ignoreIfBetter() {
        return this.accessRestriction != null && this.accessRestriction.ignoreIfBetter();
    }

    public boolean isBetter(NameEnvironmentAnswer otherAnswer) {
        if (otherAnswer == null) {
            return true;
        }
        if (this.accessRestriction == null) {
            return true;
        }
        return otherAnswer.accessRestriction != null && this.accessRestriction.getProblemId() < otherAnswer.accessRestriction.getProblemId();
    }
}

