/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelOperation;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.MultiOperation;
import org.eclipse.dltk.mod.internal.core.util.Messages;

public class CopyElementsOperation
extends MultiOperation {
    public CopyElementsOperation(IModelElement[] elementsToCopy, IModelElement[] destContainers, boolean force) {
        super(elementsToCopy, destContainers, force);
    }

    public CopyElementsOperation(IModelElement[] elementsToCopy, IModelElement destContainer, boolean force) {
        this(elementsToCopy, new IModelElement[]{destContainer}, force);
    }

    @Override
    protected String getMainTaskName() {
        return Messages.operation_copyElementProgress;
    }

    protected ModelOperation getNestedOperation(IModelElement element) {
        return null;
    }

    protected boolean isRenamingMainType(IModelElement element, IModelElement dest) throws ModelException {
        if ((this.isRename() || this.getNewNameFor(element) != null) && dest.getElementType() == 5) {
            String typeName = dest.getElementName();
            if (DLTKCore.DEBUG) {
                System.err.println("TODO:Add extension remove code here...");
            }
            return element.getElementName().equals(typeName) && element.getParent().equals(dest);
        }
        return false;
    }

    @Override
    protected void processElement(IModelElement element) throws ModelException {
        ModelOperation op = this.getNestedOperation(element);
        if (op == null) {
            return;
        }
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add CreateElementInCUOperation");
        }
        this.executeNestedOperation(op, 1);
        ModelElement destination = (ModelElement)this.getDestinationParent(element);
        ISourceModule unit = destination.getSourceModule();
        if (!unit.isWorkingCopy()) {
            unit.close();
        }
    }

    @Override
    protected IModelStatus verify() {
        IModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.renamingsList != null && this.renamingsList.length != this.elementsToProcess.length) {
            return new ModelStatus(980);
        }
        return ModelStatus.VERIFIED_OK;
    }

    @Override
    protected void verify(IModelElement element) throws ModelException {
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.getElementType() < 7) {
            this.error(967, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        IModelElement dest = this.getDestinationParent(element);
        this.verifyDestination(element, dest);
        this.verifySibling(element, dest);
        if (this.renamingsList != null) {
            this.verifyRenaming(element);
        }
    }
}

