/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.util;

import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ITypeHierarchy;
import org.eclipse.dltk.mod.core.ModelException;

public class MethodOverrideTester {
    private final IType fFocusType;
    private final ITypeHierarchy fHierarchy;

    public MethodOverrideTester(IType focusType, ITypeHierarchy hierarchy) {
        this.fFocusType = focusType;
        this.fHierarchy = hierarchy;
    }

    public IType getFocusType() {
        return this.fFocusType;
    }

    public ITypeHierarchy getTypeHierarchy() {
        return this.fHierarchy;
    }

    public IMethod findDeclaringMethod(IMethod overriding, boolean testVisibility) throws ModelException {
        IMethod result = null;
        IMethod overridden = this.findOverriddenMethod(overriding, testVisibility);
        while (overridden != null) {
            result = overridden;
            overridden = this.findOverriddenMethod(result, testVisibility);
        }
        return result;
    }

    public IMethod findOverriddenMethod(IMethod overriding, boolean testVisibility) throws ModelException {
        int flags = overriding.getFlags();
        if (Flags.isPrivate(flags) || Flags.isStatic(flags) || overriding.isConstructor()) {
            return null;
        }
        IType type = overriding.getDeclaringType();
        IType[] superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null) {
            int q = 0;
            while (q < superClass.length) {
                IMethod res = this.findOverriddenMethodInHierarchy(superClass[q], overriding);
                if (res != null && !Flags.isPrivate(res.getFlags())) {
                    return res;
                }
                ++q;
            }
        }
        return null;
    }

    public IMethod findOverriddenMethodInHierarchy(IType type, IMethod overriding) throws ModelException {
        IMethod method = this.findOverriddenMethodInType(type, overriding);
        if (method != null) {
            return method;
        }
        IType[] superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null) {
            int q = 0;
            while (q < superClass.length) {
                IMethod res = this.findOverriddenMethodInHierarchy(superClass[q], overriding);
                if (res != null) {
                    return res;
                }
                ++q;
            }
        }
        return method;
    }

    public IMethod findOverriddenMethodInType(IType overriddenType, IMethod overriding) throws ModelException {
        IMethod[] overriddenMethods = overriddenType.getMethods();
        int i = 0;
        while (i < overriddenMethods.length) {
            if (this.isSubsignature(overriding, overriddenMethods[i])) {
                return overriddenMethods[i];
            }
            ++i;
        }
        return null;
    }

    public IMethod findOverridingMethodInType(IType overridingType, IMethod overridden) throws ModelException {
        IMethod[] overridingMethods = overridingType.getMethods();
        int i = 0;
        while (i < overridingMethods.length) {
            if (this.isSubsignature(overridingMethods[i], overridden)) {
                return overridingMethods[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isSubsignature(IMethod overriding, IMethod overridden) throws ModelException {
        return overridden.getElementName().equals(overriding.getElementName());
    }
}

