/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.commands;

import org.eclipse.dltk.mod.dbgp.IDbgpProperty;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpBaseCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.mod.dbgp.internal.utils.DbgpXmlEntityParser;
import org.eclipse.dltk.mod.dbgp.internal.utils.DbgpXmlParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpExtendedCommands
extends DbgpBaseCommands
implements IDbgpExtendedCommands {
    static final String DEPTH_OPTION = "-d";

    private IDbgpProperty parseResponse(Element response) {
        if (DbgpXmlParser.parseSuccess(response)) {
            NodeList list = response.getElementsByTagName("property");
            return DbgpXmlEntityParser.parseProperty((Element)list.item(0));
        }
        return null;
    }

    public DbgpExtendedCommands(IDbgpCommunicator communicator) throws DbgpException {
        super(communicator);
    }

    @Override
    public boolean makeBreak() throws DbgpException {
        return DbgpXmlParser.parseSuccess(this.communicate(this.createAsyncRequest("break")));
    }

    @Override
    public boolean configureStdin(int value) throws DbgpException {
        DbgpRequest request = this.createRequest("stdin");
        request.addOption("-c", value);
        return DbgpXmlParser.parseSuccess(this.communicate(request));
    }

    @Override
    public boolean sendStdin(String data) throws DbgpException {
        DbgpRequest request = this.createRequest("stdin");
        request.setData(data);
        return DbgpXmlParser.parseSuccess(this.communicate(request));
    }

    @Override
    public IDbgpProperty evaluate(String snippet) throws DbgpException {
        DbgpRequest request = this.createRequest("eval");
        request.setData(snippet);
        return this.parseResponse(this.communicate(request));
    }

    @Override
    public IDbgpProperty evaluate(String snippet, int depth) throws DbgpException {
        DbgpRequest request = this.createRequest("eval");
        request.addOption(DEPTH_OPTION, depth);
        request.setData(snippet);
        return this.parseResponse(this.communicate(request));
    }

    @Override
    public IDbgpProperty expression(String expression) throws DbgpException {
        DbgpRequest request = this.createRequest("expr");
        request.setData(expression);
        return this.parseResponse(this.communicate(request));
    }

    @Override
    public IDbgpProperty execute(String code) throws DbgpException {
        DbgpRequest request = this.createRequest("exec");
        request.setData(code);
        return this.parseResponse(this.communicate(request));
    }
}

