/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.formatter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.formatter.FormatterUtils;
import org.eclipse.dltk.mod.formatter.IFormatterCallback;
import org.eclipse.dltk.mod.formatter.IFormatterContext;
import org.eclipse.dltk.mod.formatter.IFormatterDocument;
import org.eclipse.dltk.mod.formatter.IFormatterRawWriter;
import org.eclipse.dltk.mod.formatter.IFormatterWriter;
import org.eclipse.dltk.mod.formatter.internal.ExcludeRegionList;
import org.eclipse.dltk.mod.ui.formatter.IFormatterIndentGenerator;
import org.eclipse.dltk.mod.utils.TextUtils;
import org.eclipse.jface.text.IRegion;

public class FormatterWriter
implements IFormatterWriter {
    private final StringBuffer writer = new StringBuffer();
    private final StringBuffer indent = new StringBuffer();
    private final StringBuffer callbackBuffer = new StringBuffer();
    private final StringBuffer emptyLines = new StringBuffer();
    private boolean lineStarted = false;
    private char lastChar = '\u0000';
    private int lineNumber = 0;
    private final List newLineCallbacks = new ArrayList();
    private final String lineDelimiter;
    private final IFormatterDocument document;
    private final IFormatterIndentGenerator indentGenerator;
    private int linesPreserve = -1;
    private int wrapLength = -1;
    private final ExcludeRegionList excludes = new ExcludeRegionList();

    public FormatterWriter(IFormatterDocument document, String lineDelimiter, IFormatterIndentGenerator indentGenerator) {
        this.document = document;
        this.lineDelimiter = lineDelimiter;
        this.indentGenerator = indentGenerator;
    }

    @Override
    public void ensureLineStarted(IFormatterContext context) throws Exception {
        if (!this.lineStarted) {
            this.startLine(context);
        }
    }

    @Override
    public void write(IFormatterContext context, int startOffset, int endOffset) throws Exception {
        if (!this.excludes.isExcluded(startOffset, endOffset)) {
            this.write(context, this.document.get(startOffset, endOffset));
        } else {
            IRegion[] regions = this.excludes.selectValidRanges(startOffset, endOffset);
            int i = 0;
            while (i < regions.length) {
                this.write(context, this.document.get(regions[i]));
                ++i;
            }
        }
    }

    protected void write(IFormatterContext context, String text) throws IOException {
        if (!context.isWrapping()) {
            int i = 0;
            while (i < text.length()) {
                this.write(context, text.charAt(i));
                ++i;
            }
        } else {
            int start = this.findLineStart();
            int offset = this.lineStarted ? this.calculateOffset(start) : 0;
            int savedLineNumber = this.lineNumber;
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                if (this.lineStarted && !FormatterUtils.isSpace(ch) && !FormatterUtils.isLineSeparator(ch)) {
                    if (savedLineNumber != this.lineNumber) {
                        start = this.findLineStart();
                        offset = this.calculateOffset(start);
                        savedLineNumber = this.lineNumber;
                    }
                    if (this.wrapLength > 0 && offset > this.wrapLength) {
                        int begin = start;
                        while (begin < this.writer.length() && FormatterUtils.isSpace(this.writer.charAt(begin))) {
                            ++begin;
                        }
                        if (begin < this.writer.length() && this.writer.charAt(begin) == '#') {
                            ++begin;
                        }
                        while (begin < this.writer.length() && FormatterUtils.isSpace(this.writer.charAt(begin))) {
                            ++begin;
                        }
                        int wordBegin = this.writer.length();
                        while (wordBegin > begin && !FormatterUtils.isSpace(this.writer.charAt(wordBegin - 1))) {
                            --wordBegin;
                        }
                        int prevWordEnd = wordBegin;
                        while (prevWordEnd > begin && FormatterUtils.isSpace(this.writer.charAt(prevWordEnd - 1))) {
                            --prevWordEnd;
                        }
                        if (prevWordEnd > begin) {
                            this.writer.replace(prevWordEnd, wordBegin, String.valueOf(this.lineDelimiter) + "# ");
                            start = prevWordEnd + this.lineDelimiter.length();
                            offset = this.calculateOffset(start);
                        }
                    }
                }
                this.write(context, ch);
                ++offset;
                ++i;
            }
        }
    }

    private int calculateOffset(int pos) {
        int offset = 0;
        while (pos < this.writer.length()) {
            char ch;
            if ((ch = this.writer.charAt(pos++)) == '\t') {
                int tabSize = this.indentGenerator.getTabSize();
                offset = (offset + tabSize - 1) / tabSize * tabSize;
                continue;
            }
            ++offset;
        }
        return offset;
    }

    private int findLineStart() {
        int pos = this.writer.length();
        while (pos > 0 && !FormatterUtils.isLineSeparator(this.writer.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    protected void write(IFormatterContext context, char ch) throws IOException {
        if (ch == '\n' || ch == '\r') {
            if (this.lineStarted) {
                this.writer.append(ch);
                this.lineStarted = false;
                if (!this.newLineCallbacks.isEmpty()) {
                    this.executeNewLineCallbacks(context);
                    assert (this.newLineCallbacks.isEmpty());
                }
            } else if (ch == '\n' && this.lastChar == '\r') {
                if (this.emptyLines.length() == 0) {
                    this.writer.append(ch);
                } else {
                    this.emptyLines.append(ch);
                }
            } else {
                this.indent.setLength(0);
                this.emptyLines.append(ch);
            }
        } else if (!this.lineStarted) {
            if (Character.isWhitespace(ch)) {
                this.indent.append(ch);
            } else {
                this.startLine(context);
                this.writer.append(ch);
            }
        } else {
            this.writer.append(ch);
        }
        this.lastChar = ch;
    }

    private void executeNewLineCallbacks(IFormatterContext context) {
        IFormatterRawWriter callbackWriter = new IFormatterRawWriter(){

            @Override
            public void writeIndent(IFormatterContext context) {
                FormatterWriter.this.writeIndent(context, FormatterWriter.this.callbackBuffer);
            }

            @Override
            public void writeText(IFormatterContext context, String text) {
                FormatterWriter.this.callbackBuffer.append(text);
            }
        };
        ArrayList copy = new ArrayList(this.newLineCallbacks);
        this.newLineCallbacks.clear();
        for (IFormatterCallback callback : copy) {
            callback.call(context, callbackWriter);
        }
    }

    private void startLine(IFormatterContext context) throws IOException {
        if (this.callbackBuffer.length() != 0) {
            this.writer.append(this.callbackBuffer);
            this.callbackBuffer.setLength(0);
        }
        if (context.getBlankLines() >= 0) {
            if (this.writer.length() != 0) {
                int i = 0;
                while (i < context.getBlankLines()) {
                    this.writer.append(this.lineDelimiter);
                    ++i;
                }
            }
            context.resetBlankLines();
        } else if (this.emptyLines.length() != 0) {
            this.writeEmptyLines();
        }
        this.emptyLines.setLength(0);
        if (context.isIndenting()) {
            this.writeIndent(context);
        } else {
            this.writer.append(this.indent);
        }
        this.indent.setLength(0);
        this.lineStarted = true;
        ++this.lineNumber;
    }

    private void writeEmptyLines() {
        if (this.linesPreserve >= 0 && this.linesPreserve < Integer.MAX_VALUE && TextUtils.countLines((CharSequence)this.emptyLines) > this.linesPreserve) {
            this.writer.append(TextUtils.selectHeadLines((CharSequence)this.emptyLines, (int)this.linesPreserve));
        } else {
            this.writer.append(this.emptyLines);
        }
    }

    protected void writeIndent(IFormatterContext context) {
        this.writeIndent(context, this.writer);
    }

    protected void writeIndent(IFormatterContext context, StringBuffer buffer) {
        this.indentGenerator.generateIndent(context.getIndent(), buffer);
    }

    public String getOutput() {
        return this.writer.toString();
    }

    @Override
    public void excludeRegion(IRegion region) {
        this.excludes.excludeRegion(region);
    }

    @Override
    public void addNewLineCallback(IFormatterCallback callback) {
        this.newLineCallbacks.add(callback);
    }

    public void flush(IFormatterContext context) {
        if (!this.newLineCallbacks.isEmpty()) {
            if (this.lineStarted) {
                this.writer.append(this.lineDelimiter);
                this.lineStarted = false;
            }
            this.executeNewLineCallbacks(context);
            assert (this.newLineCallbacks.isEmpty());
        }
        if (this.callbackBuffer.length() != 0) {
            this.writer.append(this.callbackBuffer);
            this.callbackBuffer.setLength(0);
        }
        if (this.emptyLines.length() != 0) {
            this.writeEmptyLines();
            this.emptyLines.setLength(0);
        }
    }

    public void setLinesPreserve(int value) {
        this.linesPreserve = value;
    }

    public int getWrapLength() {
        return this.wrapLength;
    }

    public void setWrapLength(int wrapLength) {
        this.wrapLength = wrapLength;
    }
}

