/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.launching;

public class ListenerList {
    private int fSize;
    private Object[] fListeners = null;
    private static final Object[] EmptyArray = new Object[0];

    public ListenerList(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.fListeners = new Object[capacity];
        this.fSize = 0;
    }

    public synchronized void add(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.fSize) {
            if (this.fListeners[i] == listener) {
                return;
            }
            ++i;
        }
        if (this.fSize == this.fListeners.length) {
            Object[] temp = new Object[this.fSize * 2 + 1];
            System.arraycopy(this.fListeners, 0, temp, 0, this.fSize);
            this.fListeners = temp;
        }
        this.fListeners[this.fSize++] = listener;
    }

    public synchronized Object[] getListeners() {
        if (this.fSize == 0) {
            return EmptyArray;
        }
        Object[] result = new Object[this.fSize];
        System.arraycopy(this.fListeners, 0, result, 0, this.fSize);
        return result;
    }

    public synchronized void remove(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.fSize) {
            if (this.fListeners[i] == listener) {
                if (--this.fSize == 0) {
                    this.fListeners = new Object[1];
                } else {
                    if (i < this.fSize) {
                        this.fListeners[i] = this.fListeners[this.fSize];
                    }
                    this.fListeners[this.fSize] = null;
                }
                return;
            }
            ++i;
        }
    }

    public void removeAll() {
        this.fListeners = new Object[0];
        this.fSize = 0;
    }

    public int size() {
        return this.fSize;
    }
}

