/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.launching;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.environment.IDeployment;
import org.eclipse.dltk.mod.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.IScriptProcessHandler;
import org.eclipse.dltk.mod.launching.Messages;

public class InternalScriptExecutor {
    private IScriptProcessHandler handler;
    private IInterpreterInstall install;

    public InternalScriptExecutor(IInterpreterInstall install, IScriptProcessHandler handler) {
        Assert.isNotNull((Object)install, (String)Messages.InternalScriptExecutor_iInterpreterInstallMustNotBeNull);
        Assert.isNotNull((Object)handler, (String)Messages.InternalScriptExecutor_iProcessHandlerMustNotBeNull);
        this.install = install;
        this.handler = handler;
    }

    public IScriptProcessHandler.ScriptResult execute(IInternalScriptDeployer deployer, String[] interpreterArgs, String[] scriptArgs, char[] stdin) throws CoreException, IOException {
        IExecutionEnvironment execEnv = this.install.getExecEnvironment();
        IDeployment deployment = execEnv.createDeployment();
        IPath deploymentPath = deployer.deployScript(deployment);
        try {
            IScriptProcessHandler.ScriptResult result;
            IFileHandle interpreter = this.install.getInstallLocation();
            IFileHandle script = deployment.getFile(deploymentPath);
            String[] cmdLine = this.buildCommandLine(interpreter, interpreterArgs, script, scriptArgs);
            Process process = execEnv.exec(cmdLine, null, null);
            IScriptProcessHandler.ScriptResult scriptResult = result = this.handler.handle(process, stdin);
            return scriptResult;
        }
        finally {
            deployment.dispose();
        }
    }

    private void addArgs(ArrayList list, String[] args) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                list.add(args[i]);
                ++i;
            }
        }
    }

    private String[] buildCommandLine(IFileHandle interpreter, String[] interpreterArgs, IFileHandle script, String[] scriptArgs) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(interpreter.getCanonicalPath());
        this.addArgs(cmdLine, interpreterArgs);
        cmdLine.add(script.getCanonicalPath());
        this.addArgs(cmdLine, scriptArgs);
        return cmdLine.toArray(new String[cmdLine.size()]);
    }

    public static interface IInternalScriptDeployer {
        public IPath deployScript(IDeployment var1) throws IOException;
    }
}

