/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.core.search.MethodNameMatch;
import org.eclipse.dltk.mod.core.search.SearchEngine;
import org.eclipse.dltk.mod.internal.corext.util.Strings;
import org.eclipse.dltk.mod.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.mod.internal.ui.dialogs.MethodInfoViewer;
import org.eclipse.dltk.mod.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.mod.internal.ui.util.MethodNameMatchLabelProvider;
import org.eclipse.dltk.mod.internal.ui.util.SWTUtil;
import org.eclipse.dltk.mod.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.dialogs.ITypeSelectionComponent;
import org.eclipse.dltk.mod.ui.util.PixelConverter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class MethodSelectionComponent
extends Composite
implements ITypeSelectionComponent {
    private IDialogSettings fSettings;
    private boolean fMultipleSelection;
    private ITitleLabel fTitleLabel;
    private ToolBar fToolBar;
    private ToolItem fToolItem;
    private MenuManager fMenuManager;
    private WorkingSetFilterActionGroup fFilterActionGroup;
    private Text fFilter;
    private String fInitialFilterText;
    private IDLTKSearchScope fScope;
    private MethodInfoViewer fViewer;
    private ViewForm fForm;
    private CLabel fLabel;
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private static final String DIALOG_SETTINGS = "org.eclipse.jdt.internal.ui.dialogs.TypeSelectionComponent";
    private static final String SHOW_STATUS_LINE = "show_status_line";
    private static final String WORKINGS_SET_SETTINGS = "workingset_settings";
    private IDLTKUILanguageToolkit fToolkit;

    public MethodSelectionComponent(Composite parent, int style, String message, boolean multi, IDLTKSearchScope scope, int elementKind, String initialFilter, ITitleLabel titleLabel, IDLTKUILanguageToolkit toolkit) {
        super(parent, style);
        this.fToolkit = toolkit;
        this.setFont(parent.getFont());
        this.fMultipleSelection = multi;
        this.fScope = scope;
        this.fInitialFilterText = initialFilter;
        this.fTitleLabel = titleLabel;
        IDialogSettings settings = DLTKUIPlugin.getDefault().getDialogSettings();
        this.fSettings = settings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            settings.addSection(this.fSettings);
        }
        if (this.fSettings.get(SHOW_STATUS_LINE) == null) {
            this.fSettings.put(SHOW_STATUS_LINE, true);
        }
        this.createContent(message, elementKind);
    }

    @Override
    public void triggerSearch() {
        this.fViewer.forceSearch();
    }

    public MethodNameMatch[] getSelection() {
        return this.fViewer.getSelection();
    }

    public IDLTKSearchScope getScope() {
        return this.fScope;
    }

    private void createContent(final String message, int elementKind) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Font font = this.getFont();
        Control header = this.createHeader(this, font, message);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        header.setLayoutData((Object)gd);
        this.fFilter = new Text((Composite)this, 0x800800);
        this.fFilter.setFont(font);
        if (this.fInitialFilterText != null) {
            this.fFilter.setText(this.fInitialFilterText);
        }
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fFilter.setLayoutData((Object)gd);
        this.fFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodSelectionComponent.this.patternChanged((Text)e.widget);
            }
        });
        this.fFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    MethodSelectionComponent.this.fViewer.setFocus();
                }
            }
        });
        this.fFilter.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Strings.removeMnemonicIndicator(message);
            }
        });
        TextFieldNavigationHandler.install(this.fFilter);
        Label label = new Label((Composite)this, 0);
        label.setFont(font);
        label.setText(DLTKUIMessages.MethodSelectionComponent_label);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    MethodSelectionComponent.this.fViewer.setFocus();
                }
            }
        });
        label = new Label((Composite)this, 131072);
        label.setFont(font);
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.fViewer = new MethodInfoViewer(this, this.fMultipleSelection ? 2 : 0, label, this.fScope, elementKind, this.fInitialFilterText, this.fToolkit);
        gd = new GridData(1808);
        final Table table = this.fViewer.getTable();
        PixelConverter converter = new PixelConverter((Control)table);
        gd.widthHint = converter.convertWidthInCharsToPixels(70);
        gd.heightHint = SWTUtil.getTableHeightHint(table, 10);
        gd.horizontalSpan = 2;
        table.setLayoutData((Object)gd);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (table.getSelectionCount() == 0) {
                    e.result = Strings.removeMnemonicIndicator(DLTKUIMessages.MethodSelectionComponent_label);
                }
            }
        });
        if (!this.fMultipleSelection) {
            this.fForm = new ViewForm((Composite)this, 0x800800);
            this.fForm.setFont(font);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            boolean showStatusLine = this.fSettings.getBoolean(SHOW_STATUS_LINE);
            gd.exclude = !showStatusLine;
            this.fForm.setVisible(showStatusLine);
            this.fForm.setLayoutData((Object)gd);
            this.fLabel = new CLabel((Composite)this.fForm, 0x800000);
            this.fLabel.setFont(this.fForm.getFont());
            this.fForm.setContent((Control)this.fLabel);
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private MethodNameMatchLabelProvider fLabelProvider;
                {
                    this.fLabelProvider = new MethodNameMatchLabelProvider(40, MethodSelectionComponent.this.fToolkit);
                }

                public void widgetSelected(SelectionEvent event) {
                    MethodNameMatch[] selection = MethodSelectionComponent.this.fViewer.getSelection();
                    if (selection.length != 1) {
                        MethodSelectionComponent.this.fLabel.setText("");
                        MethodSelectionComponent.this.fLabel.setImage(null);
                    } else {
                        MethodNameMatch type = selection[0];
                        MethodSelectionComponent.this.fLabel.setText(MethodSelectionComponent.this.fViewer.getLabelProvider().getQualificationText(type));
                        MethodSelectionComponent.this.fLabel.setImage(this.fLabelProvider.getImage(type));
                    }
                }
            });
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                MethodSelectionComponent.this.disposeComponent();
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fViewer.getTable().addSelectionListener(listener);
    }

    public void populate(int selectionMode) {
        if (this.fInitialFilterText != null) {
            switch (selectionMode) {
                case 1: {
                    this.fFilter.setSelection(0, 0);
                    break;
                }
                case 2: {
                    this.fFilter.setSelection(0, this.fInitialFilterText.length());
                }
            }
        }
        this.fFilter.setFocus();
        this.fViewer.startup();
    }

    private void patternChanged(Text text) {
        this.fViewer.setSearchPattern(text.getText());
    }

    private Control createHeader(Composite parent, Font font, String message) {
        Composite header = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        header.setFont(font);
        Label label = new Label(header, 0);
        label.setText(message);
        label.setFont(font);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    MethodSelectionComponent.this.fFilter.setFocus();
                }
            }
        });
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.createViewMenu(header);
        return header;
    }

    private void createViewMenu(Composite parent) {
        this.fToolBar = new ToolBar(parent, 0x800000);
        this.fToolItem = new ToolItem(this.fToolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.fToolBar.setLayoutData((Object)data);
        this.fToolItem.setImage(DLTKPluginImages.DESC_ELCL_VIEW_MENU.createImage());
        this.fToolItem.setDisabledImage(DLTKPluginImages.DESC_DLCL_VIEW_MENU.createImage());
        this.fToolItem.setToolTipText(DLTKUIMessages.TypeSelectionComponent_menu);
        this.fToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodSelectionComponent.this.showViewMenu();
            }
        });
        this.fMenuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.fMenuManager);
    }

    private void showViewMenu() {
        Menu menu = this.fMenuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.fToolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.fToolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    private void fillViewMenu(IMenuManager viewMenu) {
        if (!this.fMultipleSelection) {
            ToggleStatusLineAction showStatusLineAction = new ToggleStatusLineAction();
            showStatusLineAction.setChecked(this.fSettings.getBoolean(SHOW_STATUS_LINE));
            viewMenu.add((IAction)showStatusLineAction);
        }
        if (this.fScope == null) {
            IWorkingSet ws;
            this.fFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), DLTKUIPlugin.getActivePage(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    IWorkingSet ws = (IWorkingSet)event.getNewValue();
                    if (ws == null || ws.isAggregateWorkingSet() && ws.isEmpty()) {
                        MethodSelectionComponent.this.fScope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)MethodSelectionComponent.this.fToolkit.getCoreToolkit());
                        MethodSelectionComponent.this.fTitleLabel.setText(null);
                    } else {
                        MethodSelectionComponent.this.fScope = DLTKSearchScopeFactory.getInstance().createSearchScope(ws, true, MethodSelectionComponent.this.fToolkit.getCoreToolkit());
                        MethodSelectionComponent.this.fTitleLabel.setText(ws.getLabel());
                    }
                    MethodSelectionComponent.this.fViewer.setSearchScope(MethodSelectionComponent.this.fScope, true);
                }
            });
            String setting = this.fSettings.get(WORKINGS_SET_SETTINGS);
            if (setting != null) {
                try {
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                    this.fFilterActionGroup.restoreState((IMemento)memento);
                }
                catch (WorkbenchException workbenchException) {}
            }
            if ((ws = this.fFilterActionGroup.getWorkingSet()) == null || ws.isAggregateWorkingSet() && ws.isEmpty()) {
                this.fScope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.fToolkit.getCoreToolkit());
                this.fTitleLabel.setText(null);
            } else {
                this.fScope = DLTKSearchScopeFactory.getInstance().createSearchScope(ws, true, this.fToolkit.getCoreToolkit());
                this.fTitleLabel.setText(ws.getLabel());
            }
            this.fFilterActionGroup.fillViewMenu(viewMenu);
        }
    }

    private void disposeComponent() {
        if (this.fFilterActionGroup != null) {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSet");
            this.fFilterActionGroup.saveState((IMemento)memento);
            this.fFilterActionGroup.dispose();
            StringWriter writer = new StringWriter();
            try {
                memento.save((Writer)writer);
                this.fSettings.put(WORKINGS_SET_SETTINGS, writer.getBuffer().toString());
            }
            catch (IOException iOException) {}
        }
    }

    public static interface ITitleLabel {
        public void setText(String var1);
    }

    private class ToggleStatusLineAction
    extends Action {
        public ToggleStatusLineAction() {
            super(DLTKUIMessages.TypeSelectionComponent_show_status_line_label, 2);
        }

        public void run() {
            if (MethodSelectionComponent.this.fForm == null) {
                return;
            }
            GridData gd = (GridData)MethodSelectionComponent.this.fForm.getLayoutData();
            boolean checked = this.isChecked();
            gd.exclude = !checked;
            MethodSelectionComponent.this.fForm.setVisible(checked);
            MethodSelectionComponent.this.fSettings.put(MethodSelectionComponent.SHOW_STATUS_LINE, checked);
            MethodSelectionComponent.this.layout();
        }
    }
}

