/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui;

import java.util.List;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.PriorityClassDLTKExtensionManager;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.search.ISearchQueryFactory;
import org.eclipse.dltk.mod.ui.viewsupport.ScriptUILabelProvider;

public class DLTKUILanguageManager
extends PriorityClassDLTKExtensionManager {
    private static DLTKUILanguageManager instance = new DLTKUILanguageManager();
    private static final String LANGUAGE_EXTPOINT = "org.eclipse.dltk.mod.ui.language";
    private static final String SEARCH_QUERY_FACTORY_EXTPOINT = "org.eclipse.dltk.mod.ui.searchQueryFactories";
    private static PriorityClassDLTKExtensionManager searchQueryFactoryManager = DLTKUILanguageManager.createManager("org.eclipse.dltk.mod.ui.searchQueryFactories");

    private static PriorityClassDLTKExtensionManager createManager(String point) {
        return new PriorityClassDLTKExtensionManager(point);
    }

    private DLTKUILanguageManager() {
        super(LANGUAGE_EXTPOINT);
    }

    public static IDLTKUILanguageToolkit[] getLanguageToolkits() {
        List toolkits = instance.getObjectList();
        return toolkits.toArray(new IDLTKUILanguageToolkit[toolkits.size()]);
    }

    public static IDLTKUILanguageToolkit getLanguageToolkit(String natureId) {
        return (IDLTKUILanguageToolkit)instance.getObject(natureId);
    }

    public static IDLTKUILanguageToolkit getLanguageToolkit(IModelElement element) {
        IDLTKLanguageToolkit coreToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
        if (coreToolkit != null) {
            return (IDLTKUILanguageToolkit)instance.getObject(coreToolkit.getNatureId());
        }
        return null;
    }

    public static ScriptUILabelProvider createLabelProvider(IModelElement element) {
        ScriptUILabelProvider provider;
        IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit(element);
        if (languageToolkit != null && (provider = languageToolkit.createScriptUILabelProvider()) != null) {
            return provider;
        }
        return new ScriptUILabelProvider();
    }

    public static ScriptUILabelProvider createLabelProvider(String nature) {
        ScriptUILabelProvider provider;
        IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit(nature);
        if (languageToolkit != null && (provider = languageToolkit.createScriptUILabelProvider()) != null) {
            return provider;
        }
        return new ScriptUILabelProvider();
    }

    public static IDLTKUILanguageToolkit getLanguageToolkitLower(String natureId) {
        return (IDLTKUILanguageToolkit)instance.getObjectLower(natureId);
    }

    public static ISearchQueryFactory getSearchQueryFactory(String natureId) {
        return (ISearchQueryFactory)DLTKUILanguageManager.getSearchQueryFactoryManager().getObject(natureId);
    }

    public static PriorityClassDLTKExtensionManager getSearchQueryFactoryManager() {
        return searchQueryFactoryManager;
    }
}

