/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.mod.core.DLTKContributionExtensionManager;
import org.eclipse.dltk.mod.core.IDLTKContributedExtension;
import org.eclipse.dltk.mod.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.mod.core.IPreferencesSaveDelegate;
import org.eclipse.dltk.mod.core.PreferencesLookupDelegate;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.mod.internal.ui.preferences.ScriptSourcePreviewerUpdater;
import org.eclipse.dltk.mod.internal.ui.text.DLTKColorManager;
import org.eclipse.dltk.mod.ui.DLTKUILanguageManager;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.formatter.FormatterMessages;
import org.eclipse.dltk.mod.ui.formatter.FormatterPreviewUtils;
import org.eclipse.dltk.mod.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.mod.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.mod.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.mod.ui.formatter.ScriptFormatterManager;
import org.eclipse.dltk.mod.ui.preferences.AbstractConfigurationBlockPropertyAndPreferencePage;
import org.eclipse.dltk.mod.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.mod.ui.preferences.ComboViewerBlock;
import org.eclipse.dltk.mod.ui.preferences.ContributedExtensionOptionsBlock;
import org.eclipse.dltk.mod.ui.preferences.PreferenceKey;
import org.eclipse.dltk.mod.ui.text.IColorManager;
import org.eclipse.dltk.mod.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.mod.ui.util.IStatusChangeListener;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractFormatterPreferencePage
extends AbstractConfigurationBlockPropertyAndPreferencePage {
    private final Map prefKeys = new HashMap();

    @Override
    protected AbstractOptionsBlock createOptionsBlock(IStatusChangeListener newStatusChangedListener, IProject project, IWorkbenchPreferenceContainer container) {
        return new FormatterSelectionBlock(newStatusChangedListener, project, container);
    }

    protected PreferenceKey[] collectPreferenceKeys() {
        ArrayList<PreferenceKey> result = new ArrayList<PreferenceKey>();
        result.add(this.getFormatterPreferenceKey());
        IDLTKContributedExtension[] extensions = ScriptFormatterManager.getInstance().getContributions(this.getNatureId());
        int i = 0;
        while (i < extensions.length) {
            IScriptFormatterFactory factory = (IScriptFormatterFactory)extensions[i];
            PreferenceKey[] keys = factory.getPreferenceKeys();
            if (keys != null) {
                HashMap<PreferenceKey, PreferenceKey> keyMap = new HashMap<PreferenceKey, PreferenceKey>();
                int j = 0;
                while (j < keys.length) {
                    PreferenceKey prefKey = keys[j];
                    keyMap.put(prefKey, prefKey);
                    result.add(prefKey);
                    ++j;
                }
                this.prefKeys.put(factory, keyMap);
            }
            ++i;
        }
        return result.toArray(new PreferenceKey[result.size()]);
    }

    protected abstract ScriptSourceViewerConfiguration createSimpleSourceViewerConfiguration(IColorManager var1, IPreferenceStore var2, ITextEditor var3, boolean var4);

    @Override
    protected abstract String getNatureId();

    protected abstract PreferenceKey getFormatterPreferenceKey();

    protected abstract IDialogSettings getDialogSettings();

    @Override
    protected String getHelpId() {
        return null;
    }

    @Override
    protected void setDescription() {
    }

    @Override
    protected String getPreferencePageId() {
        return null;
    }

    @Override
    protected String getProjectHelpId() {
        return null;
    }

    @Override
    protected String getPropertyPageId() {
        return null;
    }

    protected class FormatterSelectionBlock
    extends ContributedExtensionOptionsBlock {
        private IColorManager fColorManager;
        private ISourceViewer fPreviewViewer;
        private Button modifyButton;
        private final Map formatterPrefs;

        public FormatterSelectionBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
            super(context, project, AbstractFormatterPreferencePage.this.collectPreferenceKeys(), container);
            this.formatterPrefs = new IdentityHashMap();
            this.fColorManager = new DLTKColorManager(false);
        }

        @Override
        public void dispose() {
            this.fColorManager.dispose();
            super.dispose();
        }

        @Override
        protected DLTKContributionExtensionManager getExtensionManager() {
            return ScriptFormatterManager.getInstance();
        }

        @Override
        protected int getSelectorGroupColumns() {
            return 3;
        }

        @Override
        protected ComboViewerBlock createComboViewerBlock(Composite group) {
            ComboViewerBlock combo = super.createComboViewerBlock(group);
            this.modifyButton = SWTFactory.createPushButton(group, FormatterMessages.FormatterPreferencePage_edit, null);
            this.modifyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormatterSelectionBlock.this.editButtonPressed();
                }
            });
            return combo;
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.modifyButton.setEnabled(this.getExtensionManager().getContributions(this.getNatureId()).length != 0);
        }

        protected void editButtonPressed() {
            IFormatterModifyDialog dialog;
            IScriptFormatterFactory factory = (IScriptFormatterFactory)this.getSelectedExtension();
            if (factory != null && (dialog = factory.createDialog(new FormatterModifyDialogOwner())) != null) {
                Map preferences;
                Map oldPrefs = this.getFormatterPrefs(factory);
                dialog.setPreferences(oldPrefs);
                if (dialog.open() == 0 && !(preferences = dialog.getPreferences()).equals(oldPrefs)) {
                    factory.savePreferences(preferences, new SaveDelegate((Map)AbstractFormatterPreferencePage.this.prefKeys.get(factory)));
                    this.formatterPrefs.put(factory, preferences);
                    this.updatePreview(factory);
                }
            }
        }

        protected void saveChanges(IPreferencesSaveDelegate delegate) {
            IScriptFormatterFactory factory = (IScriptFormatterFactory)this.getSelectedExtension();
            if (factory != null && this.formatterPrefs.containsKey(factory)) {
                Map prefs = (Map)this.formatterPrefs.get(factory);
                factory.savePreferences(prefs, delegate);
            }
        }

        @Override
        protected String getSelectorGroupLabel() {
            return FormatterMessages.FormatterPreferencePage_groupName;
        }

        @Override
        protected String getSelectorNameLabel() {
            return FormatterMessages.FormatterPreferencePage_selectionLabel;
        }

        @Override
        protected void createSelectorBlock(Composite composite) {
            super.createSelectorBlock(composite);
            Group previewGroup = SWTFactory.createGroup(composite, FormatterMessages.FormatterPreferencePage_preview, 1, 1, 1808);
            this.fPreviewViewer = this.createPreview((Composite)previewGroup);
        }

        public ISourceViewer createPreview(Composite composite) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{AbstractFormatterPreferencePage.this.getPreferenceStore(), generalTextStore});
            ProjectionViewer viewer = this.createPreviewViewer(composite, null, null, false, 2816, (IPreferenceStore)store);
            if (viewer == null) {
                return null;
            }
            ScriptSourceViewerConfiguration configuration = AbstractFormatterPreferencePage.this.createSimpleSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)store, null, false);
            viewer.configure((SourceViewerConfiguration)configuration);
            if (viewer.getTextWidget().getTabs() == 0) {
                viewer.getTextWidget().setTabs(4);
            }
            new ScriptSourcePreviewerUpdater((SourceViewer)viewer, configuration, (IPreferenceStore)store);
            viewer.setEditable(false);
            Document document = new Document();
            IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit(this.getNatureId());
            toolkit.getTextTools().setupDocumentPartitioner((IDocument)document, toolkit.getPartitioningId());
            viewer.setDocument((IDocument)document);
            GridData gd = new GridData(1808);
            gd.widthHint = AbstractFormatterPreferencePage.this.convertWidthInCharsToPixels(20);
            gd.heightHint = AbstractFormatterPreferencePage.this.convertHeightInCharsToPixels(5);
            viewer.getControl().setLayoutData((Object)gd);
            return viewer;
        }

        private ProjectionViewer createPreviewViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
            return new ScriptSourceViewer(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
        }

        @Override
        protected String getPreferenceLinkMessage() {
            return FormatterMessages.FormatterPreferencePage_settingsLink;
        }

        @Override
        protected PreferenceKey getSavedContributionKey() {
            return AbstractFormatterPreferencePage.this.getFormatterPreferenceKey();
        }

        @Override
        protected String getNatureId() {
            return AbstractFormatterPreferencePage.this.getNatureId();
        }

        @Override
        protected void selectionChanged(IDLTKContributedExtension extension) {
            super.selectionChanged(extension);
            if (this.fPreviewViewer != null) {
                IScriptFormatterFactory formatterFactory = (IScriptFormatterFactory)extension;
                this.updatePreview(formatterFactory);
            }
        }

        private void updatePreview(IScriptFormatterFactory formatterFactory) {
            FormatterPreviewUtils.updatePreview(this.fPreviewViewer, formatterFactory.getPreviewContent(), formatterFactory, this.getFormatterPrefs(formatterFactory));
        }

        private Map getFormatterPrefs(IScriptFormatterFactory formatterFactory) {
            Map prefs = (Map)this.formatterPrefs.get(formatterFactory);
            if (prefs == null) {
                prefs = formatterFactory.retrievePreferences((IPreferencesLookupDelegate)new PreferencesLookupDelegate(this.getProject()));
                if (prefs != null) {
                    this.formatterPrefs.put(formatterFactory, prefs);
                } else {
                    prefs = Collections.EMPTY_MAP;
                }
            }
            return prefs;
        }

        private class FormatterModifyDialogOwner
        implements IFormatterModifyDialogOwner {
            private FormatterModifyDialogOwner() {
            }

            @Override
            public ISourceViewer createPreview(Composite composite) {
                return FormatterSelectionBlock.this.createPreview(composite);
            }

            @Override
            public Shell getShell() {
                return AbstractFormatterPreferencePage.this.getShell();
            }

            @Override
            public IDialogSettings getDialogSettings() {
                return AbstractFormatterPreferencePage.this.getDialogSettings();
            }
        }

        private class SaveDelegate
        implements IPreferencesSaveDelegate {
            final Map keyMap;

            SaveDelegate(Map keyMap) {
                this.keyMap = keyMap;
            }

            private PreferenceKey getPrefKey(String qualifier, String key) {
                PreferenceKey pkey = new PreferenceKey(qualifier, key);
                return (PreferenceKey)this.keyMap.get(pkey);
            }

            public void setBoolean(String qualifier, String key, boolean value) {
                PreferenceKey pKey = this.getPrefKey(qualifier, key);
                if (pKey != null) {
                    FormatterSelectionBlock.this.setValue(pKey, value);
                }
            }

            public void setInt(String qualifier, String key, int value) {
                PreferenceKey pKey = this.getPrefKey(qualifier, key);
                if (pKey != null) {
                    FormatterSelectionBlock.this.setValue(pKey, String.valueOf(value));
                }
            }

            public void setString(String qualifier, String key, String value) {
                PreferenceKey pKey = this.getPrefKey(qualifier, key);
                if (pKey != null) {
                    FormatterSelectionBlock.this.setValue(pKey, value);
                }
            }
        }
    }
}

