/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.af.common.error;

import java.util.regex.Pattern;
import org.eclipse.vjet.af.common.error.ErrorFilter;
import org.eclipse.vjet.af.common.error.ErrorObject;

public final class RegExErrorFilter
implements ErrorFilter {
    public static final String MATCH_ALL = ".*";
    public static final String MATCH_DOT_ANY = "\\..*";
    private Pattern m_pattern;

    public RegExErrorFilter(String regex) {
        this.m_pattern = Pattern.compile(regex);
    }

    @Override
    public boolean matches(ErrorObject errorObject) {
        if (this.m_pattern == null || errorObject == null) {
            return false;
        }
        return this.m_pattern.matcher(errorObject.getId().getFullName()).matches();
    }

    public Pattern getPattern() {
        return this.m_pattern;
    }
}

