/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.javatojs.anno.AIsOType;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.VjoTranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.util.AutoBoxer;
import org.eclipse.vjet.dsf.javatojs.translate.util.AutoUnboxer;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.ArithExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.ParenthesizedExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.expr.TextExpr;
import org.eclipse.vjet.dsf.jst.stmt.DispatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ExprStmt;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.ISimpleTerm;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.JstVisitorAdapter;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class ExpressionTypeVisitor
extends JstVisitorAdapter {
    private static final String DIV_JS_FUNC = "parseInt";
    private static final String DIV_FLOAT_JS_FUNC = "parseFloat";
    private static final AutoBoxer s_autoBoxer = AutoBoxer.getInstance();
    private static final AutoUnboxer s_autoUnboxer = AutoUnboxer.getInstance();

    public void preVisit(IJstNode node) {
    }

    public boolean visit(IJstNode node) {
        this.autoBoxingVisit(node);
        this.autoUnboxingVisit(node);
        this.prefixExprVisit(node);
        this.postfixExprVisit(node);
        this.intDivisionVisit(node);
        this.defaultConstructorVisit(node);
        this.otypeVisit(node);
        return true;
    }

    public void endVisit(IJstNode node) {
    }

    public void postVisit(IJstNode node) {
    }

    private void otypeVisit(IJstNode node) {
        if (node.getParentNode() == null && node instanceof JstType) {
            JstType type = (JstType)node;
            List types = type.getImports();
            for (IJstType imp : types) {
                if (imp.getAnnotation(AIsOType.class.getSimpleName()) == null) continue;
                type.removeImport(imp);
                type.addInactiveImport(imp);
            }
        }
    }

    public void autoBoxingVisit(IJstNode node) {
        if (node instanceof JstVars) {
            JstVars jstVar = (JstVars)node;
            this.processJstVarsAutoboxing(jstVar);
        } else if (node instanceof AssignExpr) {
            AssignExpr assignExpr = (AssignExpr)node;
            this.processAssignmentAutoboxing(assignExpr);
        } else if (node instanceof RtnStmt) {
            RtnStmt rtnStmt = (RtnStmt)node;
            this.processRtnStmtAutoboxing(rtnStmt);
        } else if (node instanceof JstProperty) {
            JstProperty jstProperty = (JstProperty)node;
            this.processJstPropertyAutoboxing(jstProperty);
        } else if (node instanceof MtdInvocationExpr) {
            MtdInvocationExpr mtdExpr = (MtdInvocationExpr)node;
            this.processMethodAutoboxing(mtdExpr);
        }
    }

    private void processJstVarsAutoboxing(JstVars jstVar) {
        for (AssignExpr jstInitilizer : jstVar.getAssignments()) {
            this.processAssignmentAutoboxing(jstInitilizer);
        }
    }

    private void processAssignmentAutoboxing(AssignExpr assignExpr) {
        s_autoBoxer.autoBoxing((IExpr)assignExpr, assignExpr.getResultType());
    }

    private void processRtnStmtAutoboxing(RtnStmt rtnStmt) {
        IJstMethod jstMtd;
        IJstType expectedType;
        IExpr newExpr;
        IExpr expr = rtnStmt.getExpression();
        if (expr != null && (newExpr = s_autoBoxer.autoBoxing(expr, expectedType = (jstMtd = TranslateHelper.Method.getOwnerMethod((IJstNode)expr)).getRtnType())) != expr) {
            rtnStmt.setExpression(newExpr);
        }
    }

    private void processJstPropertyAutoboxing(JstProperty jstProperty) {
        IExpr expr;
        IExpr newExpr;
        IJstType expectedType = jstProperty.getType();
        if (jstProperty.getValue() != null) {
            SimpleLiteral expr2;
            IExpr newExpr2;
            ISimpleTerm value = jstProperty.getValue();
            if (value instanceof SimpleLiteral && (newExpr2 = s_autoBoxer.autoBoxing((IExpr)(expr2 = (SimpleLiteral)value), expectedType)) != expr2) {
                boolean isStatic = jstProperty.isStatic();
                VjoConvention conv = TranslateCtx.ctx().getConfig().getVjoConvention();
                String qualifier = VjoConvention.getThisPrefix();
                if (isStatic && DataTypeHelper.getNativeType((String)jstProperty.getOwnerType().getName()) == null) {
                    qualifier = VjoConvention.getNameWithStaticThis((String)jstProperty.getOwnerType().getSimpleName());
                }
                JstIdentifier jstIdentifier = new JstIdentifier(jstProperty.getName().toString());
                if (qualifier != null) {
                    jstIdentifier.setQualifier(new JstIdentifier(qualifier));
                }
                AssignExpr assignExpr = new AssignExpr((ILHS)jstIdentifier, newExpr2);
                jstProperty.setInitializer((IExpr)assignExpr);
                jstProperty.setValue(null);
                JstType ownerType = jstProperty.getOwnerType();
                ownerType.addInitWithoutChild((IStmt)assignExpr, isStatic);
            }
        } else if (jstProperty.getInitializer() != null && (newExpr = s_autoBoxer.autoBoxing(expr = jstProperty.getInitializer(), expectedType)) != expr) {
            jstProperty.setInitializer(newExpr);
        }
    }

    private void processMethodAutoboxing(MtdInvocationExpr mtdExpr) {
        if (mtdExpr.getMethod() == null || !(mtdExpr.getMethod() instanceof JstMethod)) {
            return;
        }
        JstMethod mtd = (JstMethod)mtdExpr.getMethod();
        if (mtd.isDispatcher()) {
            return;
        }
        List list = mtdExpr.getArgs();
        List args = mtd.getArgs();
        if (args.size() == list.size()) {
            ArrayList<IExpr> tempList = new ArrayList<IExpr>();
            for (IExpr arg : list) {
                tempList.add(arg);
            }
            IJstType expectedType = null;
            boolean boxed = false;
            int i = 0;
            while (i < tempList.size()) {
                expectedType = ((JstArg)args.get(i)).getType();
                IExpr newExpr = s_autoBoxer.autoBoxing((IExpr)tempList.get(i), expectedType);
                if (newExpr != tempList.get(i)) {
                    tempList.set(i, newExpr);
                    boxed = true;
                }
                ++i;
            }
            if (boxed) {
                mtdExpr.setArgs(tempList);
            }
        }
    }

    private void autoUnboxingVisit(IJstNode node) {
        if (node instanceof JstVars) {
            JstVars jstVar = (JstVars)node;
            this.processJstVarAutoUnboxing(jstVar);
        } else if (node instanceof AssignExpr) {
            AssignExpr assignExpr = (AssignExpr)node;
            this.processAssignmentAutoUnboxing(assignExpr);
        } else if (node instanceof RtnStmt) {
            RtnStmt rtnStmt = (RtnStmt)node;
            this.processRtnStmtAutoUnboxing(rtnStmt);
        } else if (node instanceof JstProperty) {
            JstProperty jstProperty = (JstProperty)node;
            this.processJstPropertyAutoUnboxing(jstProperty);
        } else if (node instanceof MtdInvocationExpr) {
            MtdInvocationExpr mtdExpr = (MtdInvocationExpr)node;
            this.processMethodAutoUnboxing(mtdExpr);
        }
    }

    private void processJstVarAutoUnboxing(JstVars jstVar) {
        for (AssignExpr jstInitilizer : jstVar.getAssignments()) {
            this.processAssignmentAutoUnboxing(jstInitilizer);
        }
    }

    private void processJstPropertyAutoUnboxing(JstProperty jstProperty) {
        IExpr expr = jstProperty.getInitializer();
        IJstType expectedType = jstProperty.getType();
        s_autoUnboxer.autoUnboxing(expr, expectedType);
    }

    private void processAssignmentAutoUnboxing(AssignExpr assignExpr) {
        IJstType expectedType = assignExpr.getResultType();
        s_autoUnboxer.autoUnboxing((IExpr)assignExpr, expectedType);
    }

    private void processRtnStmtAutoUnboxing(RtnStmt rtnStmt) {
        IJstType expectedType;
        IExpr newExpr;
        IExpr expr = rtnStmt.getExpression();
        IJstMethod jstMtd = TranslateHelper.Method.getOwnerMethod((IJstNode)expr);
        if (expr != null && (newExpr = s_autoUnboxer.autoUnboxing(expr, expectedType = jstMtd.getRtnType())) != expr) {
            rtnStmt.setExpression(newExpr);
        }
    }

    private void processMethodAutoUnboxing(MtdInvocationExpr mtdExpr) {
        if (mtdExpr.getMethod() == null || !(mtdExpr.getMethod() instanceof JstMethod)) {
            return;
        }
        List list = mtdExpr.getArgs();
        JstMethod mtd = (JstMethod)mtdExpr.getMethod();
        List args = mtd.getArgs();
        if (list.size() == args.size()) {
            IJstType expectedType = null;
            ArrayList<IExpr> tempList = new ArrayList<IExpr>();
            for (IExpr arg : list) {
                tempList.add(arg);
            }
            boolean unBoxed = false;
            int i = 0;
            while (i < list.size()) {
                expectedType = ((JstArg)args.get(i)).getType();
                IExpr newArg = s_autoUnboxer.autoUnboxing((IExpr)tempList.get(i), expectedType);
                if (newArg != tempList.get(i)) {
                    tempList.set(i, newArg);
                    unBoxed = true;
                }
                ++i;
            }
            if (unBoxed) {
                mtdExpr.setArgs(tempList);
            }
        }
    }

    private void defaultConstructorVisit(IJstNode node) {
        if (node instanceof IJstMethod) {
            IJstMethod mtd = (IJstMethod)node;
            IJstType extend = mtd.getOwnerType().getExtend();
            if (mtd.isConstructor() && extend != null && !"vjo.Object".equals(extend.getName()) && !"vjo.Enum".equals(extend.getName()) && !mtd.getOwnerType().isAnonymous()) {
                this.processForDefaultConstructor(mtd.getBlock());
            }
        }
    }

    private void processForDefaultConstructor(JstBlock block) {
        if (block == null) {
            return;
        }
        String thisRef = "this.";
        String thisBase = String.valueOf(thisRef) + "base";
        String constructsPre = String.valueOf(thisRef) + "constructs";
        if (block.getStmts().size() > 0) {
            IStmt stmt = (IStmt)block.getStmts().get(0);
            if (!(stmt instanceof DispatchStmt)) {
                if (stmt instanceof MtdInvocationExpr) {
                    String func = ((MtdInvocationExpr)stmt).getMethodIdentifier().toExprText();
                    if (!thisBase.equals(func) && !func.startsWith(constructsPre)) {
                        block.addStmt(0, (IStmt)new ExprStmt((IExpr)new TextExpr(String.valueOf(thisBase) + "()")));
                    }
                } else {
                    block.addStmt(0, (IStmt)new ExprStmt((IExpr)new TextExpr(String.valueOf(thisBase) + "()")));
                }
            }
        } else {
            block.addStmt(0, (IStmt)new ExprStmt((IExpr)new TextExpr(String.valueOf(thisBase) + "()")));
        }
    }

    private boolean isIntType(String typeName) {
        return typeName.equals("int") || typeName.equals("long") || typeName.equals("short") || typeName.equals("byte");
    }

    private boolean isFloatType(String typeName) {
        return typeName.equals("float") || typeName.equals("double");
    }

    private IExpr parseInfixExpr(InfixExpr expr, IJstNode jstNode) {
        MtdInvocationExpr parent;
        String exprTxt;
        ArrayList<Object> args = new ArrayList<Object>();
        if (jstNode instanceof MtdInvocationExpr && (DIV_JS_FUNC.equals(exprTxt = (parent = (MtdInvocationExpr)jstNode).getMethodIdentifier().toExprText()) || DIV_FLOAT_JS_FUNC.equals(exprTxt))) {
            return expr;
        }
        IJstType jstType = expr.getResultType();
        InfixExpr e = expr;
        String name = null;
        MtdInvocationExpr mtdExpr = null;
        if (jstType instanceof JstType) {
            IJstNode ltype;
            AssignExpr assign;
            ILHS lh;
            JstType rtnType = (JstType)expr.getResultType();
            InfixExpr.Operator op = expr.getOperator();
            IExpr lhs = this.parseExpr(expr.getLeft());
            IExpr rhs = this.parseExpr(expr.getRight());
            if (!lhs.equals(expr.getLeft()) || !rhs.equals(expr.getRight())) {
                e = new InfixExpr(lhs, rhs, op);
            }
            if (jstNode instanceof AssignExpr && (lh = (assign = (AssignExpr)jstNode).getLHS()) instanceof JstIdentifier && (ltype = ((JstIdentifier)lh).getJstBinding()) instanceof JstType) {
                rtnType = (JstType)ltype;
            }
            if (rtnType != null && this.isIntType(rtnType.getSimpleName()) && op.equals(InfixExpr.Operator.DIVIDE)) {
                name = DIV_JS_FUNC;
            } else if (rtnType != null && this.isFloatType(rtnType.getSimpleName()) && op.equals(InfixExpr.Operator.DIVIDE)) {
                name = DIV_FLOAT_JS_FUNC;
            } else {
                return e;
            }
            if (name != null) {
                JstIdentifier identifier = new JstIdentifier(name);
                mtdExpr = new MtdInvocationExpr(identifier, new IExpr[0]);
                mtdExpr.setResultType((IJstType)rtnType);
                if (jstNode instanceof AssignExpr) {
                    mtdExpr.addArg((IExpr)expr);
                    AssignExpr assignExpr = (AssignExpr)jstNode;
                    assignExpr.setExpr((IExpr)mtdExpr);
                    mtdExpr.setParent(jstNode);
                } else if (jstNode instanceof RtnStmt) {
                    mtdExpr.addArg((IExpr)expr);
                    RtnStmt rtnStmt = (RtnStmt)jstNode;
                    rtnStmt.setExpression((IExpr)mtdExpr);
                    mtdExpr.setParent(jstNode);
                } else if (jstNode instanceof MtdInvocationExpr) {
                    MtdInvocationExpr methodExpr = (MtdInvocationExpr)jstNode;
                    List list = methodExpr.getArgs();
                    for (IExpr arg : list) {
                        args.add(arg);
                    }
                    int i = 0;
                    while (i < args.size()) {
                        if (((IExpr)list.get(i)).toExprText().equals(e.toExprText())) {
                            args.set(i, mtdExpr);
                        }
                        ++i;
                    }
                    if (args.size() > 0) {
                        methodExpr.setArgs(args);
                    }
                    mtdExpr.addArg((IExpr)e);
                } else if (jstNode instanceof InfixExpr) {
                    InfixExpr parentInfixExpr = (InfixExpr)jstNode;
                    mtdExpr.addArg((IExpr)expr);
                    if (mtdExpr.getArgs().contains(parentInfixExpr.getLeft())) {
                        parentInfixExpr.removeChild((IJstNode)expr);
                        parentInfixExpr.setLeft((IExpr)mtdExpr);
                        parentInfixExpr.addChild((IJstNode)mtdExpr);
                    }
                    if (mtdExpr.getArgs().contains(parentInfixExpr.getRight())) {
                        parentInfixExpr.removeChild((IJstNode)expr);
                        parentInfixExpr.setRight((IExpr)mtdExpr);
                        parentInfixExpr.addChild((IJstNode)mtdExpr);
                    }
                }
            }
            return mtdExpr;
        }
        return e;
    }

    private void parseAssignExpr(AssignExpr expr) {
        AssignExpr.Operator op = expr.getOprator();
        IJstType rtnType = expr.getResultType();
        if (op.equals(AssignExpr.Operator.DIVIDE_ASSIGN) && rtnType != null && this.isIntType(rtnType.getSimpleName())) {
            IExpr e = expr.getExpr();
            ILHS lhs = expr.getLHS();
            InfixExpr infixExpr = new InfixExpr((IExpr)lhs, e, InfixExpr.Operator.DIVIDE);
            String name = DIV_JS_FUNC;
            MtdInvocationExpr mtdExpr = null;
            JstIdentifier identifier = new JstIdentifier(name);
            mtdExpr = new MtdInvocationExpr(identifier, new IExpr[0]);
            mtdExpr.setResultType(rtnType);
            mtdExpr.addArg((IExpr)infixExpr);
            expr.setExpr((IExpr)mtdExpr);
            expr.setOp(AssignExpr.Operator.ASSIGN);
        }
    }

    private IExpr parseExpr(IExpr expr) {
        ParenthesizedExpr parenthesizedExpr;
        IExpr e = expr;
        if (expr instanceof InfixExpr) {
            InfixExpr infixExpr = (InfixExpr)expr;
            BaseJstNode parentNode = infixExpr.getParentNode();
            e = this.parseInfixExpr(infixExpr, (IJstNode)parentNode);
            return e;
        }
        if (expr instanceof ParenthesizedExpr && (e = (parenthesizedExpr = (ParenthesizedExpr)expr).getExpression()) instanceof InfixExpr) {
            InfixExpr infixExpr = (InfixExpr)e;
            BaseJstNode parentNode = infixExpr.getParentNode();
            e = this.parseInfixExpr(infixExpr, (IJstNode)parentNode);
            return new ParenthesizedExpr(e);
        }
        return expr;
    }

    private void processOverloadedArgs(MtdInvocationExpr node) {
        JstMethod jstMtd;
        if (node.getMethod() instanceof JstMethod && node.getMethod() != null && (jstMtd = (JstMethod)node.getMethod()).isDispatcher()) {
            List list = node.getArgs();
            ArrayList<Object> args = new ArrayList<Object>();
            for (IExpr arg : list) {
                args.add(arg);
            }
            int i = 0;
            while (i < args.size()) {
                ObjCreationExpr expr;
                if (((IExpr)args.get(i)).getResultType() != null && ((IExpr)args.get(i)).getResultType().getSimpleName() != null && DataTypeHelper.isNumericPrimitiveType((IJstType)((IExpr)args.get(i)).getResultType()) && (expr = this.changeOverLoadedMtdArgs((IExpr)args.get(i), node)) != null) {
                    args.set(i, expr);
                }
                ++i;
            }
            if (args.size() > 0) {
                node.setArgs(args);
            }
        }
    }

    private ObjCreationExpr changeOverLoadedMtdArgs(IExpr arg, MtdInvocationExpr jstNode) {
        IJstType type = arg.getResultType();
        String fullName = this.getWrapperTypeName(type.getName(), true);
        JstType rtnType = JstCache.getInstance().getType(fullName, true);
        JstIdentifier jstQualifier = VjoTranslateHelper.getStaticTypeQualifier((IJstType)rtnType, (BaseJstNode)jstNode);
        String name = jstQualifier.getName();
        if (rtnType != jstNode.getOwnerType()) {
            name = String.valueOf(name) + "." + rtnType.getSimpleName();
        }
        JstIdentifier identifier = new JstIdentifier(name);
        MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
        mtdCall.setResultType((IJstType)rtnType);
        mtdCall.addArg(arg);
        ObjCreationExpr objCreationExpr = new ObjCreationExpr(mtdCall);
        return objCreationExpr;
    }

    private String getWrapperTypeName(String str, boolean fullName) {
        if (str.equals("int")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Integer";
            }
            return "Integer";
        }
        if (str.equals("long")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Long";
            }
            return "Long";
        }
        if (str.equals("short")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Short";
            }
            return "Short";
        }
        if (str.equals("byte")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Byte";
            }
            return "Byte";
        }
        if (str.equals("float")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Float";
            }
            return "Float";
        }
        if (str.equals("double")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Double";
            }
            return "Double";
        }
        return null;
    }

    private void intDivisionVisit(IJstNode node) {
        if (node instanceof InfixExpr) {
            InfixExpr infixExpr = (InfixExpr)node;
            IJstNode parentNode = node.getParentNode();
            this.parseInfixExpr(infixExpr, parentNode);
        } else if (node instanceof AssignExpr) {
            AssignExpr expr = (AssignExpr)node;
            this.parseAssignExpr(expr);
        }
    }

    private boolean needAutoCast(String typeName, AssignExpr.Operator op) {
        boolean autoCast = false;
        if ((typeName.equals("byte") || typeName.equals("short")) && (op.equals(AssignExpr.Operator.PLUS_ASSIGN) || op.equals(AssignExpr.Operator.TIMES_ASSIGN)) || op.equals(AssignExpr.Operator.MINUS_ASSIGN)) {
            autoCast = true;
        }
        return autoCast;
    }

    private void prefixExprVisit(IJstNode node) {
        if (node instanceof PrefixExpr) {
            ((PrefixExpr)node).setIsFirstTerm(this.isFirst(node));
        }
    }

    private void postfixExprVisit(IJstNode node) {
        if (node instanceof PostfixExpr) {
            ((PostfixExpr)node).setIsLastTerm(this.isLast(node));
        }
    }

    private boolean isFirst(IJstNode node) {
        IJstNode parent = node.getParentNode();
        if (parent == null || !(parent instanceof ArithExpr)) {
            return true;
        }
        if (parent instanceof InfixExpr) {
            InfixExpr infixExpr = (InfixExpr)parent;
            if (infixExpr.getRight() == node) {
                return false;
            }
            if (infixExpr.getLeft() == node) {
                return this.isLast(parent);
            }
        } else {
            if (parent instanceof PrefixExpr) {
                return false;
            }
            if (parent instanceof PostfixExpr) {
                return this.isFirst(parent);
            }
        }
        return true;
    }

    private boolean isLast(IJstNode node) {
        IJstNode parent = node.getParentNode();
        if (parent == null || !(parent instanceof ArithExpr)) {
            return true;
        }
        if (parent instanceof InfixExpr) {
            InfixExpr infixExpr = (InfixExpr)parent;
            if (infixExpr.getLeft() == node) {
                return false;
            }
            if (infixExpr.getRight() == node) {
                return this.isLast(parent);
            }
        } else {
            if (parent instanceof PostfixExpr) {
                return false;
            }
            if (parent instanceof PrefixExpr) {
                return this.isLast(parent);
            }
        }
        return true;
    }
}

