/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control.translate;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.javatojs.control.translate.BaseTask;
import org.eclipse.vjet.dsf.javatojs.parse.BaseTypeVisitor;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TranslationTraceId;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.javatojs.translate.config.PackageMapping;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public final class TypeVisitTask
extends BaseTask {
    private BaseTypeVisitor m_visitor;

    TypeVisitTask(String id, CompilationUnit cu, BaseTypeVisitor visitor, ITranslateTracer tracer, TranslateCtx parentCtx) {
        super(id, cu, tracer, parentCtx);
        this.m_visitor = visitor;
    }

    @Override
    void doIt() {
        this.getCompilationUnit().accept((ASTVisitor)this.m_visitor);
        if (this.getTracer().isEnabled() && !this.m_visitor.getDependency().isEmpty()) {
            PackageMapping pkgMapping = TranslateCtx.ctx().getConfig().getPackageMapping();
            ITranslateTracer tracer = this.getTracer();
            tracer.startGroup(TranslationTraceId.DEPENDENTS, new TraceAttr[0]);
            for (JstType type : this.m_visitor.getDependency()) {
                tracer.traceNV(TranslationTraceId.TYPE, this, "Type", pkgMapping.mapFrom(type.getName()));
            }
            tracer.endGroup(TranslationTraceId.DEPENDENTS);
        }
    }

    public BaseTypeVisitor getVisitor() {
        return this.m_visitor;
    }

    @Override
    public TranslationMode getMode() {
        return this.m_visitor.getMode();
    }

    @Override
    public JstType getType() {
        return this.m_visitor.getType();
    }
}

