/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.ITraceData;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.common.trace.config.FilterKey;
import org.eclipse.vjet.dsf.common.trace.config.ListenerKey;
import org.eclipse.vjet.dsf.common.trace.event.TraceEvent;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.common.trace.event.TraceType;
import org.eclipse.vjet.dsf.common.trace.filter.ITraceEventFilter;
import org.eclipse.vjet.dsf.common.trace.listener.ITraceEventListener;
import org.eclipse.vjet.dsf.common.tracer.NoOpTracer;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TraceErrors;
import org.eclipse.vjet.dsf.javatojs.trace.TraceTime;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateTraceType;

public class TranslateTracer
implements ITranslateTracer {
    public static final ITranslateTracer NO_OP = new NoOp();
    private String m_scope;
    private final List<ITraceEventFilter> m_filters = new ArrayList<ITraceEventFilter>(5);
    private final List<ITraceEventListener> m_listeners = new ArrayList<ITraceEventListener>(5);

    @Override
    public void startGroup(TraceId id, TraceAttr ... attrs) {
        this.trace(id, (TraceType)TranslateTraceType.START_GROUP, (Object)this, (ITraceData[])attrs);
    }

    @Override
    public void startGroup(TraceId id, TraceTime timer, TraceAttr ... attrs) {
        timer.start();
        this.trace(id, (TraceType)TranslateTraceType.START_GROUP, (Object)this, (ITraceData[])attrs);
    }

    @Override
    public void endGroup(TraceId id) {
        this.trace(id, (TraceType)TranslateTraceType.END_GROUP, (Object)this, new ITraceData[0]);
    }

    @Override
    public void endGroup(TraceId id, List<TranslateError> errors) {
        this.traceError(id, errors);
        this.endGroup(id);
    }

    @Override
    public void endGroup(TraceId id, List<TranslateError> errors, TraceTime timer) {
        timer.end();
        this.traceError(id, errors);
        this.traceTime(id, timer);
        this.endGroup(id);
    }

    @Override
    public void traceTime(TraceId id, TraceTime timer) {
        if (timer == null) {
            return;
        }
        this.trace(id, (TraceType)TranslateTraceType.TIME, (Object)this, new ITraceData[]{timer});
    }

    @Override
    public void traceError(TraceId id, List<TranslateError> errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        this.trace(id, (TraceType)TranslateTraceType.ERRORS, (Object)this, new ITraceData[]{new TraceErrors(errors)});
    }

    @Override
    public void traceError(TraceId id, TranslateError error) {
        if (error == null) {
            return;
        }
        ArrayList<TranslateError> errors = new ArrayList<TranslateError>(1);
        errors.add(error);
        this.trace(id, (TraceType)TranslateTraceType.ERRORS, (Object)this, new ITraceData[]{new TraceErrors(errors)});
    }

    public boolean isEnabled() {
        return true;
    }

    public String getScope() {
        return this.m_scope;
    }

    public void close() {
        for (ITraceEventListener listener : this.m_listeners) {
            listener.close();
        }
    }

    public void traceEnterMethod(TraceId id, Object caller, Object ... args) {
        this.trace(id, TraceType.ENTER_METHOD, caller, args);
    }

    public void traceExitMethod(TraceId id, Object caller, Object ... args) {
        this.trace(id, TraceType.EXIT_METHOD, caller, null, args);
    }

    public void traceObjectType(TraceId id, Object caller, Object target) {
        this.trace(id, TraceType.OBJECT_TYPE, caller, target);
    }

    public void traceObjectState(TraceId id, Object caller, Object target) {
        this.trace(id, TraceType.OBJECT_STATE, caller, target);
    }

    public void traceDataModel(TraceId id, Object caller, Object target) {
        this.trace(id, TraceType.DATAMODEL, caller, target);
    }

    public void traceMsg(TraceId id, Object caller, String msg) {
        this.trace(id, TraceType.MSG, caller, msg);
    }

    public void traceNV(TraceId id, Object caller, String name, String value) {
        this.trace(id, TraceType.NV, caller, name, value);
    }

    public void trace(TraceId id, TraceType type, Object caller, Object ... args) {
        try {
            TraceEvent event = new TraceEvent(id, type, caller, args);
            this.beforeTrace(event);
            this.trace(event);
            this.afterTrace(event);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void trace(TraceId id, TraceType type, Object caller, ITraceData ... data) {
        try {
            TraceEvent event = new TraceEvent(id, type, caller, data);
            this.beforeTrace(event);
            this.trace(event);
            this.afterTrace(event);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean hasFilter(ITraceEventFilter filter) {
        if (filter == null) {
            return false;
        }
        for (ITraceEventFilter f : this.m_filters) {
            if (!f.getId().equals((Object)filter.getId()) || f.getClass() != filter.getClass()) continue;
            return true;
        }
        return false;
    }

    public void addFilter(ITraceEventFilter filter) {
        if (filter == null) {
            DsfExceptionHelper.chuck((String)"filter is null");
        }
        if (!this.hasFilter(filter)) {
            this.m_filters.add(filter);
        }
    }

    public List<ITraceEventFilter> getFilters() {
        return Collections.unmodifiableList(this.m_filters);
    }

    public boolean removeFilter(ITraceEventFilter filter) {
        if (filter == null) {
            return false;
        }
        return this.m_filters.remove(filter);
    }

    public void removeAllFilters() {
        this.m_filters.clear();
    }

    public boolean hasListener(ITraceEventListener listener) {
        if (listener == null) {
            return false;
        }
        for (ITraceEventListener l : this.m_listeners) {
            if (!l.getId().equals((Object)listener.getId()) || l.getClass() != listener.getClass()) continue;
            return true;
        }
        return false;
    }

    public void addListener(ITraceEventListener listener) {
        if (listener == null) {
            DsfExceptionHelper.chuck((String)"listener is null");
        }
        if (!this.hasListener(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public List<ITraceEventListener> getListeners() {
        return Collections.unmodifiableList(this.m_listeners);
    }

    public boolean removeListener(ITraceEventListener listener) {
        if (listener == null) {
            return false;
        }
        return this.m_listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.m_listeners.clear();
    }

    private List<FilterKey> getFilterKeys(String scope) {
        return Collections.emptyList();
    }

    private List<ListenerKey> getListenerKeys(String scope) {
        return Collections.emptyList();
    }

    private void beforeTrace(TraceEvent event) {
        for (ITraceEventListener listener : this.m_listeners) {
            if (!listener.isApplicable(event)) continue;
            listener.beforeTrace(event);
        }
    }

    private void trace(TraceEvent event) {
        for (ITraceEventListener listener : this.m_listeners) {
            if (!listener.isApplicable(event)) continue;
            listener.trace(event);
        }
    }

    private void afterTrace(TraceEvent event) {
        for (ITraceEventListener listener : this.m_listeners) {
            if (!listener.isApplicable(event)) continue;
            listener.afterTrace(event);
        }
    }

    public static class NoOp
    extends NoOpTracer
    implements ITranslateTracer {
        private NoOp() {
        }

        @Override
        public void startGroup(TraceId id, TraceAttr ... attrs) {
        }

        @Override
        public void startGroup(TraceId id, TraceTime timer, TraceAttr ... attrs) {
        }

        @Override
        public void endGroup(TraceId id) {
        }

        @Override
        public void endGroup(TraceId id, List<TranslateError> errors) {
        }

        @Override
        public void endGroup(TraceId id, List<TranslateError> errors, TraceTime timer) {
        }

        @Override
        public void traceError(TraceId id, List<TranslateError> errors) {
        }

        @Override
        public void traceError(TraceId id, TranslateError error) {
        }

        @Override
        public void traceTime(TraceId id, TraceTime timer) {
        }
    }
}

