/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.DataTypeTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.ExpressionTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.FieldTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.LiteralTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.MethodTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.NameTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.OtherTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.PackageTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.StatementTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TypeTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.UnitTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomTranslateDelegator;

public class TranslatorProvider {
    private Map<Class<?>, BaseTranslator> m_translators = new HashMap(5);

    public TranslatorProvider() {
        this.m_translators.put(PackageTranslator.class, new PackageTranslator());
        this.m_translators.put(UnitTranslator.class, new UnitTranslator());
        this.m_translators.put(TypeTranslator.class, new TypeTranslator());
        this.m_translators.put(LiteralTranslator.class, new LiteralTranslator());
        this.m_translators.put(NameTranslator.class, new NameTranslator());
        this.m_translators.put(FieldTranslator.class, new FieldTranslator());
        this.m_translators.put(MethodTranslator.class, new MethodTranslator());
        this.m_translators.put(ExpressionTranslator.class, new ExpressionTranslator());
        this.m_translators.put(StatementTranslator.class, new StatementTranslator());
        this.m_translators.put(DataTypeTranslator.class, new DataTypeTranslator());
        this.m_translators.put(CustomTranslateDelegator.class, new CustomTranslateDelegator());
        this.m_translators.put(OtherTranslator.class, new OtherTranslator());
    }

    public BaseTranslator getTranslator(Class<?> srcType) {
        assert (srcType != null) : "srcType cannot be null";
        return this.m_translators.get(srcType);
    }

    public UnitTranslator getUnitTranslator() {
        return (UnitTranslator)this.getTranslator(UnitTranslator.class);
    }

    public TypeTranslator getTypeTranslator() {
        return (TypeTranslator)this.getTranslator(TypeTranslator.class);
    }

    public PackageTranslator getPackageTranslator() {
        return (PackageTranslator)this.getTranslator(PackageTranslator.class);
    }

    public LiteralTranslator getLiteralTranslator() {
        return (LiteralTranslator)this.getTranslator(LiteralTranslator.class);
    }

    public NameTranslator getNameTranslator() {
        return (NameTranslator)this.getTranslator(NameTranslator.class);
    }

    public FieldTranslator getFieldTranslator() {
        return (FieldTranslator)this.getTranslator(FieldTranslator.class);
    }

    public MethodTranslator getMethodTranslator() {
        return (MethodTranslator)this.getTranslator(MethodTranslator.class);
    }

    public ExpressionTranslator getExprTranslator() {
        return (ExpressionTranslator)this.getTranslator(ExpressionTranslator.class);
    }

    public StatementTranslator getStmtTranslator() {
        return (StatementTranslator)this.getTranslator(StatementTranslator.class);
    }

    public DataTypeTranslator getDataTypeTranslator() {
        return (DataTypeTranslator)this.getTranslator(DataTypeTranslator.class);
    }

    public CustomTranslateDelegator getCustomTranslator() {
        return (CustomTranslateDelegator)this.getTranslator(CustomTranslateDelegator.class);
    }

    public OtherTranslator getOtherTranslator() {
        return (OtherTranslator)this.getTranslator(OtherTranslator.class);
    }
}

