/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;

public class CustomInfo {
    public static final CustomInfo NONE = new CustomInfo(CustomAttr.NONE);
    private CustomAttr m_attr = CustomAttr.NONE;
    private String m_name;
    private IJstNode m_jstNode;
    private boolean m_inheritable = true;
    private boolean m_forceFullyQualify = false;
    private IJstType m_asType;
    private String m_asName;

    public CustomInfo() {
    }

    public CustomInfo(CustomAttr attr) {
        this.setAttr(attr);
    }

    public CustomInfo(CustomAttr attr, IJstNode jstNode) {
        this(attr);
        this.m_jstNode = jstNode;
    }

    public CustomInfo(String name) {
        this.m_name = name;
    }

    public CustomInfo(CustomInfo copy) {
        CustomInfo.update(this, copy);
    }

    public boolean isExcluded() {
        return this.m_attr == CustomAttr.EXCLUDED;
    }

    public boolean isJavaOnly() {
        return this.m_attr == CustomAttr.JAVA_ONLY;
    }

    public boolean isJSProxy() {
        return this.m_attr == CustomAttr.JS_PROXY;
    }

    public boolean isMappedToJS() {
        return this.m_attr == CustomAttr.MAPPED_TO_JS;
    }

    public boolean isMappedToVJO() {
        return this.m_attr == CustomAttr.MAPPED_TO_VJO;
    }

    public boolean isNone() {
        return this.m_attr == CustomAttr.NONE;
    }

    public CustomAttr getAttr() {
        return this.m_attr;
    }

    public void setAttr(CustomAttr attr) {
        if (this == NONE) {
            throw new RuntimeException("singleton NONE is read-only");
        }
        this.m_attr = attr == null ? CustomAttr.NONE : attr;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setInheritable(boolean inheritable) {
        this.m_inheritable = inheritable;
    }

    public boolean isInheritable() {
        return this.m_inheritable;
    }

    public boolean isForceFullyQualify() {
        return this.m_forceFullyQualify;
    }

    public void setForceFullyQualify(boolean forceFullyQualify) {
        this.m_forceFullyQualify = forceFullyQualify;
    }

    public IJstNode getJstNode() {
        return this.m_jstNode;
    }

    public void setJstNode(IJstNode jstNode) {
        if (this == NONE) {
            throw new RuntimeException("singleton NONE is read-only");
        }
        this.m_jstNode = jstNode;
    }

    public static CustomInfo update(CustomInfo oldInfo, CustomInfo newInfo) {
        if (newInfo == null || newInfo == NONE) {
            return oldInfo;
        }
        CustomInfo cInfo = oldInfo;
        if (cInfo == null || cInfo == NONE) {
            cInfo = new CustomInfo();
        }
        if (newInfo.m_attr != CustomAttr.NONE) {
            cInfo.m_attr = newInfo.m_attr;
        }
        if (newInfo.m_name != null) {
            cInfo.m_name = newInfo.m_name;
        }
        cInfo.m_inheritable = newInfo.m_inheritable;
        cInfo.m_forceFullyQualify = newInfo.m_forceFullyQualify;
        cInfo.m_asType = newInfo.m_asType;
        cInfo.m_asName = newInfo.m_asName;
        return cInfo;
    }

    public String toString() {
        Z z = new Z();
        z.format("attr", (Object)this.m_attr.name());
        z.format("name", (Object)this.m_name);
        if (this.m_jstNode != null) {
            z.format("nodeType", (Object)this.m_jstNode.getClass().getSimpleName());
        }
        z.format("m_inheritable", this.m_inheritable);
        z.format("m_forceFullyQualify", this.m_forceFullyQualify);
        return z.toString();
    }

    public IJstType getAsType() {
        return this.m_asType;
    }

    public void setAsType(IJstType asType) {
        this.m_asType = asType;
    }

    public String getAsName() {
        return this.m_asName;
    }

    public void setAsName(String asName) {
        this.m_asName = asName;
    }
}

