/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom.meta;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomField;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomMethod;

public class CustomType {
    private Class<?> m_javaType;
    private String m_javaName;
    private String m_jstName;
    private Map<String, CustomField> m_fldMapping = new HashMap<String, CustomField>(5);
    private Map<String, Map<MethodKey, CustomMethod>> m_mtdMapping = new HashMap<String, Map<MethodKey, CustomMethod>>(5);
    private boolean m_removeTypeQualifier = false;
    private CustomAttr m_attr = CustomAttr.NONE;

    public CustomType(Class<?> javaType) {
        assert (javaType != null) : "javaType cannot be null";
        this.m_javaType = javaType;
        this.m_jstName = this.m_javaName = javaType.getName();
    }

    public CustomType(String javaName) {
        assert (javaName != null) : "javaName cannot be null";
        this.m_javaName = javaName;
        this.m_jstName = javaName;
        try {
            this.m_javaType = Class.forName(javaName, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public CustomType(Class<?> javaType, String jstName) {
        this(javaType);
        assert (jstName != null) : "jstTypeName cannot be null";
        this.m_jstName = jstName;
    }

    public CustomType(String javaName, String jstName) {
        this(javaName);
        assert (jstName != null) : "jstName cannot be null";
        this.m_jstName = jstName;
    }

    public Class<?> getJavaType() {
        return this.m_javaType;
    }

    public String getJavaName() {
        return this.m_javaName != null ? this.m_javaName : this.m_javaType.getName();
    }

    public CustomType setJstName(String typeName) {
        this.m_jstName = typeName;
        return this;
    }

    public String getJstName() {
        return this.m_jstName;
    }

    public CustomType setRemoveTypeQualifier(boolean removeTypeQualifier) {
        this.m_removeTypeQualifier = removeTypeQualifier;
        return this;
    }

    public boolean removeTypeQualifier() {
        return this.m_removeTypeQualifier;
    }

    public CustomType setAttr(CustomAttr attr) {
        this.m_attr = attr == null ? CustomAttr.NONE : attr;
        return this;
    }

    public CustomAttr getAttr() {
        if (this.m_attr != null) {
            return this.m_attr;
        }
        return CustomAttr.NONE;
    }

    public CustomField getCustomField(String javaFieldName) {
        return this.m_fldMapping.get(javaFieldName);
    }

    public Collection<CustomField> getAllCustomFields() {
        return this.m_fldMapping.values();
    }

    public CustomType addCustomField(CustomField cField) {
        if (cField != null) {
            this.m_fldMapping.put(cField.getJavaName(), cField);
            cField.setCustomType(this);
        }
        return this;
    }

    public CustomType addCustomField(String javaName, String jstName, String jstTypeName) {
        return this.addCustomField(new CustomField(javaName).setJstName(jstName).setJstTypeName(jstTypeName));
    }

    public CustomType addCustomField(String javaName, String jstName, String jstTypeName, String jstOwnerTypeName) {
        return this.addCustomField(new CustomField(javaName).setJstName(jstName).setJstTypeName(jstTypeName).setJstOwnerTypeName(jstOwnerTypeName));
    }

    public CustomMethod getCustomMethod(MethodKey mtdKey) {
        if (mtdKey == null) {
            return null;
        }
        Map<MethodKey, CustomMethod> map = this.m_mtdMapping.get(mtdKey.getName());
        if (map == null) {
            return null;
        }
        return map.get(mtdKey);
    }

    public Collection<CustomMethod> getCustomMethods(String javaName) {
        Map<MethodKey, CustomMethod> map = this.m_mtdMapping.get(javaName);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.values();
    }

    public Map<String, Map<MethodKey, CustomMethod>> getAllCustomMethods() {
        return Collections.unmodifiableMap(this.m_mtdMapping);
    }

    public CustomType addCustomMethod(CustomMethod cMethod) {
        if (cMethod != null) {
            MethodKey mtdKey = cMethod.getKey();
            String mtdName = mtdKey.getName();
            Map<MethodKey, CustomMethod> map = this.m_mtdMapping.get(mtdName);
            if (map == null) {
                map = new HashMap<MethodKey, CustomMethod>();
                this.m_mtdMapping.put(mtdName, map);
            }
            map.put(mtdKey, cMethod);
            cMethod.setCustomType(this);
        }
        return this;
    }

    public CustomType addCustomMethod(String javaName, String jstName) {
        return this.addCustomMethod(new CustomMethod(javaName, jstName));
    }

    public CustomType addCustomMethod(String javaName, String jstName, boolean isProperty) {
        return this.addCustomMethod(new CustomMethod(javaName, jstName).setIsProperty(isProperty));
    }

    public CustomType addCustomMethod(String javaName, String jstName, String jstOwnerTypeName) {
        return this.addCustomMethod(new CustomMethod(javaName, jstName).setJstOwnerTypeName(jstOwnerTypeName));
    }

    public String toString() {
        Z z = new Z();
        z.format("m_javaName", (Object)this.m_javaName);
        z.format("m_jstName", (Object)this.m_jstName);
        z.format("m_removeTypeQualifier", this.m_removeTypeQualifier);
        z.format("m_attr", (Object)this.m_attr);
        z.format((Object)"m_fldMapping:");
        for (Map.Entry<String, CustomField> entry : this.m_fldMapping.entrySet()) {
            z.format((Object)("\t" + entry.getKey() + "->" + entry.getValue().getJstName()));
        }
        z.format((Object)"m_mtdMapping:");
        for (Map.Entry<String, Map<MethodKey, CustomMethod>> mapEntry : this.m_mtdMapping.entrySet()) {
            for (Map.Entry<MethodKey, CustomMethod> entry : mapEntry.getValue().entrySet()) {
                String mtd = "\t" + entry.getKey() + "->" + entry.getValue().getJstName();
                if (entry.getValue().isProperty()) {
                    mtd = String.valueOf(mtd) + " (property)";
                }
                z.format((Object)mtd);
            }
        }
        return z.toString();
    }
}

