/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom.meta;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.config.PackageMapping;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomInfo;
import org.eclipse.vjet.dsf.javatojs.translate.custom.ICustomTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomField;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomMethod;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomType;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.ICustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.IPrivilegedProcessor;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.PtyGetter;
import org.eclipse.vjet.dsf.jst.expr.TextExpr;
import org.eclipse.vjet.dsf.jst.stmt.PtySetter;
import org.eclipse.vjet.dsf.jst.stmt.TextStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class MetaDrivenCustomTranslator
extends BaseTranslator
implements ICustomTranslator {
    private ICustomMetaProvider m_metaProvider;
    private Set<IJstType> m_initializedTypes = new HashSet<IJstType>();

    public MetaDrivenCustomTranslator(ICustomMetaProvider metaProvider) {
        if (metaProvider == null) {
            throw new RuntimeException("metaProvider cannot be null");
        }
        this.m_metaProvider = metaProvider;
    }

    @Override
    public synchronized void initialize(JstType jstType) {
        CustomInfo cInfo;
        IJstType type;
        if (jstType == null || this.m_initializedTypes.contains(jstType)) {
            return;
        }
        CustomType cType = this.getMetaProvider().getCustomType(jstType.getName());
        if (cType == null) {
            return;
        }
        TranslateCtx ctx = this.getCtx();
        TranslateInfo tInfo = ctx.getTranslateInfo(jstType);
        CustomAttr cAttr = cType.getAttr();
        if (!cAttr.isNone()) {
            ctx.setCustomAttr((IJstType)jstType, cAttr);
        }
        if (cAttr.isJavaOnly() || cAttr.isJsProxy()) {
            if (!jstType.getName().equals(cType.getJstName())) {
                ctx.setNewName((IJstType)jstType, cType.getJstName());
            }
        } else if (cAttr.isMappedToJS() && (type = this.getDataTypeTranslator().toJstType(cType.getJstName(), jstType)) != null) {
            ctx.addJsType(type.getName(), type);
        }
        Map<String, Map<MethodKey, CustomMethod>> methods = cType.getAllCustomMethods();
        for (Map<MethodKey, CustomMethod> map : methods.values()) {
            for (CustomMethod cMtd : map.values()) {
                cInfo = null;
                cAttr = cMtd.getAttr();
                if (!cAttr.isNone()) {
                    cInfo = new CustomInfo(cAttr);
                }
                if (!cMtd.getJavaName().equals(cMtd.getJstName()) && (cAttr.isJavaOnly() || cAttr.isJsProxy())) {
                    if (cInfo == null) {
                        cInfo = new CustomInfo();
                    }
                    cInfo.setName(cMtd.getJstName());
                }
                if (cInfo == null) continue;
                tInfo.addMethodCustomInfo(cMtd.getKey(), cInfo);
            }
        }
        Collection<CustomField> fieldList = cType.getAllCustomFields();
        for (CustomField cFld : fieldList) {
            cInfo = null;
            cAttr = cFld.getAttr();
            if (!cAttr.isNone()) {
                cInfo = new CustomInfo(cAttr);
            }
            if (!cFld.getJavaName().equals(cFld.getJstName()) && (cAttr.isJavaOnly() || cAttr.isJsProxy())) {
                if (cInfo == null) {
                    cInfo = new CustomInfo();
                }
                cInfo.setName(cFld.getJstName());
            }
            if (cInfo == null) continue;
            tInfo.addFieldCustomInfo(cFld.getJavaName(), cInfo);
        }
        this.m_initializedTypes.add((IJstType)jstType);
    }

    @Override
    public IJstType processType(String javaTypeName, ASTNode astNode, BaseJstNode jstNode) {
        CustomType cType = this.getMetaProvider().getCustomType(javaTypeName);
        if (cType == null) {
            return null;
        }
        TranslateCtx ctx = this.getCtx();
        JstType ownerType = jstNode.getOwnerType();
        IJstType jstType = null;
        CustomAttr cAttr = cType.getAttr();
        if (cAttr.isJavaOnly() || cAttr.isJsProxy()) {
            jstType = this.getDataTypeTranslator().toJstType(javaTypeName, ownerType);
        } else if (cAttr.isMappedToJS() || cAttr.isMappedToVJO()) {
            JstType tempType = JstCache.getInstance().getType(cType.getJstName(), true);
            if (tempType.getExtends().size() == 0) {
                tempType.addExtend((IJstType)JstCache.getInstance().getType("vjo.Object"));
            }
            jstType = tempType;
        } else {
            jstType = this.getDataTypeTranslator().toJstType(cType.getJstName(), ownerType);
            if (jstType instanceof JstType && jstType.getExtends().size() == 0) {
                JstType temp = (JstType)jstType;
                temp.addExtend((IJstType)JstCache.getInstance().getType("vjo.Object"));
            }
        }
        if (jstType == null) {
            return null;
        }
        if (cAttr.isExcluded()) {
            TranslateHelper.Type.validateTypeReference(jstType, astNode, jstNode, this);
        } else if (cAttr.isJsProxy() || cAttr.isMappedToVJO()) {
            this.getDataTypeTranslator().addImport(jstType, ownerType, jstType.getName());
        } else if (cAttr.isMappedToJS()) {
            ctx.addJsType(jstType.getName(), jstType);
        }
        ctx.getTranslateInfo(ownerType).setType(TranslateHelper.getShortName(javaTypeName), jstType);
        if (jstType instanceof JstType) {
            this.initialize((JstType)jstType);
        }
        return jstType;
    }

    @Override
    public JstIdentifier processIdentifier(Name astName, boolean hasSuper, boolean hasThis, IExpr jstQualifier, JstIdentifier jstIdentifier, BaseJstNode jstNode) {
        if (astName.isSimpleName()) {
            return this.processSimpleName((SimpleName)astName, hasSuper, hasThis, jstQualifier, jstIdentifier, jstNode);
        }
        if (jstIdentifier.getQualifier() == null) {
            return null;
        }
        QualifiedName qualifiedName = (QualifiedName)astName;
        JstIdentifier cQualifier = this.processIdentifier(qualifiedName.getQualifier(), hasSuper, hasThis, jstQualifier, jstIdentifier.getQualifier(), jstNode);
        if (cQualifier != null) {
            jstIdentifier.setQualifier(cQualifier);
        }
        return this.processSimpleName(qualifiedName.getName(), false, false, (IExpr)jstIdentifier.getQualifier(), jstIdentifier, jstNode);
    }

    @Override
    public IExpr processInstanceCreation(ClassInstanceCreation cic, IExpr jstQualifier, IJstType jstType, List<IExpr> jstArgs, BaseJstNode jstNode) {
        if (jstType == null) {
            return null;
        }
        CustomType cType = this.getMetaProvider().getCustomType(jstType.getName());
        if (cType == null) {
            return null;
        }
        IExpr rtnExpr = this.delegate(cic, jstQualifier, cType, jstNode);
        if (rtnExpr != null) {
            return rtnExpr;
        }
        CustomMethod cMtd = this.getCustomMethod(cType, jstType.getSimpleName(), jstArgs, jstType.getConstructor());
        if (cMtd == null) {
            return null;
        }
        String jstMtdName = cMtd.getJstName();
        JstIdentifier identifier = new JstIdentifier(jstMtdName);
        if (cMtd.getJstOwnerTypeName() != null) {
            JstType type = JstCache.getInstance().getType(cMtd.getJstOwnerTypeName(), true);
            JstIdentifier qualifier = new JstIdentifier(cMtd.getJstOwnerTypeName());
            qualifier.setJstBinding((IJstNode)type);
            qualifier.setType((IJstType)type);
            identifier.setQualifier(qualifier);
            this.getDataTypeTranslator().addImport((IJstType)type, jstNode.getRootType(), type.getName());
        }
        MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
        mtdCall.setResultType(jstType);
        mtdCall.setArgs(jstArgs);
        return mtdCall;
    }

    @Override
    public IExpr processMtdInvocation(ASTNode mtdInvocation, boolean hasSuper, IExpr jstQualifier, JstIdentifier jstIdentifier, List<IExpr> jstArgs, BaseJstNode jstNode) {
        String mtdName;
        IExpr rtnExpr;
        IJstType bindingType;
        if (jstIdentifier == null) {
            return null;
        }
        SimpleName astName = null;
        if (mtdInvocation instanceof MethodInvocation) {
            astName = ((MethodInvocation)mtdInvocation).getName();
        } else if (mtdInvocation instanceof SuperMethodInvocation) {
            astName = ((SuperMethodInvocation)mtdInvocation).getName();
        } else {
            return null;
        }
        JstType ownerType = jstNode.getOwnerType();
        IJstMethod jstMtd = (IJstMethod)jstIdentifier.getJstBinding();
        IJstType varType = null;
        CustomType cType = null;
        CustomMethod cMtd = null;
        IExpr qualifierExpr = jstQualifier;
        if (qualifierExpr == null) {
            qualifierExpr = jstIdentifier.getQualifier();
        }
        if (qualifierExpr != null) {
            varType = TranslateHelper.Type.getType(qualifierExpr);
            if (varType == null) {
                String name = qualifierExpr.toString();
                varType = this.getCtx().getProvider().getDataTypeTranslator().findJstType(name, (BaseJstNode)ownerType);
            }
        } else {
            if (jstMtd != null) {
                varType = jstMtd.getRtnType();
            }
            jstIdentifier.setQualifier(null);
        }
        if (jstMtd != null && (bindingType = jstMtd.getOwnerType()) instanceof JstType) {
            MethodKey mtdKey;
            TranslateInfo tInfo = this.getCtx().getTranslateInfo((JstType)bindingType);
            CustomInfo cInfo = tInfo.getMethodCustomInfo(mtdKey = MethodKey.genMethodKey(jstMtd));
            IJstType asType = cInfo.getAsType();
            if (asType != null) {
                varType = asType;
                cType = this.getCustomType(asType);
            }
            if (cType != null) {
                jstIdentifier.setName(cInfo.getAsName());
            }
        }
        if (cType == null) {
            cType = this.getCustomType(varType);
        }
        if (cType != null) {
            cMtd = this.getCustomMethod(cType, jstIdentifier.getName(), jstArgs, jstMtd);
        }
        if ((rtnExpr = this.delegate((Name)astName, hasSuper, qualifierExpr, jstIdentifier, jstArgs, varType, cType, cMtd, jstNode)) != null) {
            return rtnExpr;
        }
        if (cType == null || cMtd == null) {
            return null;
        }
        if (cMtd.getAttr().isExcluded()) {
            if (jstMtd != null) {
                TranslateHelper.Method.validateMethodReference(jstMtd, (ASTNode)astName, jstNode, this);
            } else {
                this.getCtx().getLogger().logError("ExcludedMethod", "'" + cMtd.getJavaName() + "' of type '" + cType.getJavaName() + "' is excluded.", this, mtdInvocation, jstNode);
            }
            return null;
        }
        if (cMtd.getAttr().isMappedToJS() || cMtd.getAttr().isMappedToVJO()) {
            MtdInvocationExpr mtdCall = new MtdInvocationExpr(cMtd.getJstName(), new IExpr[0]);
            if (jstArgs != null) {
                for (IExpr e : jstArgs) {
                    mtdCall.addArg(e);
                }
            }
            if (cMtd.getJstOwnerTypeName() != null) {
                mtdCall.setQualifyExpr((IExpr)new JstIdentifier(cMtd.getJstOwnerTypeName()));
                if (cMtd.getAttr().isMappedToVJO()) {
                    JstType type = JstCache.getInstance().getType(cMtd.getJstOwnerTypeName(), true);
                    type.addExtend((IJstType)JstCache.getInstance().getType("vjo.Object"));
                    this.getDataTypeTranslator().addImport((IJstType)type, jstNode.getRootType(), type.getName());
                    TranslateInfo tInfo = TranslateCtx.ctx().getTranslateInfo(ownerType);
                    tInfo.addActiveImport((IJstType)type);
                }
            }
            return mtdCall;
        }
        String methodOwnerType = cMtd.getJstOwnerTypeName();
        if (methodOwnerType != null && !methodOwnerType.equals(cType.getJstName())) {
            IJstType toOwnerType = this.getDataTypeTranslator().toJstType(cMtd.getJstOwnerTypeName(), jstNode.getOwnerType());
            this.getDataTypeTranslator().addImport(toOwnerType, jstNode.getOwnerType(), toOwnerType.getSimpleName());
        }
        if (qualifierExpr != null && qualifierExpr.toExprText() != null && qualifierExpr.toExprText().equals(TranslateHelper.getShortName(cType.getJavaName()))) {
            qualifierExpr = new TextExpr(cType.getJstName());
        }
        if (cMtd.getAttr().isJavaOnly()) {
            return qualifierExpr;
        }
        String clientMtdName = cMtd.getJstName();
        if (clientMtdName == null) {
            return qualifierExpr;
        }
        jstIdentifier.setName(clientMtdName);
        if (cMtd.getRemoveQualifier()) {
            jstIdentifier.setQualifier(null);
            return jstIdentifier;
        }
        if (methodOwnerType != null && !methodOwnerType.equals(cType.getJstName())) {
            JstIdentifier qualifier = new JstIdentifier(methodOwnerType);
            qualifier.setJstBinding((IJstNode)JstCache.getInstance().getType(methodOwnerType));
            jstIdentifier.setQualifier(qualifier);
            MtdInvocationExpr mtdCall = new MtdInvocationExpr(jstIdentifier, new IExpr[0]);
            if (this.isInstance(qualifierExpr)) {
                mtdCall.addArg(qualifierExpr);
            }
            if (jstArgs != null) {
                for (IExpr e : jstArgs) {
                    mtdCall.addArg(e);
                }
            }
            IJstType jstType = this.getDataTypeTranslator().toJstType(cMtd.getJstOwnerTypeName(), jstNode.getOwnerType());
            IJstMethod jstMethod = jstType.getMethod(cMtd.getJstName());
            mtdCall.setResultType(jstMethod.getRtnType());
            return mtdCall;
        }
        if (!cMtd.isProperty()) {
            MtdInvocationExpr mtdCall = new MtdInvocationExpr(jstIdentifier, new IExpr[0]);
            mtdCall.setQualifyExpr(jstQualifier);
            String rtnTypeName = cMtd.getJstReturnTypeName();
            Class[] argTypes = new Class[jstArgs.size()];
            boolean failed = false;
            if (jstArgs != null) {
                argTypes = new Class[jstArgs.size()];
                int i = 0;
                for (IExpr e : jstArgs) {
                    mtdCall.addArg(e);
                    if (rtnTypeName != null) continue;
                    if (e.getResultType() == null) {
                        argTypes[i] = null;
                        failed = true;
                        continue;
                    }
                    String forN = e.getResultType().getName();
                    Class<?> pT = DataTypeHelper.getPrimitiveClass((String)forN);
                    if (pT == null) {
                        try {
                            pT = Class.forName(forN);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            failed = true;
                        }
                        if (pT != null) {
                            argTypes[i] = pT;
                        }
                    } else {
                        argTypes[i] = pT;
                    }
                    ++i;
                }
            }
            if (rtnTypeName == null && !failed && cType.getJavaType() != null) {
                Method method = null;
                try {
                    String javaMethodName = cMtd.getJavaName();
                    method = cType.getJavaType().getMethod(javaMethodName, argTypes);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method != null) {
                    rtnTypeName = method.getReturnType().getSimpleName().contains("String") ? method.getReturnType().getSimpleName() : method.getReturnType().getName();
                }
            }
            if (rtnTypeName != null) {
                mtdCall.setResultType((IJstType)JstCache.getInstance().getType(rtnTypeName));
            }
            return mtdCall;
        }
        if (!cMtd.isProperty()) {
            return null;
        }
        if (jstQualifier == null) {
            qualifierExpr = null;
        }
        if ((mtdName = jstIdentifier.getName()).startsWith("get") || mtdName.startsWith("set")) {
            mtdName = String.valueOf(mtdName.substring(3, 4).toLowerCase()) + mtdName.substring(4, mtdName.length());
            jstIdentifier.setName(mtdName);
        }
        if (jstArgs != null && jstArgs.size() > 0) {
            PtySetter setter = new PtySetter(jstIdentifier, qualifierExpr, this.processArgs((ASTNode)astName, jstArgs, jstNode));
            setter.setParent((IJstNode)jstNode);
            return setter;
        }
        PtyGetter getter = new PtyGetter(jstIdentifier, qualifierExpr);
        getter.setParent((IJstNode)jstNode);
        return getter;
    }

    @Override
    public boolean processMethodBody(MethodDeclaration astMtd, JstMethod jstMtd) {
        if (astMtd == null || jstMtd == null || jstMtd.getOwnerType() == null) {
            return false;
        }
        CustomType cType = null;
        CustomMethod cMtd = null;
        cType = this.getMetaProvider().getCustomType(jstMtd.getOwnerType().getName());
        if (cType == null) {
            return false;
        }
        cMtd = this.getCustomMethod(cType, astMtd);
        if (cMtd == null) {
            return false;
        }
        String delegateType = cMtd.getDelegateTypeName();
        if (delegateType == null) {
            return false;
        }
        JstBlock body = new JstBlock();
        StringBuilder sb = new StringBuilder();
        Type rtnType = astMtd.getReturnType2();
        boolean shouldReturn = false;
        if (rtnType != null) {
            if (!(rtnType instanceof PrimitiveType)) {
                shouldReturn = true;
            } else if (((PrimitiveType)rtnType).getPrimitiveTypeCode() != PrimitiveType.VOID) {
                shouldReturn = true;
            }
        }
        if (shouldReturn) {
            sb.append("return ");
        }
        sb.append(delegateType).append('.').append(cMtd.getJstName()).append('(');
        Iterator it = astMtd.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            sb.append(v.getName().toString());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(");");
        TextStmt text = new TextStmt(sb.toString());
        body.addStmt((IStmt)text);
        jstMtd.setBlock(body);
        return true;
    }

    @Override
    public boolean processTypeBody(List<?> bodyDeclaration, JstType jstType) {
        return false;
    }

    @Override
    public JstIdentifier getStaticTypeQualifier(IJstType jstType, BaseJstNode jstNode) {
        if (jstType == null) {
            return null;
        }
        CustomType cusType = this.getMetaProvider().getCustomType(jstType.getName());
        if (cusType != null && cusType.removeTypeQualifier()) {
            return null;
        }
        return null;
    }

    protected ICustomMetaProvider getMetaProvider() {
        return this.m_metaProvider;
    }

    protected CustomType getCustomType(IJstType jstType) {
        if (jstType == null) {
            return null;
        }
        if (jstType instanceof JstArray) {
            return this.getMetaProvider().getCustomType(Object.class.getName());
        }
        CustomType cType = this.getMetaProvider().getCustomType(jstType.getName());
        if (cType != null) {
            return cType;
        }
        String mappedName = DataTypeHelper.getJavaTypeNameForNative((String)jstType.getName());
        if (mappedName != null && (cType = this.getMetaProvider().getCustomType(mappedName)) != null) {
            return cType;
        }
        if (jstType.getExtend() != null) {
            cType = this.getCustomType(jstType.getExtend());
        }
        if (cType != null) {
            return cType;
        }
        for (IJstType itf : jstType.getSatisfies()) {
            cType = this.getCustomType(itf.getExtend());
            if (cType == null) continue;
            return cType;
        }
        return null;
    }

    protected CustomField getCustomField(Name astName, JstIdentifier jstIdentifier, BaseJstNode jstNode) {
        CustomType cType = null;
        if (jstIdentifier != null) {
            IJstType jstType;
            PackageMapping pkgMapping = this.getCtx().getConfig().getPackageMapping();
            if (jstIdentifier.getJstBinding() != null && (jstType = jstIdentifier.getJstBinding().getOwnerType()) != null) {
                cType = this.getMetaProvider().getCustomType(pkgMapping.mapFrom(jstType.getName()));
            }
            if (cType == null && jstIdentifier.getQualifier() != null) {
                jstType = jstIdentifier.getQualifier().getType();
                if (jstType != null) {
                    cType = this.getMetaProvider().getCustomType(pkgMapping.mapFrom(jstType.getName()));
                } else if (jstIdentifier.getQualifier().getJstBinding() != null && (jstType = jstIdentifier.getQualifier().getJstBinding().getOwnerType()) != null) {
                    cType = this.getMetaProvider().getCustomType(pkgMapping.mapFrom(jstType.getName()));
                }
            }
        }
        if (cType != null) {
            return cType.getCustomField(astName.toString());
        }
        return null;
    }

    protected CustomMethod getCustomMethod(CustomType cType, MethodDeclaration astMtd) {
        CustomMethod cMtd2;
        MethodKey mtdKey = MethodKey.genMethodKey(astMtd);
        Collection<CustomMethod> cMtds = cType.getCustomMethods(mtdKey.getName());
        if (cMtds == null || cMtds.isEmpty()) {
            return null;
        }
        if (cMtds.size() == 1 && !(cMtd2 = cMtds.iterator().next()).isLookupBySignature()) {
            return cMtd2;
        }
        for (CustomMethod cMtd2 : cMtds) {
            if (!mtdKey.equals(cMtd2.getKey())) continue;
            return cMtd2;
        }
        return null;
    }

    protected CustomMethod getCustomMethod(CustomType cType, String mtdName, List<IExpr> jstArgs, IJstMethod jstMtd) {
        CustomMethod cMtd;
        if (mtdName == null) {
            return null;
        }
        Collection<CustomMethod> cMtds = cType.getCustomMethods(mtdName);
        if (cMtds == null || cMtds.isEmpty()) {
            return null;
        }
        if (cMtds.size() == 1 && !(cMtd = cMtds.iterator().next()).isLookupBySignature()) {
            return cMtd;
        }
        MethodKey mtdKey = MethodKey.genMethodKey(jstMtd);
        if (mtdKey != null) {
            for (CustomMethod cMtd2 : cMtds) {
                if (!mtdKey.equals(cMtd2.getKey())) continue;
                return cMtd2;
            }
            return null;
        }
        return this.getCustomMethod(mtdName, jstArgs, cMtds);
    }

    protected CustomMethod getCustomMethod(String mtdName, List<IExpr> jstArgs, Collection<CustomMethod> cMtds) {
        if (mtdName == null || jstArgs == null || cMtds == null) {
            return null;
        }
        CustomMethod varArgMtd = null;
        for (CustomMethod cMtd : cMtds) {
            String argTypeName;
            IJstType argType;
            IExpr arg;
            MethodKey mtdKey = cMtd.getKey();
            if (!mtdName.equals(mtdKey.getName())) continue;
            int size = mtdKey.getArgTypeNames().size();
            if (mtdKey.isVarArg() ? jstArgs.size() < --size : jstArgs.size() != size) continue;
            boolean found = true;
            int i = 0;
            while (i < size) {
                arg = jstArgs.get(i);
                if (arg == null) {
                    return null;
                }
                argType = arg.getResultType();
                if (argType == null) {
                    return null;
                }
                argTypeName = argType.getName();
                if (argTypeName == null) {
                    return null;
                }
                if (!argTypeName.equals(mtdKey.getArgTypeNames().get(i))) {
                    found = false;
                    break;
                }
                ++i;
            }
            if (!found) continue;
            i = size;
            while (i < jstArgs.size()) {
                arg = jstArgs.get(i);
                if (arg == null) {
                    return null;
                }
                argType = arg.getResultType();
                if (argType == null) {
                    return null;
                }
                argTypeName = argType.getName();
                if (argTypeName == null) {
                    return null;
                }
                if (!argTypeName.equals(mtdKey.getArgTypeNames().get(size))) {
                    found = false;
                    break;
                }
                ++i;
            }
            if (!found) continue;
            if (mtdKey.isVarArg()) {
                varArgMtd = cMtd;
                continue;
            }
            return cMtd;
        }
        if (varArgMtd != null) {
            return varArgMtd;
        }
        return null;
    }

    protected IPrivilegedProcessor getTypeProcessor(IJstType jstType) {
        if (jstType == null) {
            return null;
        }
        IPrivilegedProcessor p = this.getMetaProvider().getPrivilegedTypeProcessor(jstType.getName());
        if (p != null) {
            return p;
        }
        for (IJstType extend : jstType.getExtends()) {
            p = this.getTypeProcessor(extend);
            if (p == null) continue;
            return p;
        }
        for (IJstType itf : jstType.getSatisfies()) {
            p = this.getTypeProcessor(itf);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    protected IPrivilegedProcessor getMethodProcessor(IJstType jstType, String mtdName) {
        if (jstType == null) {
            return null;
        }
        IPrivilegedProcessor p = this.getMetaProvider().getPrivilegedMethodProcessor(jstType.getName(), mtdName);
        if (p != null) {
            return p;
        }
        for (IJstType extend : jstType.getExtends()) {
            p = this.getMethodProcessor(extend, mtdName);
            if (p == null) continue;
            return p;
        }
        for (IJstType itf : jstType.getSatisfies()) {
            p = this.getMethodProcessor(itf, mtdName);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    protected IPrivilegedProcessor getProcessor(IJstType jstType, String mtdName) {
        IPrivilegedProcessor p = this.getMethodProcessor(jstType, mtdName);
        if (p != null) {
            return p;
        }
        return this.getTypeProcessor(jstType);
    }

    protected IExpr delegate(Name astName, boolean isSuper, IExpr jstQualifier, JstIdentifier jstIdentifier, List<IExpr> jstArgs, IJstType ownerType, CustomType cType, CustomMethod cMtd, BaseJstNode jstNode) {
        IPrivilegedProcessor processor = this.getProcessor(ownerType, jstIdentifier.getName());
        if (processor != null) {
            try {
                IExpr expr = processor.processMtdInvocation((ASTNode)astName, jstIdentifier, jstQualifier, jstArgs, isSuper, jstNode, cType, cMtd);
                if (expr != null) {
                    return expr;
                }
            }
            catch (Throwable throwable) {
                this.getLogger().logError("CustomProcessorException", "unhandled exception in processMtdInvocation of " + processor.getClass().getName(), this, (ASTNode)astName, jstNode);
            }
        }
        return null;
    }

    protected IExpr delegate(ClassInstanceCreation cic, IExpr jstQualifier, CustomType cType, BaseJstNode jstNode) {
        IPrivilegedProcessor processor = this.getMetaProvider().getPrivilegedConstructorProcessor(cType.getJavaName());
        if (processor != null) {
            try {
                List args = cic.arguments();
                ArrayList<IExpr> argExprList = new ArrayList<IExpr>(args.size());
                for (Object a : args) {
                    if (a instanceof Expression) {
                        argExprList.add(this.getExprTranslator().processExpression((Expression)a, jstNode));
                        continue;
                    }
                    this.getLogger().logUnhandledNode(this, (ASTNode)a, jstNode);
                }
                IExpr expr = processor.processInstanceCreation(cic, jstNode, argExprList, cType);
                if (expr != null) {
                    return expr;
                }
            }
            catch (Throwable throwable) {
                this.getLogger().logError("CustomProcessorException", "unhandled exception in processInstanceCreation of " + processor.getClass().getName(), this, (ASTNode)cic, jstNode);
            }
        }
        return null;
    }

    protected JstIdentifier processSimpleName(SimpleName astName, boolean hasSuper, boolean hasThis, IExpr jstQualifier, JstIdentifier jstIdentifier, BaseJstNode jstNode) {
        CustomField cField = this.getCustomField((Name)astName, jstIdentifier, jstNode);
        if (cField == null) {
            return null;
        }
        CustomAttr cAttr = cField.getAttr();
        if (cAttr.isExcluded()) {
            this.getLogger().logError("ExcludedField", "Unsupported field '" + cField.getJavaName() + "'", this, (ASTNode)astName, jstNode);
            return null;
        }
        if (cField.getJstName() != null) {
            jstIdentifier.setName(cField.getJstName());
            if (TranslateHelper.Expression.removeQualifier((IExpr)jstIdentifier, (IJstNode)jstNode)) {
                jstIdentifier.setQualifier(null);
            }
        }
        if (cField.getJstOwnerTypeName() != null) {
            jstIdentifier.setQualifier(new JstIdentifier(cField.getJstOwnerTypeName()));
            JstType jstType = JstCache.getInstance().getType(cField.getJstOwnerTypeName(), true);
            if (jstType != null) {
                if (cAttr.isMappedToJS()) {
                    this.getCtx().addJsType(jstType.getName(), (IJstType)jstType);
                } else if (cAttr.isMappedToVJO() || cAttr.isJsProxy()) {
                    this.getDataTypeTranslator().addImport((IJstType)jstType, jstNode.getOwnerType(), jstType.getName());
                }
                jstIdentifier.setJstBinding((IJstNode)jstType);
            }
        }
        if (cField.getJstTypeName() != null) {
            String fldTypeName = cField.getJstTypeName();
            IJstType fldType = this.getDataTypeTranslator().toJstType(fldTypeName, jstNode.getOwnerType());
            if (fldType != null) {
                jstIdentifier.setType(fldType);
                if (cAttr.isMappedToJS()) {
                    this.getCtx().addJsType(fldType.getName(), fldType);
                } else if (cAttr.isMappedToVJO() || cAttr.isJsProxy()) {
                    this.getDataTypeTranslator().addImport(fldType, jstNode.getOwnerType(), fldType.getName());
                }
            }
        }
        return jstIdentifier;
    }

    protected boolean isInstance(IExpr jstQualifier) {
        if (jstQualifier == null || jstQualifier.toExprText() == null || jstQualifier.getResultType() == null) {
            return false;
        }
        return !jstQualifier.toExprText().equals(jstQualifier.getResultType().getName());
    }

    protected String processArgs(ASTNode astNode, List<IExpr> jstArgs, BaseJstNode jstNode) {
        if (jstArgs == null || jstArgs.size() != 1) {
            this.getLogger().logError("InvalidArgs", "should be only one argument", this, astNode, jstNode);
            return null;
        }
        return jstArgs.get(0).toExprText();
    }
}

