/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.generate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrFilters;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.serializers.ISerializableForVjo;

public class DefaultJsrFilters
implements IJsrFilters {
    public static String VJO = "vjo";
    public static final String METHOD_SUFFIX = "_";
    private static final List<String> s_satisfies = Arrays.asList("org.eclipse.vjet.vjo.java.io.Serializable", "org.eclipse.vjet.dsf.serializers.ISerializableForVjo", "org.eclipse.vjet.vjo.java.lang.Appendable", "java.lang.CharSequence");
    private static final List<String> s_extends = Arrays.asList("Object", "vjo.Object", "vjo.Enum", "org.eclipse.vjet.dsf.aggregator.serializable.BaseVjoSerializable", "java.security.BasicPermission");
    private static final List<String> RESERVED_WORDS = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "null", "package", "private", "protected", "public", "return", "short", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");
    private static final List<String> s_reserved_methods = Arrays.asList("hashCode", "toString", "getClass", "getClassName", "finalize", "call", "chuck", "getProp", "hasReturn", "setProp", "generate", "getClassName", "getCmpMeta", "getCompSpec", "getInstanceId", "getInstancePropertySetters", "getInstantiationJs", "getJsScopedVarRef", "getParams", "getRefJs", "getValue", "getValueType", "getVariableRef", "isGenned", "isHandler", "isInstance", "setInstanceId", "setIsHandler", "setValue");
    private static final Set<String> s_primitives = new HashSet<String>(23);
    private static final Set<String> s_wrappers;
    private static final Set<String> s_excludeList;
    private static final Map<String, Class<?>> s_javaSerializable;

    static {
        s_primitives.add(String.class.getSimpleName());
        s_primitives.add(Integer.TYPE.getSimpleName());
        s_primitives.add(Void.TYPE.getSimpleName());
        s_primitives.add(Boolean.TYPE.getSimpleName());
        s_primitives.add(Short.TYPE.getSimpleName());
        s_primitives.add(Long.TYPE.getSimpleName());
        s_primitives.add(Float.TYPE.getSimpleName());
        s_primitives.add(Double.TYPE.getSimpleName());
        s_primitives.add(Character.TYPE.getSimpleName());
        s_primitives.add(Byte.TYPE.getSimpleName());
        s_wrappers = new HashSet<String>(23);
        s_wrappers.add(Boolean.class.getSimpleName());
        s_wrappers.add(Integer.class.getSimpleName());
        s_wrappers.add(Long.class.getSimpleName());
        s_wrappers.add(Float.class.getSimpleName());
        s_wrappers.add(Double.class.getSimpleName());
        s_wrappers.add(Short.class.getSimpleName());
        s_wrappers.add(Byte.class.getSimpleName());
        s_wrappers.add(Character.class.getSimpleName());
        s_wrappers.add(Object.class.getSimpleName());
        s_excludeList = new HashSet<String>(3);
        s_excludeList.add(String.class.getName());
        s_excludeList.add(Object.class.getName());
        s_excludeList.add(Math.class.getName());
        s_javaSerializable = new HashMap(3);
        s_javaSerializable.put("org.eclipse.vjet.vjo." + ArrayList.class.getName(), ArrayList.class);
        s_javaSerializable.put("org.eclipse.vjet.vjo." + HashMap.class.getName(), HashMap.class);
    }

    @Override
    public boolean isJsr(String jstTypeName) {
        return !jstTypeName.startsWith("java.") && !this.isJavaPrimitiveOrWrapper(jstTypeName);
    }

    @Override
    public boolean isSkipImport(IJstType jstType) {
        String name = this.normalize(jstType.getName());
        return this.isJavaPrimitiveOrWrapper(name) || this.isJavaLang(name);
    }

    @Override
    public boolean isJavaPrimitiveOrWrapper(String name) {
        return this.isJavaPrimitive(name) || this.isJavaWrapper(name);
    }

    @Override
    public boolean isJavaPrimitive(String name) {
        return s_primitives.contains(name);
    }

    @Override
    public boolean isJavaWrapper(String name) {
        return s_wrappers.contains(name);
    }

    @Override
    public boolean isJavaLang(String typeName) {
        int packageIndex = typeName.lastIndexOf(".");
        if (packageIndex < 1) {
            return false;
        }
        return "java.lang".equals(typeName.substring(0, packageIndex));
    }

    @Override
    public String normalize(String sourceName) {
        if (sourceName.contains(String.valueOf(VJO) + ".java.logging.")) {
            return sourceName.replace("org.eclipse.vjet." + VJO + ".java.logging.", "java.util.logging.");
        }
        return sourceName.replace("org.eclipse.vjet." + VJO + ".java.", "java.");
    }

    @Override
    public boolean isSkipSatisfies(IJstType jstType) {
        return s_satisfies.contains(jstType.getName());
    }

    @Override
    public boolean isSkipMethod(IJstMethod jstMethod) {
        return false;
    }

    @Override
    public boolean isSkipExtends(IJstType jstType) {
        return s_extends.contains(jstType.getName());
    }

    @Override
    public String decorateMethod(IJstMethod jstMethod) {
        String mtdName = jstMethod.getOriginalName();
        System.out.println(mtdName);
        List args = jstMethod.getArgs();
        for (String keyword : RESERVED_WORDS) {
            if (!keyword.equals(mtdName)) continue;
            return String.valueOf(mtdName) + METHOD_SUFFIX;
        }
        if (s_reserved_methods.contains(mtdName) || "equals".equals(mtdName) && args.size() == 1 && ((JstArg)args.get(0)).getType().getSimpleName().equals("Object")) {
            return String.valueOf(mtdName) + METHOD_SUFFIX;
        }
        return mtdName;
    }

    @Override
    public boolean isSkipImportJsr(IJstType jstType) {
        String name = jstType.getName();
        return s_excludeList.contains(name);
    }

    @Override
    public boolean isSerializableForVjo(IJstType type, boolean isRoot) {
        boolean ret = false;
        if (type == null) {
            return false;
        }
        if (isRoot && this.getJavaTypeForSerialable(type) != null) {
            return true;
        }
        if (this.isJavaPrimitiveOrWrapper(type.getName()) || type.isEnum()) {
            return false;
        }
        String forName = ISerializableForVjo.class.getName();
        if (type.isInterface()) {
            if (type.getName().equals(forName)) {
                return true;
            }
        } else {
            if (type.getName().equals(forName)) {
                return true;
            }
            for (IJstType iType : type.getSatisfies()) {
                if (iType.getName().equals(forName)) {
                    return true;
                }
                ret = this.isSerializableForVjo(iType, false);
                if (!ret) continue;
                return ret;
            }
        }
        for (IJstType eType : type.getExtends()) {
            ret = this.isSerializableForVjo(eType, false);
            if (!ret) continue;
            return ret;
        }
        return false;
    }

    @Override
    public Class<?> getJavaTypeForSerialable(IJstType type) {
        return s_javaSerializable.get(type.getName());
    }

    @Override
    public boolean isSkipMethodAndProperties(String fullName) {
        return fullName.startsWith("org.eclipse.vjet.vjo.java.");
    }

    @Override
    public String decorateProperty(String name) {
        if (RESERVED_WORDS.contains(name)) {
            return String.valueOf(name) + METHOD_SUFFIX;
        }
        return name;
    }
}

