/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.generate;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.generate.Indenter;
import org.eclipse.vjet.dsf.jsgen.shared.generate.SourceGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.util.GeneratorJstHelper;
import org.eclipse.vjet.dsf.jsnative.anno.JsNativeMeta;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class NativeJsProxyGenerator
extends SourceGenerator {
    private static final String IMPORT = "import ";
    private static final String PACKAGE = "package ";
    private static final String VJOX = String.valueOf(VjoConvention.getVjoExtScope()) + ".";
    private static final String ORG_ECLIPSE = "org.eclipse.";
    private static final String VJOX_JAVA = "org.eclipse." + VJOX + "java.";
    private static final String VJOX_JAVA_LANG = String.valueOf(VJOX_JAVA) + "lang.";
    private static final String DEFAULT_PARAM_PREFIX = "p";
    private IJstType m_clzType = null;
    private TypeMetaMgr m_javaTypeMgr = null;
    private TypeMetaMgr m_customTypeMgr = null;
    private TypeMetaMgr m_jsNativeTypeMgr = null;
    private List<MethodMeta> m_constructors = null;
    private List<MethodMeta> m_staticMethods = null;
    private List<MethodMeta> m_instanceMethods = null;
    private List<IJstProperty> m_constants = null;
    private List<IJstProperty> m_staticProperties = null;
    private List<IJstProperty> m_instanceProperties = null;
    private LinkedHashSet<String> m_frameworkImports = null;
    private Set<String> m_currentDefinedTypes = null;
    private InnerTypeInfo m_innerTypeInfo = null;
    private Map<IJstType, InnerTypeInfo> m_innerTypeInfoMap = null;
    private boolean m_hasOlType = false;
    private boolean m_hasFnType = false;
    private boolean m_needsIJsJavaProxy = false;
    private boolean m_hasJsTypeRef = false;
    private boolean m_hasNonFnRef = false;
    private static final String PROP_MODIFIER = "public ";
    private static final String STATIC_PROP_MODIFIER = "public static ";
    private static final String PROP_GETTER = "return getProperty(";
    private static final String STATIC_PROP_GETTER = "return getStaticProperty(";
    private static final String PROP_SETTER = "setProperty(";
    private static final String STATIC_PROP_SETTER = "setStaticProperty(";
    private static final Stack<SimpleParam> EMPTY_STACK = new Stack();
    private static final Map<String, String> s_javaWrapperTypes = new HashMap<String, String>();
    private static final Map<String, String> s_javaWrapperTypeFullNames;
    private static final Set<String> s_primitiveTypes;
    private static final Set<String> s_reservedName;
    private static final Map<String, String> s_nativeToProxyMapping;

    static {
        s_javaWrapperTypes.put(Boolean.TYPE.getName(), Boolean.class.getSimpleName());
        s_javaWrapperTypes.put(Byte.TYPE.getName(), Byte.class.getSimpleName());
        s_javaWrapperTypes.put(Short.TYPE.getName(), Short.class.getSimpleName());
        s_javaWrapperTypes.put(Integer.TYPE.getName(), Integer.class.getSimpleName());
        s_javaWrapperTypes.put(Long.TYPE.getName(), Long.class.getSimpleName());
        s_javaWrapperTypes.put(Float.TYPE.getName(), Float.class.getSimpleName());
        s_javaWrapperTypes.put(Double.TYPE.getName(), Double.class.getSimpleName());
        s_javaWrapperTypes.put(Character.TYPE.getName(), Character.class.getSimpleName());
        s_javaWrapperTypes.put("INativeJsFuncProxy<?>", "INativeJsFuncProxy");
        s_javaWrapperTypeFullNames = new HashMap<String, String>();
        s_javaWrapperTypeFullNames.put(Boolean.TYPE.getName(), Boolean.class.getName());
        s_javaWrapperTypeFullNames.put(Byte.TYPE.getName(), Byte.class.getName());
        s_javaWrapperTypeFullNames.put(Short.TYPE.getName(), Short.class.getName());
        s_javaWrapperTypeFullNames.put(Integer.TYPE.getName(), Integer.class.getName());
        s_javaWrapperTypeFullNames.put(Long.TYPE.getName(), Long.class.getName());
        s_javaWrapperTypeFullNames.put(Float.TYPE.getName(), Float.class.getName());
        s_javaWrapperTypeFullNames.put(Double.TYPE.getName(), Double.class.getName());
        s_javaWrapperTypeFullNames.put(Character.TYPE.getName(), Character.class.getName());
        s_javaWrapperTypeFullNames.put("org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy<?>", "org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy");
        s_primitiveTypes = new HashSet<String>();
        s_primitiveTypes.add(String.class.getSimpleName());
        s_primitiveTypes.add(String.class.getName());
        s_primitiveTypes.add(Boolean.TYPE.getName());
        s_primitiveTypes.add(Byte.TYPE.getName());
        s_primitiveTypes.add(Short.TYPE.getName());
        s_primitiveTypes.add(Integer.TYPE.getName());
        s_primitiveTypes.add(Long.TYPE.getName());
        s_primitiveTypes.add(Float.TYPE.getName());
        s_primitiveTypes.add(Double.TYPE.getName());
        s_primitiveTypes.add(Character.TYPE.getName());
        s_reservedName = new HashSet<String>();
        s_reservedName.add(String.class.getSimpleName());
        s_reservedName.add(Class.class.getSimpleName());
        s_reservedName.add(Byte.TYPE.getName());
        s_reservedName.add(Short.TYPE.getName());
        s_reservedName.add(Integer.TYPE.getName());
        s_reservedName.add(Long.TYPE.getName());
        s_reservedName.add(Float.TYPE.getName());
        s_reservedName.add(Double.TYPE.getName());
        s_reservedName.add(Character.TYPE.getName());
        s_reservedName.add("class");
        s_reservedName.add("interface");
        s_reservedName.add("static");
        s_reservedName.add("public");
        s_reservedName.add("private");
        s_reservedName.add("protected");
        s_reservedName.add("final");
        s_reservedName.add("synchronized");
        s_reservedName.add("extends");
        s_reservedName.add("implements");
        s_nativeToProxyMapping = new HashMap<String, String>();
        s_nativeToProxyMapping.put("org.eclipse.vjet.dsf.jsnative.global.Array", "org.eclipse.vjet.dsf.dap.proxy.Array");
        s_nativeToProxyMapping.put("org.eclipse.vjet.dsf.jsnative.global.ObjLiteral", "org.eclipse.vjet.dsf.dap.proxy.Ol");
        s_nativeToProxyMapping.put("org.eclipse.vjet.dsf.jsnative.global.Function", "org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy");
    }

    public NativeJsProxyGenerator(PrintWriter writer, CodeStyle style) {
        super(writer, new Indenter(writer, style), style);
    }

    public NativeJsProxyGenerator writeProxy(IJstType type) {
        return this.writeProxy(type, null);
    }

    private NativeJsProxyGenerator writeProxy(IJstType type, InnerTypeInfo innerTypeInfo) {
        this.m_innerTypeInfo = innerTypeInfo;
        this.setUp(type);
        if (this.m_innerTypeInfo == null) {
            this.writePkg();
            this.writeNewline();
            this.writeImports();
            this.writeNewline();
            this.writeClassLevelComments();
        }
        this.writeClassDefinition();
        this.getWriter().append(" {");
        this.indent();
        if (this.m_clzType.isOType()) {
            this.writeOTypeDef();
        } else {
            List embededTypes;
            this.writeFrameworkConstructors(this.m_clzType.getSimpleName());
            this.writeConstructors();
            this.writeConstants();
            this.writeProperties(true);
            this.writeProperties(false);
            if (!this.m_clzType.isInterface()) {
                for (MethodMeta meta : this.m_staticMethods) {
                    this.writeMethods(meta);
                }
            }
            for (MethodMeta meta : this.m_instanceMethods) {
                this.writeMethods(meta);
            }
            if (this.m_clzType.isClass()) {
                this.writeTypeRef();
                HashSet<String> methodNames = new HashSet<String>();
                for (MethodMeta meta : this.m_staticMethods) {
                    if (meta.m_isOverload) continue;
                    this.writeStaticFuncProxy(meta, methodNames);
                }
                String clzName = this.m_clzType.getSimpleName();
                if (!this.m_clzType.getParamNames().isEmpty()) {
                    clzName = String.valueOf(clzName) + ((JstType)this.m_clzType).getParamsDecoration();
                }
                for (MethodMeta meta : this.m_instanceMethods) {
                    if (meta.m_isOverload) continue;
                    this.writeInstanceFuncProxy(meta, methodNames, clzName);
                }
            }
            if ((embededTypes = this.m_clzType.getEmbededTypes()).size() > 0) {
                this.writeNewline();
                for (IJstType embededType : embededTypes) {
                    if (embededType.isMixin() || !embededType.getModifiers().isPublic()) continue;
                    this.writeNewline();
                    NativeJsProxyGenerator innerJsr = new NativeJsProxyGenerator(this.getWriter(), this.getStyle());
                    innerJsr.indent();
                    innerJsr.writeProxy(embededType, this.m_innerTypeInfoMap.get(embededType));
                    this.writeNewline();
                }
            }
            this.outdent();
            this.writeNewline();
            if (this.m_clzType.isEmbededType()) {
                this.writeIndent();
            }
        }
        this.getWriter().append("}");
        return this;
    }

    private void setUp(IJstType type) {
        this.m_clzType = type;
        if (this.m_innerTypeInfo == null) {
            HashSet<String> simpleNames = new HashSet<String>();
            this.m_javaTypeMgr = new TypeMetaMgr(simpleNames);
            this.m_customTypeMgr = new TypeMetaMgr(simpleNames);
            this.m_jsNativeTypeMgr = new TypeMetaMgr(simpleNames);
            this.m_constructors = new ArrayList<MethodMeta>();
            this.m_staticMethods = new ArrayList<MethodMeta>();
            this.m_instanceMethods = new ArrayList<MethodMeta>();
            this.m_constants = new ArrayList<IJstProperty>();
            this.m_staticProperties = new ArrayList<IJstProperty>();
            this.m_instanceProperties = new ArrayList<IJstProperty>();
            this.m_frameworkImports = new LinkedHashSet();
            this.m_currentDefinedTypes = new HashSet<String>(3);
            this.m_currentDefinedTypes.add(this.m_clzType.getName());
            if (!this.m_clzType.getEmbededTypes().isEmpty()) {
                this.m_innerTypeInfoMap = new HashMap<IJstType, InnerTypeInfo>(3);
            }
        } else {
            this.m_javaTypeMgr = this.m_innerTypeInfo.m_javaTypeMgr;
            this.m_customTypeMgr = this.m_innerTypeInfo.m_customTypeMgr;
            this.m_jsNativeTypeMgr = this.m_innerTypeInfo.m_jsNativeTypeMgr;
            this.m_constructors = this.m_innerTypeInfo.m_constructors;
            this.m_staticMethods = this.m_innerTypeInfo.m_staticMethods;
            this.m_instanceMethods = this.m_innerTypeInfo.m_instanceMethods;
            this.m_constants = this.m_innerTypeInfo.m_constants;
            this.m_staticProperties = this.m_innerTypeInfo.m_staticProperties;
            this.m_instanceProperties = this.m_innerTypeInfo.m_instanceProperties;
            this.m_currentDefinedTypes = this.m_innerTypeInfo.m_currentDefinedTypes;
            this.m_innerTypeInfoMap = this.m_innerTypeInfo.m_innerTypeInfoMap;
        }
        this.analyze();
    }

    private void analyze() {
        if (this.m_innerTypeInfo != null) {
            return;
        }
        this.m_customTypeMgr.addToSimpleNameMap(new TypeMeta(this.m_clzType.getName(), this.m_clzType.getSimpleName(), false));
        this.collectFrameworkImports(this.m_clzType);
        this.addCustomTypeImport(this.m_clzType.getExtends());
        this.addCustomTypeImport(this.m_clzType.getSatisfies());
        LinkedHashSet<IJstType> typeSet = new LinkedHashSet<IJstType>();
        if (!this.m_clzType.isOType()) {
            this.collectTypeFromProperties(this.m_clzType.getProperties(), typeSet, null);
            IJstMethod constructor = this.m_clzType.getConstructor();
            if (constructor != null && !(constructor instanceof ISynthesized)) {
                this.collectTypeFromMethod(constructor, typeSet, null);
            }
            for (IJstMethod method : this.m_clzType.getMethods()) {
                this.collectTypeFromMethod(method, typeSet, null);
                if (method.isOType()) continue;
                if (this.hasFunctionArg(method.getArgs())) {
                    this.m_needsIJsJavaProxy = true;
                }
                this.m_hasNonFnRef = true;
            }
        } else {
            for (IJstOType oType : this.m_clzType.getOTypes()) {
                if (oType instanceof JstObjectLiteralType) {
                    this.collectTypeFromProperties(oType.getProperties(), typeSet, null);
                    this.m_hasOlType = true;
                }
                if (!(oType instanceof JstFunctionRefType)) continue;
                this.m_needsIJsJavaProxy = true;
                this.collectTypeFromMethod(((JstFunctionRefType)oType).getMethodRef(), typeSet, null);
                this.m_hasFnType = true;
            }
            this.collectTypeFromOTypes(this.m_clzType.getOTypes(), typeSet);
        }
        this.collectTypesFromEmbeded(this.m_clzType.getEmbededTypes(), typeSet);
        this.addTypeImport(typeSet);
    }

    private boolean hasFunctionArg(List<JstArg> args) {
        if (args.size() == 0) {
            return false;
        }
        for (JstArg a : args) {
            if (!(a.getType() instanceof JstFunctionRefType)) continue;
            return true;
        }
        return false;
    }

    private void collectFrameworkImports(IJstType type) {
        this.m_frameworkImports.add("org.eclipse.vjet.dsf.javatojs.anno.AJsProxy");
        if (type.isClass() || type.isEnum()) {
            IJstType extend = type.getExtend();
            if ((extend == null || NativeJsProxyGenerator.isObject(extend) || NativeJsProxyGenerator.isEnum(extend)) && !this.m_frameworkImports.contains("org.eclipse.vjet.dsf.dap.proxy.NativeJsProxy")) {
                this.m_frameworkImports.add("org.eclipse.vjet.dsf.dap.proxy.NativeJsProxy");
            }
            if (!this.m_frameworkImports.contains("org.mozilla.mod.javascript.Scriptable")) {
                this.m_frameworkImports.add("org.mozilla.mod.javascript.Scriptable");
                this.m_frameworkImports.add("org.eclipse.vjet.dsf.javatojs.anno.AExclude");
            }
        } else if (type.isInterface() && type.getExtend() == null && !this.m_frameworkImports.contains("org.mozilla.mod.javascript.IJsJavaProxy")) {
            this.m_frameworkImports.add("org.mozilla.mod.javascript.IJsJavaProxy");
        }
    }

    private void collectTypesFromEmbeded(List<? extends IJstType> embededTypes, Set<IJstType> typeSet) {
        if (!embededTypes.isEmpty()) {
            for (IJstType iJstType : embededTypes) {
                this.m_currentDefinedTypes.add(iJstType.getName());
                if (iJstType.isMixin() || !iJstType.getModifiers().isPublic()) continue;
                this.collectFrameworkImports(iJstType);
                this.m_customTypeMgr.addToSimpleNameMap(new TypeMeta(iJstType.getName(), this.m_clzType.getSimpleName(), false));
                this.addCustomTypeImport(iJstType.getExtends());
                this.addCustomTypeImport(iJstType.getSatisfies());
                InnerTypeInfo info = new InnerTypeInfo(iJstType, this.m_javaTypeMgr, this.m_customTypeMgr, this.m_jsNativeTypeMgr, this.m_currentDefinedTypes, this.m_innerTypeInfoMap);
                this.collectTypeFromProperties(iJstType.getProperties(), typeSet, info);
                this.collectTypeFromMethod(iJstType.getConstructor(), typeSet, info);
                for (IJstMethod method : iJstType.getMethods()) {
                    this.collectTypeFromMethod(method, typeSet, info);
                    if (method.isOType()) continue;
                    this.m_hasNonFnRef = true;
                }
                this.collectTypesFromEmbeded(iJstType.getEmbededTypes(), typeSet);
            }
        }
    }

    private void collectTypeFromOTypes(List<IJstOType> types, Set<IJstType> typeSet) {
        for (IJstOType otype : types) {
            if (!(otype instanceof JstObjectLiteralType)) continue;
            for (IJstProperty prop : otype.getProperties()) {
                this.collectType(prop.getType(), typeSet);
            }
        }
    }

    private void writePkg() {
        if (this.m_clzType.getPackage() != null && this.m_clzType.getPackage().getName().length() > 0) {
            this.getWriter().append(PACKAGE).append(this.m_clzType.getPackage().getName()).append(";");
            this.writeNewline();
        }
    }

    private void writeImports() {
        this.writeImports(this.m_javaTypeMgr.getMetaItr());
        Set<String> writtenImports = this.writeFrameworkImports();
        this.writeImports(this.m_jsNativeTypeMgr.getMetaItr(), writtenImports);
        this.writeImports(this.m_customTypeMgr.getMetaItr());
    }

    private Set<String> writeFrameworkImports() {
        HashSet<String> writtenImports = new HashSet<String>();
        for (String importType : this.m_frameworkImports) {
            this.writeImport(importType, writtenImports);
        }
        if (this.m_clzType.isClass()) {
            if (this.hasNonAbstractMethod()) {
                if (this.m_hasNonFnRef) {
                    this.writeImport("org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy", writtenImports);
                }
                this.writeImport("org.eclipse.vjet.dsf.dap.proxy.NativeJsFuncProxy", writtenImports);
            }
            this.writeImport("org.eclipse.vjet.dsf.dap.proxy.NativeJsTypeRef", writtenImports);
            this.writeImport("org.eclipse.vjet.dsf.javatojs.anno.AJavaOnly", writtenImports);
        }
        if (this.m_hasJsTypeRef) {
            this.writeImport("org.eclipse.vjet.dsf.dap.proxy.NativeJsTypeRef", writtenImports);
        }
        if (!this.m_clzType.isOType() && this.hasProperty()) {
            this.writeImport("org.eclipse.vjet.dsf.javatojs.anno.AProperty", writtenImports);
        }
        if (this.m_clzType.isOType()) {
            this.writeImport("org.eclipse.vjet.dsf.javatojs.anno.AIsOType", writtenImports);
        }
        if (this.m_hasOlType) {
            this.writeImport("org.eclipse.vjet.dsf.dap.proxy.Ol", writtenImports);
            this.writeImport("org.eclipse.vjet.dsf.dap.proxy.NativeOlKeysAnno", writtenImports);
        }
        if (this.m_hasFnType) {
            this.writeImport("org.eclipse.vjet.dsf.dap.proxy.FuncRef", writtenImports);
            this.writeImport("org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy", writtenImports);
            this.writeImport("org.eclipse.vjet.dsf.dap.proxy.NativeJsHelper", writtenImports);
        }
        if (this.hasConstantInInterface()) {
            this.writeImport("org.eclipse.vjet.dsf.dap.proxy.NativeJsHelper", writtenImports);
        }
        if ((this.m_needsIJsJavaProxy || this.m_hasFnType) && !this.m_frameworkImports.contains("org.mozilla.mod.javascript.IJsJavaProxy")) {
            this.writeImport("org.mozilla.mod.javascript.IJsJavaProxy", writtenImports);
        }
        return writtenImports;
    }

    private void writeImport(String importType, Set<String> writtenImports) {
        if (writtenImports.contains(importType)) {
            return;
        }
        this.writeImport(importType);
        writtenImports.add(importType);
    }

    private void writeImports(Iterator<TypeMeta> itr) {
        while (itr.hasNext()) {
            TypeMeta meta = itr.next();
            if (meta.m_useFullName) continue;
            this.writeImport(meta.m_fullName);
        }
    }

    private void writeImports(Iterator<TypeMeta> itr, Set<String> exclude) {
        while (itr.hasNext()) {
            TypeMeta meta = itr.next();
            if (meta.m_useFullName || exclude.contains(meta.m_fullName)) continue;
            this.writeImport(meta.m_fullName);
        }
    }

    private void writeImport(String fullName) {
        this.getWriter().append(IMPORT).append(this.getType(fullName)).append(";");
        this.writeNewline();
    }

    private String getType(String fullName) {
        IJstType type;
        String[] names = fullName.split("\\.");
        if (names.length == 2 && (type = this.m_clzType.getInactiveImport(names[0])) != null && type.getOType(names[1]) != null) {
            return String.valueOf(type.getPackage().getName()) + "." + fullName;
        }
        return fullName;
    }

    private void writeClassLevelComments() {
        PrintWriter writer = this.getWriter();
        writer.append("//NativeJsProxy for " + this.m_clzType.getName() + ".js");
        this.writeNewline();
        this.writeCodeGenMarker(NativeJsProxyGenerator.class);
        this.writeNewline();
        writer.append("@").append("AJsProxy");
        this.writeNewline();
    }

    private void writeOTypeDef() {
        this.writeNewlineAndIndent();
        List oTypes = this.m_clzType.getOTypes();
        for (IJstOType oType : oTypes) {
            if (oType instanceof JstObjectLiteralType) {
                this.writeOlType((JstObjectLiteralType)oType);
            } else if (oType instanceof JstFunctionRefType) {
                this.writeOlType((JstFunctionRefType)oType);
            }
            this.writeNewlineAndIndent();
        }
        this.writeNewline();
    }

    private void writeOlType(JstFunctionRefType type) {
        PrintWriter writer = this.getWriter();
        boolean isPublic = type.getModifiers().isPublic();
        if (isPublic) {
            writer.append(PROP_MODIFIER);
        }
        writer.append("static class ").append(type.getSimpleName()).append("<T extends ").append("IJsJavaProxy").append("> extends ").append("FuncRef").append("<T> {");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append(PROP_MODIFIER).append(type.getSimpleName()).append("(").append("INativeJsFuncProxy").append("<T> proxy) {");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("super(proxy);");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
        IJstMethod meth = type.getMethodRef();
        String rtnType = NativeJsProxyGenerator.getWrapperType(this.getTypeName(meth.getRtnType()), false);
        boolean isTypeRef = meth.getRtnType() instanceof IJstRefType;
        if (isTypeRef) {
            writer.append("@SuppressWarnings(\"unchecked\")");
            this.writeNewlineAndIndent();
        }
        writer.append(PROP_MODIFIER).append(rtnType).append(" call(T thisObj");
        List args = meth.getArgs();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (JstArg arg : args) {
            writer.append(",").append(NativeJsProxyGenerator.getWrapperType(this.getTypeName(arg.getType()), false)).append(" ").append(arg.getName() == null ? DEFAULT_PARAM_PREFIX + i : arg.getName());
            sb.append(",").append(arg.getName() == null ? DEFAULT_PARAM_PREFIX + i : arg.getName());
            ++i;
        }
        writer.append(") {");
        this.indent();
        boolean isVoid = "void".equals(rtnType);
        this.writeNewlineAndIndent();
        if (isVoid) {
            rtnType = "Void";
        } else {
            writer.append("return ");
        }
        writer.append("NativeJsHelper").append(".convert(");
        if (isTypeRef) {
            writer.append("NativeJsTypeRef");
        } else {
            writer.append(rtnType);
        }
        writer.append(".class").append(",").append("super.call(thisObj").append(sb).append("));");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
    }

    private ObjectLiteralGenStrings getOlGeneratedStrings(IJstMethod constructor) {
        ObjectLiteralGenStrings o = new ObjectLiteralGenStrings();
        o.annoSig.append("@").append("NativeOlKeysAnno").append("(values={");
        boolean first = true;
        for (JstArg prop : constructor.getArgs()) {
            String name = prop.getName();
            String typeName = this.getTypeName(prop.getType());
            if (!first) {
                o.paramSig.append(",");
                o.superSig.append(",");
                o.newSig.append(",");
                o.annoSig.append(",");
            }
            o.paramSig.append(typeName).append(" ").append(name);
            o.superSig.append("\"").append(name).append("\"").append(",").append(name);
            o.newSig.append(name);
            o.annoSig.append("\"").append(name).append("\"");
            first = false;
        }
        o.annoSig.append("})");
        return o;
    }

    private void writeOlType(JstObjectLiteralType type) {
        boolean isPublic = type.getModifiers().isPublic();
        PrintWriter writer = this.getWriter();
        this.writeNewlineAndIndent();
        if (isPublic) {
            writer.append(PROP_MODIFIER);
        }
        String otypeName = type.getSimpleName();
        writer.append("static class ").append(otypeName).append(" extends ").append("Ol").append(" { ");
        this.generateOLContructors(otypeName, this.getOlGeneratedStrings((IJstMethod)type.getConstructor()));
        if (type.hasOptionalFields()) {
            for (IJstMethod overloaded : type.getConstructor().getOverloaded()) {
                this.generateOLContructors(otypeName, this.getOlGeneratedStrings(overloaded));
            }
        }
        writer.append("}");
    }

    private void generateOLContructors(String otypeName, ObjectLiteralGenStrings genStrings) {
        PrintWriter writer = this.getWriter();
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("private ").append(otypeName).append("(").append(genStrings.paramSig).append(") {");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("super(").append(genStrings.superSig).append(");");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.writeNewlineAndIndent();
        writer.append(genStrings.annoSig);
        this.writeNewlineAndIndent();
        writer.append(STATIC_PROP_MODIFIER).append(otypeName).append(" ").append("obj(").append(genStrings.paramSig).append(") {");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("return new ").append(otypeName).append("(").append(genStrings.newSig).append(");");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        this.outdent();
        this.writeNewlineAndIndent();
    }

    private void writeClassDefinition() {
        if (this.m_innerTypeInfo != null) {
            this.writeIndent();
        }
        PrintWriter writer = this.getWriter();
        if (this.m_clzType.isOType()) {
            writer.append("@").append("AIsOType");
            this.writeNewlineAndIndent();
        }
        writer.append(PROP_MODIFIER);
        if (this.m_clzType.isEmbededType() && this.m_clzType.getModifiers().isStatic()) {
            writer.append("static ");
        }
        if (this.m_clzType.isInterface()) {
            writer.append("interface ");
        } else if (this.m_clzType.isOType()) {
            writer.append("abstract class ");
        } else {
            if (this.m_clzType.getModifiers().isFinal()) {
                writer.append("final ");
            }
            if (this.m_clzType.getModifiers().isAbstract()) {
                writer.append("abstract ");
            }
            writer.append("class ");
        }
        writer.append(this.m_clzType.getSimpleName());
        if (!this.m_clzType.getParamNames().isEmpty()) {
            writer.append(((JstType)this.m_clzType).getParamsDecoration());
        }
        if (this.m_clzType.isInterface()) {
            List extendedTypes = this.m_clzType.getExtends();
            if (!extendedTypes.isEmpty()) {
                writer.append(" extends ");
                int i = 0;
                while (i < extendedTypes.size()) {
                    if (i > 0) {
                        writer.append(",").append(" ");
                    }
                    IJstType extType = (IJstType)extendedTypes.get(i);
                    writer.append(extType.getSimpleName());
                    if (extType instanceof JstTypeWithArgs) {
                        JstTypeWithArgs jstTypeWithArgs = (JstTypeWithArgs)extType;
                        if (!jstTypeWithArgs.getArgTypes().isEmpty()) {
                            writer.append(jstTypeWithArgs.getArgsDecoration());
                        }
                    } else if (!extType.getParamNames().isEmpty()) {
                        writer.append(((JstType)extType).getParamsDecoration());
                    }
                    ++i;
                }
            } else {
                writer.append(" extends ").append("IJsJavaProxy");
            }
        } else if (!this.m_clzType.isOType() && !this.m_clzType.isMixin()) {
            IJstType extend = this.m_clzType.getExtend();
            if (extend != null && !NativeJsProxyGenerator.isObject(extend) && !NativeJsProxyGenerator.isEnum(extend)) {
                writer.append(" extends ");
                writer.append(extend.getSimpleName());
                writer.append(GeneratorJstHelper.getArgsDecoration(extend));
            } else {
                writer.append(" extends ").append("NativeJsProxy");
            }
        }
        List interfaceTypes = this.m_clzType.getSatisfies();
        if (!interfaceTypes.isEmpty()) {
            boolean addComma = false;
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < interfaceTypes.size()) {
                IJstType itfType = (IJstType)interfaceTypes.get(i);
                if (addComma) {
                    buf.append(",").append(" ");
                }
                buf.append(itfType.getSimpleName());
                if (itfType instanceof JstTypeWithArgs) {
                    buf.append(GeneratorJstHelper.getArgsDecoration(itfType));
                }
                addComma = true;
                ++i;
            }
            if (buf.length() > 0) {
                writer.append(" implements ").append(buf.toString());
            }
        }
    }

    private void writeConstructors() {
        if (this.m_clzType.isInterface()) {
            return;
        }
        if (this.m_constructors.isEmpty()) {
            this.writeConstructor(this.m_clzType.getSimpleName(), "", "");
            return;
        }
        ArrayList<IJstMethod> writtenConstructors = new ArrayList<IJstMethod>();
        for (MethodMeta meta : this.m_constructors) {
            if (writtenConstructors.contains(meta.m_method)) continue;
            for (List<SimpleParam> paramList : meta.m_argListPermutation) {
                this.writeConstructorForNativeJsProxy(paramList);
            }
            writtenConstructors.add(meta.m_method);
        }
        writtenConstructors = null;
    }

    private void writeConstructorForNativeJsProxy(List<SimpleParam> paramList) {
        StringBuilder params = new StringBuilder();
        StringBuilder args = new StringBuilder();
        this.collectParamAndArgList(paramList, params, args);
        this.writeConstructor(this.m_clzType.getSimpleName(), params.toString(), args.toString());
    }

    private void writeConstants() {
        if (this.m_constants.isEmpty()) {
            return;
        }
        PrintWriter writer = this.getWriter();
        boolean isInterface = this.m_clzType.isInterface();
        for (IJstProperty property : this.m_constants) {
            this.writeNewline();
            this.writeNewlineAndIndent();
            if (!isInterface) {
                writer.append("public static final ");
            }
            String typeName = this.getTypeName(property.getType(), true);
            String typeNameWithArgs = this.getTypeName(property.getType());
            String constantName = property.getName().getName();
            writer.append(typeNameWithArgs).append(" ").append(constantName).append(" = ");
            if (this.m_clzType.isInterface()) {
                writer.append("NativeJsHelper").append(".");
                writer.append("getStaticProperty(");
                writer.append(this.m_clzType.getSimpleName()).append(".class, ");
                writer.append("\"").append(constantName).append("\", ").append(typeName).append(".class);");
                continue;
            }
            writer.append("getStaticProperty(");
            writer.append("\"").append(this.m_clzType.getName()).append("\", ");
            writer.append("\"").append(constantName).append("\", ").append(typeName).append(".class);");
        }
    }

    private void writeProperties(boolean isStatic) {
        String setter;
        List<IJstProperty> properties = isStatic ? this.m_staticProperties : this.m_instanceProperties;
        String modifier = isStatic ? STATIC_PROP_MODIFIER : PROP_MODIFIER;
        String getter = isStatic ? STATIC_PROP_GETTER : PROP_GETTER;
        String string = setter = isStatic ? STATIC_PROP_SETTER : PROP_SETTER;
        if (this.m_clzType.isInterface() || properties.isEmpty()) {
            return;
        }
        PrintWriter writer = this.getWriter();
        for (IJstProperty property : properties) {
            String typeName = this.getTypeName(property.getType());
            String propertyName = property.getName().getName();
            boolean needEscape = NativeJsProxyGenerator.needEscape(propertyName);
            boolean isTypeRef = property.getType() instanceof IJstRefType;
            this.writeNewline();
            this.writeNewlineAndIndent();
            writer.append("@").append("AProperty");
            if (needEscape) {
                writer.append("(name=\"").append(propertyName).append("\")");
            }
            if (isTypeRef) {
                this.writeNewlineAndIndent();
                writer.append("@SuppressWarnings(\"unchecked\")");
            }
            this.writeNewlineAndIndent();
            writer.append(modifier).append(typeName).append(" ").append(needEscape ? NativeJsProxyGenerator.escape(propertyName) : propertyName).append("() {");
            this.indent();
            this.writeNewlineAndIndent();
            writer.append(getter);
            if (isStatic) {
                writer.append("\"").append(this.m_clzType.getName()).append("\", ");
            }
            writer.append("\"").append(propertyName).append("\", ");
            if (isTypeRef) {
                writer.append("NativeJsTypeRef").append(".class);");
            } else {
                writer.append(NativeJsProxyGenerator.getClassName(typeName)).append(".class);");
            }
            this.outdent();
            this.writeNewlineAndIndent();
            writer.append("}");
            this.writeNewline();
            this.writeNewlineAndIndent();
            writer.append("@").append("AProperty");
            if (needEscape) {
                writer.append("(name=\"").append(propertyName).append("\")");
            }
            this.writeNewlineAndIndent();
            writer.append(modifier).append("void ").append(needEscape ? NativeJsProxyGenerator.escape(propertyName) : propertyName).append("(").append(typeName).append(" value) {");
            this.indent();
            this.writeNewlineAndIndent();
            writer.append(setter);
            if (isStatic) {
                writer.append("\"").append(this.m_clzType.getName()).append("\", ");
            }
            writer.append("\"").append(propertyName).append("\", ");
            writer.append("value);");
            this.outdent();
            this.writeNewlineAndIndent();
            writer.append("}");
        }
    }

    private void writeMethods(MethodMeta meta) {
        if (meta.m_method instanceof ISynthesized) {
            return;
        }
        for (List<SimpleParam> paramList : meta.m_argListPermutation) {
            this.writeMethod(meta.m_method, paramList);
        }
    }

    private void writeMethod(IJstMethod method, List<SimpleParam> paramList) {
        boolean isTypeRef;
        StringBuilder methodDeclBegin = new StringBuilder();
        if (!this.m_clzType.isInterface()) {
            methodDeclBegin.append(PROP_MODIFIER);
        }
        if (method.isAbstract()) {
            methodDeclBegin.append("abstract ");
        }
        if (method.isStatic()) {
            methodDeclBegin.append("static ");
        }
        if (method.isFinal()) {
            methodDeclBegin.append("final ");
        }
        if (!method.getParamNames().isEmpty()) {
            methodDeclBegin.append(method.getParamsDecoration()).append(" ");
        }
        IJstType rtnType = method.getRtnType();
        String rtnTypeName = "void";
        String rtnTypeWrapperName = null;
        boolean suppress = isTypeRef = method.getRtnType() instanceof IJstRefType;
        if (rtnType != null && !"void".equals(rtnType.getName())) {
            rtnTypeName = this.getTypeName(rtnType);
            if (isTypeRef) {
                rtnTypeName = "NativeJsTypeRef<" + rtnTypeName + ">";
                rtnTypeWrapperName = "NativeJsTypeRef";
            } else {
                String rtn = rtnTypeName;
                if (rtnType instanceof JstTypeWithArgs) {
                    suppress = true;
                    rtn = this.getTypeName(rtnType, true);
                }
                rtnTypeWrapperName = NativeJsProxyGenerator.getWrapperType(rtn, false);
            }
        }
        methodDeclBegin.append(rtnTypeName).append(" ");
        String methodName = method.getOriginalName();
        boolean escaped = false;
        if (NativeJsProxyGenerator.needEscape(methodName)) {
            escaped = true;
            methodDeclBegin.append(NativeJsProxyGenerator.escape(methodName));
        } else {
            methodDeclBegin.append(methodName);
        }
        StringBuilder params = new StringBuilder();
        StringBuilder args = new StringBuilder();
        this.collectParamAndArgList(paramList, params, args);
        this.writeMethod(methodDeclBegin.toString(), rtnTypeWrapperName, params.toString(), args.toString(), method.isStatic(), this.m_clzType.isInterface() || method.isAbstract(), suppress, escaped, methodName);
    }

    private void collectParamAndArgList(List<SimpleParam> paramList, StringBuilder params, StringBuilder args) {
        int argSize = paramList.size();
        int i = 0;
        while (i < argSize) {
            String pName;
            SimpleParam param = paramList.get(i);
            if (i > 0) {
                params.append(", ");
                args.append(", ");
            }
            String pType = this.getTypeName(param.m_type);
            params.append(pType);
            if (param.m_type instanceof JstFunctionRefType) {
                params.append("<? extends IJsJavaProxy>");
            }
            if (param.m_arg.isVariable()) {
                params.append("...");
            }
            if ((pName = param.m_arg.getName()) == null) {
                pName = DEFAULT_PARAM_PREFIX + i;
            }
            params.append(" ").append(pName);
            args.append(pName);
            ++i;
        }
    }

    private void writeFrameworkConstructors(String name) {
        if (this.m_clzType.isInterface()) {
            return;
        }
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeNewlineAndIndent();
        writer.append("/** for framework use only */");
        this.writeNewlineAndIndent();
        writer.append("@").append("AExclude");
        this.writeNewlineAndIndent();
        writer.append(PROP_MODIFIER).append(name).append("(").append("Scriptable").append(" nativeObj){");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("super(nativeObj);");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
        if (!this.hasVarArgConstructor()) {
            this.writeNewline();
            this.writeNewlineAndIndent();
            writer.append("/** internal use only */");
            this.writeNewlineAndIndent();
            writer.append("protected ").append(name).append("(Object ...args){");
            this.indent();
            this.writeNewlineAndIndent();
            writer.append("super(args);");
            this.outdent();
            this.writeNewlineAndIndent();
            writer.append("}");
        }
    }

    private boolean hasVarArgConstructor() {
        if (this.m_constructors.isEmpty()) {
            return false;
        }
        for (MethodMeta meta : this.m_constructors) {
            for (List<SimpleParam> paramList : meta.m_argListPermutation) {
                if (paramList.size() != 1) continue;
                SimpleParam param = paramList.get(0);
                JstArg arg = param.m_arg;
                if (!arg.isVariable() || !"Object".equals(arg.getType().getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void writeConstructor(String name, String paramList, String argList) {
        this.writeNewline();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        writer.append(PROP_MODIFIER).append(name).append("(").append(paramList).append(") {");
        this.indent();
        this.writeNewlineAndIndent();
        writer.append("super(").append(argList).append(");");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
    }

    private void writeMethod(String methodDecl, String returnTypeWrapper, String paramList, String argList, boolean isStatic, boolean isAbstruct, boolean addSuppress, boolean escaped, String methodName) {
        this.writeNewline();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        if (escaped) {
            writer.append("@").append("org.eclipse.vjet.dsf.javatojs.anno.ARename").append("(name=\"").append(methodName).append("\")");
            this.writeNewlineAndIndent();
        }
        if (addSuppress) {
            writer.append("@SuppressWarnings(\"unchecked\")");
            this.writeNewlineAndIndent();
        }
        writer.append(methodDecl).append("(").append(paramList).append(")");
        if (isAbstruct) {
            writer.append(";");
            return;
        }
        boolean returnsTemplateType = this.m_clzType.getParamNames().contains(returnTypeWrapper);
        writer.append(" {");
        this.indent();
        this.writeNewlineAndIndent();
        if (returnTypeWrapper != null) {
            writer.append("return ");
        }
        if (returnsTemplateType) {
            writer.append("(").append(returnTypeWrapper).append(")");
        }
        if (isStatic) {
            writer.append("callStaticWithName(").append("\"").append(this.m_clzType.getName()).append("\", ").append("\"").append(methodName).append("\"");
            if (returnTypeWrapper != null || argList != null && argList.length() != 0) {
                writer.append(", ");
            }
        } else {
            writer.append("callWithName(\"").append(methodName).append("\"");
            if (returnTypeWrapper != null || argList != null && argList.length() != 0) {
                writer.append(", ");
            }
        }
        if (returnTypeWrapper != null) {
            writer.append(returnsTemplateType ? "Object" : returnTypeWrapper).append(".class");
            if (argList != null && argList.length() != 0) {
                writer.append(", ");
            }
        }
        writer.append(argList).append(");");
        this.outdent();
        this.writeNewlineAndIndent();
        writer.append("}");
    }

    private void writeTypeRef() {
        if (this.m_innerTypeInfo != null && !this.m_clzType.getModifiers().isStatic()) {
            return;
        }
        this.writeNewline();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        writer.append("@").append("AJavaOnly");
        this.writeNewlineAndIndent();
        writer.append("public static final ").append("NativeJsTypeRef").append("<").append(this.m_clzType.getSimpleName()).append("> ").append("prototype = NativeJsTypeRef.get(").append(this.m_clzType.getSimpleName()).append(".class);");
    }

    private void writeStaticFuncProxy(MethodMeta meta, Set<String> methodNames) {
        String methodName;
        IJstMethod method = meta.m_method;
        if (method instanceof ISynthesized) {
            return;
        }
        String typeName = null;
        if (method.isOType()) {
            typeName = ((JstMethod)method).getOType().getName();
        }
        if (methodNames.contains(methodName = method.getName().getName())) {
            return;
        }
        if (method.isAbstract() || !method.isPublic()) {
            return;
        }
        StringBuilder nativeRef = new StringBuilder();
        nativeRef.append("<").append("NativeJsTypeRef").append("<").append(this.m_clzType.getSimpleName()).append(">").append(">");
        methodNames.add(methodName);
        this.writeNewline();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        writer.append("public static final ");
        if (typeName != null) {
            writer.append(typeName);
        } else {
            writer.append("INativeJsFuncProxy");
        }
        writer.append(nativeRef).append(" ").append(methodName).append(" = ");
        if (typeName != null) {
            writer.append("new ").append(typeName).append(nativeRef).append("(");
        }
        writer.append("NativeJsFuncProxy").append(".create(prototype, \"").append(methodName).append("\")");
        if (typeName != null) {
            writer.append(")");
        }
        writer.append(";");
    }

    private void writeInstanceFuncProxy(MethodMeta meta, Set<String> methodNames, String clzName) {
        IJstMethod method = meta.m_method;
        if (method instanceof JstProxyMethod) {
            method = ((JstProxyMethod)method).getTargetMethod();
        }
        String methodName = method.getName().getName();
        String typeName = null;
        if (method.isOType()) {
            typeName = String.valueOf(((JstMethod)method).getOType().getName()) + "<" + this.m_clzType.getSimpleName() + ">";
        }
        if (methodNames.contains(methodName)) {
            return;
        }
        if (method.isAbstract() || !method.isPublic()) {
            return;
        }
        StringBuilder nativeRef = new StringBuilder();
        nativeRef.append("<").append(typeName).append("<").append(this.m_clzType.getSimpleName()).append(">").append(">");
        methodNames.add(methodName);
        this.writeNewline();
        this.writeNewlineAndIndent();
        PrintWriter writer = this.getWriter();
        writer.append("public final ");
        if (typeName != null) {
            writer.append(typeName);
        } else {
            writer.append("INativeJsFuncProxy").append("<").append(clzName).append(">");
        }
        writer.append(" ").append(methodName).append(" = ");
        if (typeName != null) {
            writer.append("new ").append(typeName).append("(");
        }
        writer.append("NativeJsFuncProxy").append(".create(this, \"").append(methodName).append("\")");
        if (typeName != null) {
            writer.append(")");
        }
        writer.append(";");
    }

    private NativeJsProxyGenerator writeNewlineAndIndent() {
        super.writeNewline().writeIndent();
        return this;
    }

    private static boolean isDuplicate(List<List<SimpleParam>> existedLists, List<SimpleParam> theList) {
        for (List<SimpleParam> existedOne : existedLists) {
            if (existedOne.size() != theList.size()) continue;
            boolean isDuplicate = true;
            int i = 0;
            while (i < theList.size()) {
                if (theList.get(i) != existedOne.get(i)) {
                    isDuplicate = false;
                    break;
                }
                ++i;
            }
            if (!isDuplicate) continue;
            return true;
        }
        return false;
    }

    private void addCustomTypeImport(List<? extends IJstType> types) {
        if (types == null) {
            return;
        }
        for (IJstType iJstType : types) {
            this.addCustomTypeImport(iJstType);
        }
    }

    private void addCustomTypeImport(IJstType type) {
        if (this.m_currentDefinedTypes.contains(type.getName())) {
            return;
        }
        if (NativeJsProxyGenerator.isObject(type) || NativeJsProxyGenerator.isEnum(type) || NativeJsProxyGenerator.isVjoClass(type)) {
            return;
        }
        String name = type.getName();
        boolean usedFullName = this.m_clzType.getImportsMap().containsKey(name);
        if (name.startsWith(VJOX_JAVA_LANG)) {
            usedFullName = true;
        }
        this.m_customTypeMgr.add(name, type.getSimpleName(), usedFullName);
    }

    private void addTypeImport(Set<IJstType> typeSet) {
        for (IJstType type : typeSet) {
            String name;
            if (NativeJsProxyGenerator.isObject(type) || this.m_clzType.isOType() && this.m_clzType.equals(type.getParentNode()) || NativeJsProxyGenerator.isPrimitiveType(name = type.getName())) continue;
            if (NativeJsProxyGenerator.isJavaType(name)) {
                if (NativeJsProxyGenerator.isJavaLangType(name)) continue;
                if (name.startsWith(VJOX)) {
                    name = name.substring(4);
                }
                this.m_javaTypeMgr.add(name, type.getSimpleName(), false);
                continue;
            }
            Class clz = JsNativeMeta.getClass((String)name);
            if (clz != null) {
                String typeName = clz.getName();
                String simpleName = clz.getSimpleName();
                String proxyName = NativeJsProxyGenerator.getNativeProxyType(typeName);
                String javaForNative = DataTypeHelper.getJavaTypeNameForNative((String)typeName);
                if (javaForNative != null) {
                    if (NativeJsProxyGenerator.isJavaLangType(javaForNative)) continue;
                    this.m_javaTypeMgr.add(javaForNative, simpleName, false);
                    continue;
                }
                if (proxyName != null) {
                    typeName = proxyName;
                    simpleName = proxyName.substring(proxyName.lastIndexOf(".") + 1);
                    if (typeName == "org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy") {
                        simpleName = String.valueOf(simpleName) + "<?>";
                    }
                }
                this.m_jsNativeTypeMgr.add(typeName, simpleName, false);
                continue;
            }
            this.addCustomTypeImport(type);
        }
    }

    private void collectTypeFromProperties(List<IJstProperty> properties, Set<IJstType> typeSet, InnerTypeInfo innerTypeInfo) {
        IJstType type = innerTypeInfo == null ? this.m_clzType : innerTypeInfo.m_clzType;
        List constants = innerTypeInfo == null ? this.m_constants : innerTypeInfo.m_constants;
        List staticProperties = innerTypeInfo == null ? this.m_staticProperties : innerTypeInfo.m_staticProperties;
        List instanceProperties = innerTypeInfo == null ? this.m_instanceProperties : innerTypeInfo.m_instanceProperties;
        boolean isInterface = type.isInterface();
        for (IJstProperty prop : properties) {
            if (!prop.isPublic() || prop instanceof ISynthesized || prop instanceof JstProxyProperty && ((JstProxyProperty)prop).getTargetProperty() instanceof ISynthesized) continue;
            if (isInterface || prop.isFinal() && prop.isStatic()) {
                constants.add(prop);
            } else if (prop.isStatic()) {
                staticProperties.add(prop);
            } else {
                instanceProperties.add(prop);
            }
            if (prop.getType() instanceof IJstRefType) {
                this.m_hasJsTypeRef = true;
            }
            this.collectType(prop.getType(), typeSet);
        }
    }

    private void collectTypeFromMethod(IJstMethod method, Set<IJstType> typeSet, InnerTypeInfo innerTypeInfo) {
        List<Stack<SimpleParam>> paramsPermutation;
        IJstType returnType;
        if (method == null || !method.isPublic()) {
            return;
        }
        List metaList = null;
        if (method.isConstructor()) {
            metaList = innerTypeInfo == null ? this.m_constructors : innerTypeInfo.m_constructors;
        } else if (method.isStatic()) {
            metaList = innerTypeInfo == null ? this.m_staticMethods : innerTypeInfo.m_staticMethods;
        } else {
            List list = metaList = innerTypeInfo == null ? this.m_instanceMethods : innerTypeInfo.m_instanceMethods;
        }
        if (method.isDispatcher()) {
            List olmethods = method.getOverloaded();
            if (olmethods != null) {
                int indx = 0;
                for (IJstMethod mtd : olmethods) {
                    IJstType returnType2;
                    List args = mtd.getArgs();
                    List<Stack<SimpleParam>> olParamsPermutation = this.collectArgTypesAndPermutation(0, args, typeSet);
                    if (mtd.isPublic()) {
                        MethodMeta m = new MethodMeta(mtd, olParamsPermutation);
                        if (indx > 0) {
                            m.m_isOverload = true;
                        }
                        ++indx;
                        metaList.add(m);
                    }
                    if (method.isConstructor() || (returnType2 = mtd.getRtnType()) == null || !NativeJsProxyGenerator.isPublic(returnType2)) continue;
                    this.collectType(returnType2, typeSet);
                }
                if (!this.isDispatcher(method) && !NativeJsProxyGenerator.isExists(metaList, method)) {
                    List<Stack<SimpleParam>> paramsPermutation2 = this.collectArgTypesAndPermutation(0, method.getArgs(), typeSet);
                    if (method.isPublic()) {
                        MethodMeta methodMeta = new MethodMeta(method, paramsPermutation2);
                        metaList.add(methodMeta);
                    }
                }
            }
            return;
        }
        if (!method.isConstructor() && (returnType = method.getRtnType()) != null) {
            if (!NativeJsProxyGenerator.isPublic(returnType)) {
                return;
            }
            this.collectType(returnType, typeSet);
        }
        if ((paramsPermutation = this.collectArgTypesAndPermutation(0, method.getArgs(), typeSet)) == null) {
            return;
        }
        MethodMeta methodMeta = new MethodMeta(method, paramsPermutation);
        metaList.add(methodMeta);
    }

    private boolean isDispatcher(IJstMethod method) {
        if (!method.isDispatcher()) {
            return false;
        }
        if (method.getOverloaded().size() > 1) {
            return true;
        }
        JstMethod mtd = (JstMethod)method.getOverloaded().get(0);
        return mtd.getSurffix() == null;
    }

    /*
     * WARNING - void declaration
     */
    private List<Stack<SimpleParam>> collectArgTypesAndPermutation(int index, List<JstArg> args, Set<IJstType> typeSet) {
        ArrayList<Stack<SimpleParam>> paramStackPermutation = new ArrayList<Stack<SimpleParam>>();
        if (index == args.size()) {
            paramStackPermutation.add(EMPTY_STACK);
            return paramStackPermutation;
        }
        JstArg arg = args.get(index);
        List argTypes = arg.getTypes();
        boolean isTypeRef = arg.getType() instanceof IJstRefType;
        if (index == args.size() - 1) {
            for (IJstType argType : argTypes) {
                if (!NativeJsProxyGenerator.isPublic(argType)) {
                    return null;
                }
                this.collectType(argType, typeSet);
                Stack<SimpleParam> paramStack = new Stack<SimpleParam>();
                paramStack.push(new SimpleParam(arg, argType, arg.isOptional(), isTypeRef));
                paramStackPermutation.add(paramStack);
            }
        } else {
            List<Stack<SimpleParam>> tList = this.collectArgTypesAndPermutation(index + 1, args, typeSet);
            if (tList == null) {
                return null;
            }
            int size = argTypes.size();
            int i = 0;
            while (i < size) {
                IJstType argType = (IJstType)argTypes.get(i);
                if (!NativeJsProxyGenerator.isPublic(argType)) {
                    return null;
                }
                this.collectType(argType, typeSet);
                SimpleParam param = new SimpleParam(arg, argType, arg.isOptional(), isTypeRef);
                for (Stack<SimpleParam> stack : tList) {
                    void var13_16;
                    if (i != size - 1) {
                        Stack stack2 = (Stack)stack.clone();
                    }
                    var13_16.push(param);
                    paramStackPermutation.add((Stack<SimpleParam>)var13_16);
                }
                ++i;
            }
        }
        return paramStackPermutation;
    }

    private void collectType(IJstType type, Set<IJstType> typeSet) {
        if (type instanceof IJstRefType) {
            this.m_hasJsTypeRef = true;
            IJstRefType refType = (IJstRefType)type;
            typeSet.add(refType.getReferencedNode());
            this.addCustomTypeImport(refType.getReferencedNode());
            return;
        }
        if (typeSet.contains(type)) {
            return;
        }
        if (type instanceof JstArray) {
            type = ((JstArray)type).getElementType();
        }
        if (!type.getModifiers().isPublic()) {
            return;
        }
        typeSet.add(type);
        if (type instanceof JstTypeWithArgs) {
            JstTypeWithArgs jstTypeWArgs = (JstTypeWithArgs)type;
            for (IJstType argType : jstTypeWArgs.getArgTypes()) {
                this.collectType(argType, typeSet);
            }
        }
    }

    private static boolean isPublic(IJstType type) {
        if (type instanceof JstArray) {
            type = ((JstArray)type).getElementType();
        }
        if (type instanceof JstParamType) {
            return true;
        }
        return type.getModifiers().isPublic();
    }

    private static boolean isExists(List<MethodMeta> list, IJstMethod method) {
        for (MethodMeta meta : list) {
            if (!NativeJsProxyGenerator.isEqual(meta.m_method, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqual(IJstMethod source, IJstMethod target) {
        if (source == target) {
            return true;
        }
        if (!source.getOriginalName().equals(target.getOriginalName())) {
            return false;
        }
        List sourceArgs = source.getArgs();
        List targetArgs = target.getArgs();
        int sourceArgsCount = sourceArgs.size();
        int targetArgsCount = targetArgs.size();
        if (sourceArgsCount == 0 && targetArgsCount == 0) {
            return true;
        }
        if (sourceArgsCount == targetArgsCount) {
            int i = 0;
            while (i < sourceArgsCount) {
                if (!((JstArg)sourceArgs.get(i)).equals(targetArgs.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private String getTypeName(IJstType type) {
        return this.getTypeName(type, false);
    }

    private String getTypeRefType(String type, boolean noArgs) {
        return "NativeJsTypeRef" + (noArgs ? "" : "<" + type + ">");
    }

    private String getTypeName(IJstType type, boolean noArgs) {
        if (type == null) {
            return null;
        }
        if (type == this.m_clzType) {
            return type.getSimpleName();
        }
        if (type instanceof JstArray) {
            return String.valueOf(this.getTypeName(((JstArray)type).getComponentType())) + "[]";
        }
        String name = type.getName();
        String sname = type.getSimpleName();
        if (type instanceof IJstRefType) {
            IJstType target = ((IJstRefType)type).getReferencedNode();
            name = target.getName();
            sname = target.getSimpleName();
            return this.getTypeRefType(sname, noArgs);
        }
        if ("void".equals(name)) {
            return name;
        }
        if (NativeJsProxyGenerator.isObject(sname) || NativeJsProxyGenerator.isEnum(name)) {
            return "Object";
        }
        if (NativeJsProxyGenerator.isVjoClass(name)) {
            return "Class";
        }
        TypeMeta meta = null;
        if (NativeJsProxyGenerator.isJavaType(name)) {
            if (name.startsWith(VJOX)) {
                name = name.substring(4);
            }
            if ((meta = this.m_javaTypeMgr.get(name)) == null && NativeJsProxyGenerator.isJavaLangType(name)) {
                return type.getSimpleName();
            }
        } else {
            Class clz = JsNativeMeta.getClass((String)name);
            if (clz != null) {
                String typeName = clz.getName();
                String proxyName = NativeJsProxyGenerator.getNativeProxyType(typeName);
                if (proxyName != null) {
                    typeName = proxyName;
                }
                meta = this.m_jsNativeTypeMgr.get(typeName);
            }
            if (meta == null) {
                meta = this.m_customTypeMgr.get(name);
            }
        }
        if (meta != null) {
            name = meta.m_useFullName ? meta.m_fullName : meta.m_simpleName;
        } else if (type instanceof JstProxyType && ((JstProxyType)type).getType() == this.m_clzType) {
            name = this.m_clzType.getSimpleName();
        }
        if (type instanceof JstTypeWithArgs && !noArgs) {
            name = String.valueOf(name) + this.getArgsDecoration((JstTypeWithArgs)type);
        }
        return name;
    }

    private String getArgsDecoration(JstTypeWithArgs templatedType) {
        StringBuilder sb = new StringBuilder("<");
        int i = 0;
        for (IJstType p : templatedType.getArgTypes()) {
            if (i++ > 0) {
                sb.append(",");
            }
            if (p instanceof JstWildcardType) {
                sb.append("?");
                if ("?".equals(p.getSimpleName())) continue;
                if (((JstWildcardType)p).isUpperBound()) {
                    sb.append(" extends ").append(this.getTypeName(p));
                    continue;
                }
                if (!((JstWildcardType)p).isLowerBound()) continue;
                sb.append(" super ").append(this.getTypeName(p));
                continue;
            }
            sb.append(this.getTypeName(p));
        }
        sb.append(">");
        return sb.toString();
    }

    private static String getWrapperType(String typeName, boolean useFullName) {
        String wrapper = null;
        wrapper = useFullName ? s_javaWrapperTypeFullNames.get(typeName) : s_javaWrapperTypes.get(typeName);
        if (wrapper != null) {
            return wrapper;
        }
        return typeName;
    }

    private static boolean isPrimitiveType(String typeName) {
        return s_primitiveTypes.contains(typeName);
    }

    private static boolean needEscape(String name) {
        return s_reservedName.contains(name);
    }

    private static String escape(String name) {
        return String.valueOf(name) + "__";
    }

    private static String getClassName(String name) {
        int idx = 0;
        idx = name.indexOf("<");
        if (idx != -1) {
            return name.substring(0, idx).trim();
        }
        return name;
    }

    private static boolean isJavaType(String typeName) {
        return typeName.startsWith("java.") || typeName.startsWith(VJOX_JAVA);
    }

    private static boolean isJavaLangType(String typeName) {
        return typeName.startsWith("java.lang.") || typeName.startsWith(VJOX_JAVA);
    }

    private static boolean isObject(IJstType type) {
        return NativeJsProxyGenerator.isObject(type.getSimpleName());
    }

    private static boolean isObject(String typeName) {
        return "Object".equals(typeName) || "JsObj".equals(typeName);
    }

    private static boolean isVjoClass(IJstType type) {
        return NativeJsProxyGenerator.isVjoClass(type.getName());
    }

    private static boolean isVjoClass(String typeName) {
        return "vjo.Class".equals(typeName);
    }

    private static boolean isEnum(IJstType type) {
        return NativeJsProxyGenerator.isEnum(type.getName());
    }

    private static boolean isEnum(String typeName) {
        return "vjo.Enum".equals(typeName);
    }

    private static String getNativeProxyType(String nativeType) {
        return s_nativeToProxyMapping.get(nativeType);
    }

    private static boolean hasNonAbstractMethod(List<MethodMeta> methods) {
        if (methods.isEmpty()) {
            return false;
        }
        for (MethodMeta meta : methods) {
            if (meta.m_method.isAbstract()) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonAbstractMethod() {
        if (NativeJsProxyGenerator.hasNonAbstractMethod(this.m_staticMethods) || NativeJsProxyGenerator.hasNonAbstractMethod(this.m_instanceMethods)) {
            return true;
        }
        if (this.m_innerTypeInfoMap == null) {
            return false;
        }
        for (InnerTypeInfo info : this.m_innerTypeInfoMap.values()) {
            if (!info.m_clzType.isClass() || !NativeJsProxyGenerator.hasNonAbstractMethod(info.m_staticMethods) && !NativeJsProxyGenerator.hasNonAbstractMethod(info.m_instanceMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean hasProperty() {
        if (!this.m_staticProperties.isEmpty() || !this.m_instanceProperties.isEmpty()) {
            return true;
        }
        if (this.m_innerTypeInfoMap == null) {
            return false;
        }
        for (InnerTypeInfo info : this.m_innerTypeInfoMap.values()) {
            if (info.m_staticProperties.isEmpty() && info.m_instanceProperties.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasConstantInInterface() {
        if (this.m_clzType.isInterface() && !this.m_constants.isEmpty()) {
            return true;
        }
        if (this.m_innerTypeInfoMap == null) {
            return false;
        }
        for (Map.Entry<IJstType, InnerTypeInfo> entry : this.m_innerTypeInfoMap.entrySet()) {
            if (!entry.getKey().isInterface() || entry.getValue().m_constants.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static class InnerTypeInfo {
        private IJstType m_clzType = null;
        private TypeMetaMgr m_javaTypeMgr = null;
        private TypeMetaMgr m_customTypeMgr = null;
        private TypeMetaMgr m_jsNativeTypeMgr = null;
        private List<MethodMeta> m_constructors = new ArrayList<MethodMeta>();
        private List<MethodMeta> m_staticMethods = new ArrayList<MethodMeta>();
        private List<MethodMeta> m_instanceMethods = new ArrayList<MethodMeta>();
        private List<IJstProperty> m_constants = new ArrayList<IJstProperty>();
        private List<IJstProperty> m_staticProperties = new ArrayList<IJstProperty>();
        private List<IJstProperty> m_instanceProperties = new ArrayList<IJstProperty>();
        private Set<String> m_currentDefinedTypes = null;
        private Map<IJstType, InnerTypeInfo> m_innerTypeInfoMap = null;

        InnerTypeInfo(IJstType clzType, TypeMetaMgr javaTypeMgr, TypeMetaMgr customTypeMgr, TypeMetaMgr jsNativeTypeMgr, Set<String> currentDefinedTypes, Map<IJstType, InnerTypeInfo> innerTypeInfoMap) {
            this.m_clzType = clzType;
            this.m_javaTypeMgr = javaTypeMgr;
            this.m_customTypeMgr = customTypeMgr;
            this.m_jsNativeTypeMgr = jsNativeTypeMgr;
            this.m_currentDefinedTypes = currentDefinedTypes;
            this.m_innerTypeInfoMap = innerTypeInfoMap;
            this.m_innerTypeInfoMap.put(clzType, this);
        }
    }

    private static class MethodMeta {
        IJstMethod m_method;
        List<List<SimpleParam>> m_argListPermutation;
        boolean m_isOverload;

        MethodMeta(IJstMethod method, List<Stack<SimpleParam>> params) {
            this.m_method = method;
            this.m_argListPermutation = new ArrayList<List<SimpleParam>>(params.size());
            for (Stack<SimpleParam> paramStack : params) {
                ArrayList<SimpleParam> argList = new ArrayList<SimpleParam>(paramStack.size());
                this.m_argListPermutation.add(argList);
                while (!paramStack.isEmpty()) {
                    argList.add(paramStack.pop());
                }
            }
            method.getArgs();
        }
    }

    private static class ObjectLiteralGenStrings {
        StringBuilder paramSig = new StringBuilder();
        StringBuilder superSig = new StringBuilder();
        StringBuilder newSig = new StringBuilder();
        StringBuilder annoSig = new StringBuilder();

        private ObjectLiteralGenStrings() {
        }
    }

    private static class SimpleParam {
        JstArg m_arg;
        IJstType m_type;
        boolean m_isOptional = false;

        SimpleParam(JstArg arg, IJstType type, boolean isOptional, boolean isTypeRef) {
            this.m_arg = arg;
            this.m_type = type;
            this.m_isOptional = isOptional;
        }

        public String toString() {
            return String.valueOf(this.m_type.getName()) + (this.m_isOptional ? "?" : "") + " " + this.m_arg.getName();
        }
    }

    private static class TypeMeta {
        String m_fullName;
        String m_simpleName;
        boolean m_useFullName = false;

        TypeMeta(String fullName, String simpleName, boolean usedFullName) {
            this.m_fullName = fullName;
            this.m_simpleName = simpleName;
            if (usedFullName || simpleName.equals(fullName)) {
                this.m_useFullName = true;
            }
        }
    }

    private static class TypeMetaMgr {
        private Map<String, TypeMeta> m_fullNameMap = new LinkedHashMap<String, TypeMeta>();
        private Set<String> m_simpleNames = null;

        TypeMetaMgr(Set<String> simpleNames) {
            this.m_simpleNames = simpleNames;
        }

        TypeMeta get(String fullName) {
            return this.m_fullNameMap.get(fullName);
        }

        void add(String fullName, String simpleName, boolean usedFullName) {
            if (!this.m_fullNameMap.containsKey(fullName)) {
                TypeMeta meta = new TypeMeta(fullName, simpleName, usedFullName);
                this.add(meta);
            }
        }

        private void add(TypeMeta type) {
            if (this.m_simpleNames.contains(type.m_simpleName)) {
                type.m_useFullName = true;
            } else {
                this.m_simpleNames.add(type.m_simpleName);
            }
            this.m_fullNameMap.put(type.m_fullName, type);
        }

        void addToSimpleNameMap(TypeMeta type) {
            this.m_simpleNames.add(type.m_simpleName);
        }

        Iterator<TypeMeta> getMetaItr() {
            return this.m_fullNameMap.values().iterator();
        }
    }
}

