/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.generate;

import java.io.PrintWriter;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.generate.Indenter;

public class SourceGenerator {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String SPACE = " ";
    public static final String COLON = ":";
    public static final String SEMI_COLON = ";";
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public static final String QUESTION_MARK = "?";
    public static final String EQUAL = "=";
    public static final String OPEN_BRACKET = "[";
    public static final String CLOSE_BRACKET = "]";
    public static final String OPEN_PARENTHESIS = "(";
    public static final String CLOSE_PARENTHESIS = ")";
    public static final String OPEN_ANGLE_BRACKET = "<";
    public static final String CLOSE_ANGLE_BRACKET = ">";
    private CodeStyle m_style;
    private PrintWriter m_writer;
    private final Indenter m_indenter;
    private String m_newline = NEWLINE;

    public SourceGenerator(PrintWriter writer, Indenter indenter, CodeStyle style) {
        if (writer == null) {
            throw new RuntimeException("writer is null");
        }
        this.m_writer = writer;
        this.m_style = style;
        this.m_indenter = indenter;
    }

    public void setStyle(CodeStyle style) {
        this.m_style = style;
    }

    public CodeStyle getStyle() {
        return this.m_style;
    }

    public void setNewline(String newline) {
        this.m_newline = newline;
    }

    public String getNewline() {
        return this.m_newline;
    }

    public SourceGenerator indent() {
        this.m_indenter.indent();
        return this;
    }

    public SourceGenerator outdent() {
        this.m_indenter.outdent();
        return this;
    }

    public SourceGenerator writeIndent() {
        this.m_indenter.writeIndent();
        return this;
    }

    public SourceGenerator writeNewline() {
        if (this.m_style == CodeStyle.PRETTY) {
            this.m_writer.append(this.m_newline);
        }
        return this;
    }

    public SourceGenerator forceNewline() {
        this.m_writer.append(this.m_newline);
        return this;
    }

    public String toString() {
        return this.m_writer.toString();
    }

    protected PrintWriter getWriter() {
        return this.m_writer;
    }

    protected Indenter getIndenter() {
        return this.m_indenter;
    }

    protected void writeCodeGenMarker(Class<? extends SourceGenerator> generator) {
        this.m_writer.append("@").append("org.eclipse.vjet.dsf.resource.utils.CodeGen").append("(\"").append(generator.getSimpleName()).append("\")");
    }
}

