/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.jstvalidator;

import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jsgen.shared.jstvalidator.ValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.IJstValidationRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.IJstValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.ScopeId;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstProblemId;
import org.eclipse.vjet.dsf.jst.ProblemSeverity;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;

public class DefaultJstValidationVisitor
implements IJstVisitor {
    private final IJstValidator m_validator;
    private final ValidationCtx m_ctx;

    public DefaultJstValidationVisitor(ValidationCtx ctx, IJstValidator v) {
        this.m_validator = v;
        this.m_ctx = ctx;
    }

    public void endVisit(IJstNode node) {
    }

    public void postVisit(IJstNode node) {
    }

    public void preVisit(IJstNode node) {
    }

    public void preVisit(IJstType type) {
    }

    public boolean visit(IJstNode node) {
        for (IJstValidationRule r : this.getValidator().getRules()) {
            if (!this.inScope(r.getSpec().getScopeId()) || !this.isAcceptedProblem(r.getSpec().getProblemIds())) continue;
            this.getCtx().setNode(node);
            r.validate(this.getCtx());
        }
        return true;
    }

    private boolean isAcceptedProblem(List<JstProblemId> problemIds) {
        for (JstProblemId id : problemIds) {
            if (!this.getValidator().getValidationPolicy().getProblemSeverity(id).equals((Object)ProblemSeverity.ignore)) continue;
            return false;
        }
        return true;
    }

    private boolean inScope(List<ScopeId> scopeId) {
        if (this.getCtx().getScope().equals((Object)ScopeIds.ALL)) {
            return true;
        }
        for (ScopeId s : scopeId) {
            if (!s.equals((Object)this.getCtx().getScope())) continue;
            return true;
        }
        return false;
    }

    private IJstValidator getValidator() {
        return this.m_validator;
    }

    private ValidationCtx getCtx() {
        return this.m_ctx;
    }
}

