/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.AccessControlUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class VjoFieldAccessExprValidator
extends VjoSemanticValidator
implements IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();

    static {
        s_targetTypes.add(FieldAccessExpr.class);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof FieldAccessExpr)) {
            return;
        }
        VjoValidationCtx ctx = event.getValidationCtx();
        FieldAccessExpr expr = (FieldAccessExpr)jstNode;
        IExpr qualifier = expr.getExpr();
        IJstType qualifierType = qualifier.getResultType();
        if (qualifierType == null) {
            return;
        }
        JstIdentifier id = expr.getName();
        IJstType fieldType = id.getResultType();
        String fieldName = id.getName();
        VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
        if (fieldType == null) {
            if (!("Object".equals(qualifierType.getName()) || "ERROR_UNDEFINED_TYPE".equals(qualifierType.getName()) || this.isDynamicType(qualifierType))) {
                if (qualifierType instanceof IJstRefType) {
                    Pattern regexGroupRefPtn;
                    Matcher regexGroupRefMch;
                    if (qualifierType.getProperty(fieldName, false, true) != null) {
                        this.satisfyRule(ctx, ruleRepo.NONE_STATIC_PROPERTY_SHOULD_NOT_BE_ACCESSED_FROM_STATIC_SCOPE, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{fieldName, expr.toExprText()}));
                        return;
                    }
                    if (qualifierType.getMethod(fieldName, false, true) != null) {
                        this.satisfyRule(ctx, ruleRepo.NONE_STATIC_PROPERTY_SHOULD_NOT_BE_ACCESSED_FROM_STATIC_SCOPE, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{fieldName, expr.toExprText()}));
                        return;
                    }
                    if ("RegExp".equals(((IJstRefType)qualifierType).getReferencedNode().getSimpleName()) && "JsNativeLib".equals(qualifierType.getPackage().getGroupName()) && (regexGroupRefMch = (regexGroupRefPtn = Pattern.compile("\\$[0-9]+")).matcher(fieldName)).matches()) {
                        return;
                    }
                } else {
                    if (qualifierType.getProperty(fieldName, true, true) != null) {
                        this.satisfyRule(ctx, ruleRepo.STATIC_PROPERTY_SHOULD_NOT_BE_ACCESSED_FROM_NONE_STATIC_SCOPE, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{fieldName, expr.toExprText()}));
                        return;
                    }
                    if (qualifierType.getMethod(fieldName, true, true) != null) {
                        this.satisfyRule(ctx, ruleRepo.STATIC_PROPERTY_SHOULD_NOT_BE_ACCESSED_FROM_NONE_STATIC_SCOPE, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{fieldName, expr.toExprText()}));
                        return;
                    }
                }
                if ("prototype".equals(fieldName)) {
                    return;
                }
                if (qualifierType instanceof JstObjectLiteralType && "ObjLiteral".equals(qualifierType.getSimpleName())) {
                    return;
                }
                if (qualifierType instanceof IInferred) {
                    return;
                }
                if (!ctx.getMissingImportTypes().contains(qualifierType)) {
                    String missingTypeName;
                    if (expr.getParentNode() != null && expr.getParentNode() instanceof PrefixExpr && PrefixExpr.Operator.TYPEOF.equals(((PrefixExpr)expr.getParentNode()).getOperator())) {
                        return;
                    }
                    if ("Vj$Type".equals(qualifierType.getSimpleName()) && (missingTypeName = id.getName()) != null) {
                        for (IJstType missingType : ctx.getMissingImportTypes()) {
                            if (!missingTypeName.equals(missingType.getName())) continue;
                            return;
                        }
                    }
                    this.satisfyRule(ctx, ruleRepo.PROPERTY_SHOULD_BE_DEFINED, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{fieldName, expr.toExprText()}));
                }
            }
            return;
        }
        IJstNode fieldBinding = id.getJstBinding();
        if (fieldBinding != null && fieldBinding instanceof JstProperty) {
            JstType callerType;
            JstProperty property = (JstProperty)fieldBinding;
            IJstType fieldOwnerType = qualifierType instanceof IJstRefType ? ((IJstRefType)qualifierType).getReferencedNode() : qualifierType;
            boolean visible = AccessControlUtil.isVisible((IJstProperty)property, fieldOwnerType, (IJstType)(callerType = expr.getOwnerType()));
            if (!visible) {
                this.satisfyRule(ctx, ruleRepo.PROPERTY_SHOULD_BE_VISIBLE, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{fieldName, expr.toExprText()}));
                return;
            }
            ctx.getPropertyStatesTable().reference((IJstProperty)property);
        } else if (fieldBinding != null && fieldBinding instanceof JstMethod && !(fieldBinding instanceof JstConstructor)) {
            JstType callerType;
            JstMethod method = (JstMethod)fieldBinding;
            IJstType fieldOwnerType = qualifierType instanceof IJstRefType ? ((IJstRefType)qualifierType).getReferencedNode() : qualifierType;
            boolean visible = AccessControlUtil.isVisible((IJstMethod)method, fieldOwnerType, (IJstType)(callerType = expr.getOwnerType()));
            if (!visible) {
                this.satisfyRule(ctx, ruleRepo.PROPERTY_SHOULD_BE_VISIBLE, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{fieldName, expr.toExprText()}));
                return;
            }
            ctx.getMethodInvocationTable().reference((IJstMethod)method);
        }
    }

    private boolean isDynamicType(IJstType qualifierType) {
        if (qualifierType instanceof JstMixedType) {
            JstMixedType mt = (JstMixedType)qualifierType;
            for (IJstType t : mt.getMixedTypes()) {
                if (!t.getModifiers().isDynamic()) continue;
                return true;
            }
        }
        return qualifierType.getModifiers().isDynamic();
    }
}

