/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoDependencyVerifiable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.TypeNameShouldNotBeEmptyRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostChildListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.term.ArrayLiteral;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class VjoJstBlockValidator
extends VjoSemanticValidator
implements IVjoValidationPostChildListener,
IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();
    private static Map<VjoUniqueMethodEnum, Set<VjoUniqueMethodEnum>> type2mtdMap;

    static {
        s_targetTypes.add(JstBlock.class);
        type2mtdMap = new HashMap<VjoUniqueMethodEnum, Set<VjoUniqueMethodEnum>>();
        HashSet<VjoUniqueMethodEnum> cTypeSet = new HashSet<VjoUniqueMethodEnum>();
        cTypeSet.add(VjoUniqueMethodEnum.needs);
        cTypeSet.add(VjoUniqueMethodEnum.inherits);
        cTypeSet.add(VjoUniqueMethodEnum.satisfies);
        cTypeSet.add(VjoUniqueMethodEnum.mixin);
        cTypeSet.add(VjoUniqueMethodEnum.props);
        cTypeSet.add(VjoUniqueMethodEnum.protos);
        cTypeSet.add(VjoUniqueMethodEnum.endType);
        type2mtdMap.put(VjoUniqueMethodEnum.ctype, cTypeSet);
        type2mtdMap.put(VjoUniqueMethodEnum.make, cTypeSet);
        HashSet<VjoUniqueMethodEnum> iTypeSet = new HashSet<VjoUniqueMethodEnum>();
        iTypeSet.add(VjoUniqueMethodEnum.needs);
        iTypeSet.add(VjoUniqueMethodEnum.inherits);
        iTypeSet.add(VjoUniqueMethodEnum.props);
        iTypeSet.add(VjoUniqueMethodEnum.protos);
        iTypeSet.add(VjoUniqueMethodEnum.endType);
        type2mtdMap.put(VjoUniqueMethodEnum.itype, iTypeSet);
        HashSet<VjoUniqueMethodEnum> eTypeSet = new HashSet<VjoUniqueMethodEnum>();
        eTypeSet.add(VjoUniqueMethodEnum.needs);
        eTypeSet.add(VjoUniqueMethodEnum.satisfies);
        eTypeSet.add(VjoUniqueMethodEnum.values);
        eTypeSet.add(VjoUniqueMethodEnum.props);
        eTypeSet.add(VjoUniqueMethodEnum.protos);
        eTypeSet.add(VjoUniqueMethodEnum.endType);
        type2mtdMap.put(VjoUniqueMethodEnum.etype, eTypeSet);
        HashSet<VjoUniqueMethodEnum> mTypeSet = new HashSet<VjoUniqueMethodEnum>();
        mTypeSet.add(VjoUniqueMethodEnum.needs);
        mTypeSet.add(VjoUniqueMethodEnum.satisfies);
        mTypeSet.add(VjoUniqueMethodEnum.expects);
        mTypeSet.add(VjoUniqueMethodEnum.props);
        mTypeSet.add(VjoUniqueMethodEnum.protos);
        mTypeSet.add(VjoUniqueMethodEnum.endType);
        type2mtdMap.put(VjoUniqueMethodEnum.mtype, mTypeSet);
        HashSet<VjoUniqueMethodEnum> oTypeSet = new HashSet<VjoUniqueMethodEnum>();
        oTypeSet.add(VjoUniqueMethodEnum.defs);
        oTypeSet.add(VjoUniqueMethodEnum.endType);
        type2mtdMap.put(VjoUniqueMethodEnum.otype, oTypeSet);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPostChildEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        IJstNode child = event.getVisitChildNode();
        if (!(jstNode instanceof JstBlock)) {
            return;
        }
        JstBlock jstBlock = (JstBlock)jstNode;
        if (jstBlock.getParentNode() != null && jstBlock.getParentNode() instanceof SwitchStmt) {
            return;
        }
        JstMethod method = this.lookUpMethod(jstNode);
        if (method != null) {
            if (ctx.getMethodControlFlowTable().hasBlockUnreachableValidated(jstBlock)) {
                return;
            }
            List<IStmt> rtnStmts = ctx.getMethodControlFlowTable().lookUpStmt((IJstMethod)method, false);
            boolean rtnFlowCompleted = false;
            for (IStmt rtnStmt : rtnStmts) {
                if (rtnStmt != null) {
                    rtnFlowCompleted = true;
                    continue;
                }
                rtnFlowCompleted = false;
                break;
            }
            if (rtnFlowCompleted) {
                boolean unreachable = false;
                ctx.getMethodControlFlowTable().setBlockUnreachableValidated(jstBlock, true);
                for (IStmt stmt : jstBlock.getStmts()) {
                    if (unreachable) {
                        BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)stmt, ctx.getGroupId(), new String[]{method.getName().getName(), stmt.toStmtText()});
                        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().STMT_SHOULD_BE_REACHABLE, ruleCtx);
                    }
                    if (child != stmt) continue;
                    unreachable = true;
                }
            }
        }
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof JstBlock)) {
            return;
        }
        JstBlock jstBlock = (JstBlock)jstNode;
        if (jstBlock.getParentNode() != null) {
            return;
        }
        for (IJstNode stmt : jstBlock.getChildren()) {
            VjoJstBlockValidator.isSyntaxCorrect(this, ctx, stmt);
        }
    }

    public static boolean isSyntaxCorrect(VjoSemanticValidator validator, VjoValidationCtx ctx, IJstNode rootStmt) {
        IJstType syntaxOwnerType = ctx.getScope().getClosestTypeScopeNode();
        if (!(rootStmt instanceof MtdInvocationExpr)) {
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx(rootStmt, ctx.getGroupId(), new String[]{rootStmt.toString(), rootStmt.toString()});
            validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().VJO_SYNTAX_CORRECTNESS, ruleCtx);
            return false;
        }
        MtdInvocationExpr mtdExpr = (MtdInvocationExpr)rootStmt;
        HashMap<VjoUniqueMethodEnum, Integer> mtdCountMap = new HashMap<VjoUniqueMethodEnum, Integer>();
        VjoUniqueMethodEnum[] vjoUniqueMethodEnumArray = VjoUniqueMethodEnum.values();
        int n = vjoUniqueMethodEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            VjoUniqueMethodEnum enumValue = vjoUniqueMethodEnumArray[n2];
            mtdCountMap.put(enumValue, 0);
            ++n2;
        }
        HashMap<String, SimpleLiteral> nameSpace = new HashMap<String, SimpleLiteral>();
        SimpleLiteral typeLiteral = new SimpleLiteral(String.class, syntaxOwnerType, syntaxOwnerType.getName());
        typeLiteral.setSource(syntaxOwnerType.getSource());
        nameSpace.put(VjoJstBlockValidator.getSimpleName(syntaxOwnerType.getName(), null), typeLiteral);
        if (!VjoJstBlockValidator.isInactiveNeedsValid(syntaxOwnerType, ctx, validator)) {
            return false;
        }
        boolean correct = VjoJstBlockValidator.isSyntaxCorrect(validator, ctx, mtdExpr, mtdCountMap, nameSpace);
        if (correct && (Integer)mtdCountMap.get((Object)VjoUniqueMethodEnum.endType) <= 0 && ((Integer)mtdCountMap.get((Object)VjoUniqueMethodEnum.ctype) > 0 || (Integer)mtdCountMap.get((Object)VjoUniqueMethodEnum.make) > 0 || (Integer)mtdCountMap.get((Object)VjoUniqueMethodEnum.itype) > 0 || (Integer)mtdCountMap.get((Object)VjoUniqueMethodEnum.etype) > 0 || (Integer)mtdCountMap.get((Object)VjoUniqueMethodEnum.mtype) > 0 || (Integer)mtdCountMap.get((Object)VjoUniqueMethodEnum.otype) > 0)) {
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx(rootStmt, ctx.getGroupId(), new String[]{syntaxOwnerType.getName(), rootStmt.toString()});
            validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().MISSING_ENDTYPE, ruleCtx);
            correct = false;
        }
        return correct;
    }

    private static boolean isInactiveNeedsValid(IJstType syntaxOwnerType, VjoValidationCtx ctx, VjoSemanticValidator validator) {
        List lists = syntaxOwnerType.getInactiveImports();
        if (syntaxOwnerType instanceof JstType && lists.size() > 0) {
            String typeName = null;
            for (IJstType jstType : lists) {
                typeName = jstType.getName();
                if (jstType.getPackage() == null) {
                    BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)syntaxOwnerType, ctx.getGroupId(), new String[]{typeName});
                    validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().UNKNOWN_TYPE_NOT_IN_TYPE_SPACE, ruleCtx);
                    ctx.addUnresolvedType(typeName);
                    return false;
                }
                if (ctx.getDependencyVerifier(syntaxOwnerType).verify(syntaxOwnerType, typeName)) continue;
                if (typeName.length() > 0) {
                    BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)syntaxOwnerType, ctx.getGroupId(), new String[]{typeName});
                    validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().UNKNOWN_TYPE_NOT_IN_TYPE_SPACE_INACTIVENEEDS, ruleCtx);
                }
                ctx.addUnresolvedType(typeName);
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSyntaxCorrect(VjoSemanticValidator validator, VjoValidationCtx ctx, MtdInvocationExpr mtdExpr, Map<VjoUniqueMethodEnum, Integer> methodCountMap, Map<String, SimpleLiteral> nameSpace) {
        IJstMethod mtdSymbol;
        if (mtdExpr == null) {
            return true;
        }
        IExpr qualifier = mtdExpr.getQualifyExpr();
        IExpr identifier = mtdExpr.getMethodIdentifier();
        IJstType syntaxOwnerType = ctx.getScope().getClosestTypeScopeNode();
        if (qualifier instanceof JstIdentifier) {
            String typeName;
            VjoUniqueMethodEnum mtdEnum;
            block21: {
                IJstMethod mtdSymbol2;
                IJstType vjo = qualifier.getResultType();
                if (vjo == null) {
                    return false;
                }
                if (!(identifier instanceof JstIdentifier)) {
                    return false;
                }
                IJstType vjoType = vjo;
                String mtdId = ((JstIdentifier)identifier).getName();
                IJstMethod iJstMethod = mtdSymbol2 = vjoType instanceof IJstRefType ? ((IJstRefType)vjoType).getReferencedNode().getMethod(mtdId, true, true) : vjoType.getMethod(mtdId, false, true);
                if (mtdSymbol2 == null) {
                    return false;
                }
                try {
                    IExpr arg;
                    List args;
                    mtdEnum = VjoUniqueMethodEnum.valueOf(mtdId);
                    if (mtdEnum == null) return true;
                    methodCountMap.put(mtdEnum, methodCountMap.get((Object)mtdEnum) + 1);
                    if (!VjoUniqueMethodEnum.ctype.equals((Object)mtdEnum) && !VjoUniqueMethodEnum.itype.equals((Object)mtdEnum) && !VjoUniqueMethodEnum.etype.equals((Object)mtdEnum) && !VjoUniqueMethodEnum.mtype.equals((Object)mtdEnum) && !VjoUniqueMethodEnum.otype.equals((Object)mtdEnum) || (args = mtdExpr.getArgs()).size() < 1 || !((arg = (IExpr)args.get(0)) instanceof SimpleLiteral) || (typeName = ((SimpleLiteral)arg).getValue()) == null || typeName.length() <= 0) return true;
                    if (ctx.getJstTypeNames().size() != 0) break block21;
                    ctx.addJstTypeName(typeName);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
            if (typeName.startsWith("<") && typeName.endsWith(">") && (VjoUniqueMethodEnum.ctype.equals((Object)mtdEnum) || VjoUniqueMethodEnum.itype.equals((Object)mtdEnum))) return true;
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)identifier, ctx.getGroupId(), new String[]{typeName, mtdExpr.toExprText()});
            validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().VJO_SYNTAX_CORRECTNESS, ruleCtx);
            return true;
        }
        if (!(qualifier instanceof MtdInvocationExpr)) return false;
        if (!VjoJstBlockValidator.isSyntaxCorrect(validator, ctx, (MtdInvocationExpr)qualifier, methodCountMap, nameSpace)) {
            return false;
        }
        IJstType qualifierType = qualifier.getResultType();
        if (qualifierType == null) {
            return false;
        }
        if (!(identifier instanceof JstIdentifier)) {
            return false;
        }
        String mtdId = ((JstIdentifier)identifier).getName();
        IJstMethod iJstMethod = mtdSymbol = qualifierType instanceof IJstRefType ? ((IJstRefType)qualifierType).getReferencedNode().getMethod(mtdId, true, true) : qualifierType.getMethod(mtdId, false, true);
        if (mtdSymbol == null) {
            return false;
        }
        try {
            IExpr optionalArg;
            VjoUniqueMethodEnum mtdEnum = VjoUniqueMethodEnum.valueOf(mtdId);
            if (mtdEnum != null) {
                methodCountMap.put(mtdEnum, methodCountMap.get((Object)mtdEnum) + 1);
            }
            if (!VjoUniqueMethodEnum.needs.equals((Object)mtdEnum) && !VjoUniqueMethodEnum.inherits.equals((Object)mtdEnum) && !VjoUniqueMethodEnum.satisfies.equals((Object)mtdEnum) && !VjoUniqueMethodEnum.mixin.equals((Object)mtdEnum) && !VjoUniqueMethodEnum.defs.equals((Object)mtdEnum) && !VjoUniqueMethodEnum.expects.equals((Object)mtdEnum)) return true;
            List arguments = mtdExpr.getArgs();
            IVjoDependencyVerifiable depTypes = ctx.getDependencyVerifier(syntaxOwnerType);
            if (arguments == null || arguments.size() <= 0) return true;
            IExpr arg = (IExpr)arguments.get(0);
            IExpr iExpr = optionalArg = arguments.size() > 1 ? (IExpr)arguments.get(1) : null;
            if (arg instanceof SimpleLiteral) {
                VjoJstBlockValidator.validateArgument(validator, ctx, nameSpace, syntaxOwnerType, mtdEnum, depTypes, arg, optionalArg);
                return true;
            } else if (arg instanceof ArrayLiteral) {
                Iterator elemIt = ((ArrayLiteral)arg).getValues();
                while (elemIt.hasNext()) {
                    IExpr elemExpr = (IExpr)elemIt.next();
                    if (!SimpleLiteral.class.isAssignableFrom(elemExpr.getClass())) continue;
                    VjoJstBlockValidator.validateArgument(validator, ctx, nameSpace, syntaxOwnerType, mtdEnum, depTypes, elemExpr, optionalArg);
                }
                return true;
            } else {
                if (!(arg instanceof JstArrayInitializer)) return true;
                for (IExpr elemExpr : ((JstArrayInitializer)arg).getExprs()) {
                    if (!SimpleLiteral.class.isAssignableFrom(elemExpr.getClass())) continue;
                    VjoJstBlockValidator.validateArgument(validator, ctx, nameSpace, syntaxOwnerType, mtdEnum, depTypes, elemExpr, optionalArg);
                }
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static void validateArgument(VjoSemanticValidator validator, VjoValidationCtx ctx, Map<String, SimpleLiteral> nameSpace, IJstType syntaxOwnerType, VjoUniqueMethodEnum mtdEnum, IVjoDependencyVerifiable depVerifier, IExpr arg, IExpr optionalArg) {
        String name = ((SimpleLiteral)arg).getValue();
        int templateIndex = name.indexOf("<");
        if (templateIndex > 0) {
            name = name.substring(0, templateIndex);
        }
        String simpleName = VjoJstBlockValidator.getSimpleName(name, optionalArg);
        TypeNameShouldNotBeEmptyRuleCtx notEmptyTypeNameruleCtx = new TypeNameShouldNotBeEmptyRuleCtx((IJstNode)arg, ctx.getGroupId(), new String[]{simpleName}, simpleName);
        validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().TYPE_NAME_SHOULD_NOT_BE_EMPTY, notEmptyTypeNameruleCtx);
        if (nameSpace.containsKey(simpleName)) {
            if (!name.equals(nameSpace.get(simpleName).getValue())) {
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)arg, ctx.getGroupId(), new String[]{nameSpace.get(simpleName).getValue(), name});
                validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().NAME_SPACE_COLLISION, ruleCtx);
            } else if (VjoUniqueMethodEnum.needs.equals((Object)mtdEnum)) {
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)arg, ctx.getGroupId(), new String[]{syntaxOwnerType.getName(), name});
                validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().REDUNDANT_IMPORT, ruleCtx);
            } else {
                IJstNode argPrev = (IJstNode)nameSpace.get(simpleName);
                if (argPrev != null) {
                    IExpr mtdInvocationExprId;
                    if (argPrev.getParentNode() != null && argPrev.getParentNode() instanceof JstArrayInitializer) {
                        argPrev = argPrev.getParentNode();
                    }
                    if (argPrev.getParentNode() != null && argPrev.getParentNode() instanceof MtdInvocationExpr && (mtdInvocationExprId = ((MtdInvocationExpr)argPrev.getParentNode()).getMethodIdentifier()) != null && mtdInvocationExprId instanceof JstIdentifier) {
                        if (VjoUniqueMethodEnum.needs.name().equals(((JstIdentifier)mtdInvocationExprId).getName())) {
                            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)nameSpace.get(simpleName), ctx.getGroupId(), new String[]{syntaxOwnerType.getName(), name});
                            validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().REDUNDANT_IMPORT, ruleCtx);
                        } else if (mtdEnum.name().equals(((JstIdentifier)mtdInvocationExprId).getName())) {
                            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)arg, ctx.getGroupId(), new String[]{syntaxOwnerType.getName(), name});
                            validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().REDUNDANT_IMPORT, ruleCtx);
                        }
                    }
                    nameSpace.put(simpleName, (SimpleLiteral)arg);
                }
            }
        } else {
            nameSpace.put(simpleName, (SimpleLiteral)arg);
        }
        VjoJstBlockValidator.validateTypeResolution(validator, ctx, syntaxOwnerType, depVerifier, arg, name);
    }

    private static String getSimpleName(String name, IExpr optionalArgExpr) {
        String alias;
        if (name == null) {
            return "";
        }
        if (optionalArgExpr != null && SimpleLiteral.class.isAssignableFrom(optionalArgExpr.getClass()) && (alias = ((SimpleLiteral)optionalArgExpr).getValue()) != null) {
            return alias.length() == 0 ? name : alias;
        }
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex >= 0 && lastDotIndex < name.length() - 1) {
            return name.substring(lastDotIndex + 1);
        }
        return name;
    }

    private static enum VjoUniqueMethodEnum {
        ctype,
        make,
        itype,
        etype,
        mtype,
        otype,
        inherits,
        satisfies,
        expects,
        mixin,
        defs,
        values,
        options,
        props,
        protos,
        inits,
        endType,
        needs;

    }
}

