/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator.VjoMtdInvocationExprValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class VjoObjCreationExprValidator
extends VjoMtdInvocationExprValidator
implements IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();

    static {
        s_targetTypes.add(ObjCreationExpr.class);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        IExpr identifier;
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof ObjCreationExpr)) {
            return;
        }
        ObjCreationExpr expr = (ObjCreationExpr)jstNode;
        MtdInvocationExpr mtdInvocationExpr = expr.getInvocationExpr();
        if (mtdInvocationExpr != null && (identifier = mtdInvocationExpr.getMethodIdentifier()) != null) {
            if (identifier instanceof JstIdentifier) {
                JstIdentifier mtdIdentifier = (JstIdentifier)identifier;
                IJstNode mtdBinding = mtdIdentifier.getJstBinding();
                this.verifyConstructorBindings(ctx, expr, identifier, mtdIdentifier.getResultType(), mtdBinding);
            } else if (identifier instanceof FieldAccessExpr) {
                IJstType fieldAccessExprResultType = ((FieldAccessExpr)identifier).getResultType();
                IJstNode mtdBinding = ((FieldAccessExpr)identifier).getName().getJstBinding();
                this.verifyConstructorBindings(ctx, expr, identifier, fieldAccessExprResultType, mtdBinding);
            }
        }
    }

    private void verifyConstructorBindings(VjoValidationCtx ctx, ObjCreationExpr expr, IExpr identifier, IJstType bindingType, IJstNode mtdBinding) {
        if (bindingType == null || bindingType instanceof IInferred || "Object".equals(bindingType.getName()) || "type::Object".equals(bindingType.getName())) {
            return;
        }
        if ("vjo.Enum".equals(identifier.toExprText())) {
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{identifier.toExprText(), expr.toExprText()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CLASS_SHOULD_BE_INSTANTIATABLE, ruleCtx);
            return;
        }
        if (bindingType != null && (bindingType instanceof IJstRefType || bindingType instanceof JstFuncType || bindingType instanceof JstFunctionRefType || bindingType.isFType()) && !this.verifyTypeCategory(bindingType)) {
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{bindingType.getName(), expr.toExprText()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OBJ_SHOULD_BE_CLASS_TYPE, ruleCtx);
            return;
        }
        if (mtdBinding instanceof IJstType) {
            if (mtdBinding instanceof IJstRefType) {
                this.validateComplexType(ctx, (IJstNode)identifier, identifier.toExprText(), (IJstType)((IJstRefType)mtdBinding));
                if (!ctx.getMissingImportTypes().contains(((IJstRefType)mtdBinding).getReferencedNode()) && !ctx.getUnresolvedTypes().contains(((IJstRefType)mtdBinding).getReferencedNode().getName())) {
                    BaseVjoSemanticRuleCtx methodShouldBeDefinedCtx = new BaseVjoSemanticRuleCtx((IJstNode)identifier, ctx.getGroupId(), new String[]{"constructs", expr.toExprText()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_SHOULD_BE_DEFINED, methodShouldBeDefinedCtx);
                    return;
                }
            } else {
                this.validateComplexType(ctx, (IJstNode)identifier, identifier.toExprText(), (IJstType)mtdBinding);
                if (!ctx.getMissingImportTypes().contains(mtdBinding) && !ctx.getUnresolvedTypes().contains(((IJstType)mtdBinding).getName())) {
                    BaseVjoSemanticRuleCtx methodShouldBeDefinedCtx = new BaseVjoSemanticRuleCtx((IJstNode)identifier, ctx.getGroupId(), new String[]{"constructs", expr.toExprText()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_SHOULD_BE_DEFINED, methodShouldBeDefinedCtx);
                    return;
                }
            }
        } else if (mtdBinding instanceof JstConstructor) {
            JstMethod method;
            JstModifiers mtdModifiers;
            if (this.isAbstract(bindingType)) {
                boolean isValid = false;
                JstType callerType = expr.getOwnerType();
                if ((callerType == bindingType || JstTypeHelper.isTypeOf((IJstType)callerType, (IJstType)bindingType)) && this.isInsideConstructor(identifier)) {
                    isValid = true;
                }
                if (!isValid) {
                    BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{bindingType.getName(), expr.toExprText()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CLASS_SHOULD_BE_INSTANTIATABLE, ruleCtx);
                    return;
                }
            }
            if (!(mtdModifiers = (method = (JstMethod)mtdBinding).getModifiers()).isPublic()) {
                JstType callerType = expr.getOwnerType();
                JstType mtdOwnerType = method.getOwnerType();
                boolean isVisible = false;
                if (mtdModifiers.isPrivate()) {
                    if (callerType == mtdOwnerType || JstTypeHelper.hasSameRootType((IJstType)callerType, (IJstType)mtdOwnerType)) {
                        isVisible = true;
                    }
                } else if (mtdModifiers.isProtected()) {
                    if (callerType == mtdOwnerType || JstTypeHelper.isTypeOf((IJstType)callerType, (IJstType)mtdOwnerType)) {
                        isVisible = true;
                    }
                } else {
                    JstPackage callerPackage = JstTypeHelper.getTruePackage((IJstType)callerType);
                    JstPackage fieldOwnerPackage = JstTypeHelper.getTruePackage((IJstType)mtdOwnerType);
                    if (fieldOwnerPackage == null) {
                        isVisible = true;
                    } else if (callerPackage != null && callerPackage.getName().equals(fieldOwnerPackage.getName())) {
                        isVisible = true;
                    }
                }
                if (!isVisible) {
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CONSTRUCTOR_SHOULD_BE_VISIBLE, new BaseVjoSemanticRuleCtx((IJstNode)identifier, ctx.getGroupId(), new String[]{identifier.toExprText(), expr.toExprText()}));
                    return;
                }
            }
        } else if (mtdBinding == null) {
            if (bindingType instanceof IJstRefType) {
                if (bindingType.getPackage() != null && "VjoSelfDescribed".equals(bindingType.getPackage().getGroupName())) {
                    return;
                }
                this.validateComplexType(ctx, (IJstNode)identifier, identifier.toExprText(), (IJstType)((IJstRefType)bindingType));
                if (!ctx.getMissingImportTypes().contains(((IJstRefType)bindingType).getReferencedNode()) && !ctx.getUnresolvedTypes().contains(((IJstRefType)bindingType).getReferencedNode().getName())) {
                    BaseVjoSemanticRuleCtx methodShouldBeDefinedCtx = new BaseVjoSemanticRuleCtx((IJstNode)identifier, ctx.getGroupId(), new String[]{"constructs", expr.toExprText()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_SHOULD_BE_DEFINED, methodShouldBeDefinedCtx);
                    return;
                }
            } else {
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), new String[]{bindingType.getName(), expr.toExprText()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CLASS_SHOULD_BE_INSTANTIATABLE, ruleCtx);
                return;
            }
        }
    }

    private boolean verifyTypeCategory(IJstType bindingTypeCheck) {
        return bindingTypeCheck.isClass() || bindingTypeCheck.isEnum();
    }

    private boolean isAbstract(IJstType mtdOwnerType) {
        JstPackage pkg = mtdOwnerType.getPackage();
        if (pkg != null && "JsNativeLib".equals(pkg.getGroupName())) {
            return false;
        }
        return mtdOwnerType.getModifiers().isAbstract();
    }

    private boolean isInsideConstructor(IExpr mtdInvocationExpr) {
        IJstNode parent = mtdInvocationExpr.getParentNode();
        while (parent != null) {
            if (parent instanceof JstConstructor) {
                return true;
            }
            if (parent instanceof IJstType) {
                return false;
            }
            parent = parent.getParentNode();
        }
        return false;
    }
}

