/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class VjoObjLiteralValidator
extends VjoSemanticValidator
implements IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();

    static {
        s_targetTypes.add(ObjLiteral.class);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof ObjLiteral)) {
            return;
        }
        ObjLiteral objLiteral = (ObjLiteral)jstNode;
        HashSet<String> nameSet = new HashSet<String>();
        for (NV nv : objLiteral.getNVs()) {
            if (nameSet.contains(nv.getName())) {
                String[] arguments = new String[]{nv.getName() != null ? nv.getName() : "NULL", objLiteral.toExprText()};
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)nv.getIdentifier(), ctx.getGroupId(), arguments);
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OBJECT_LITERAL_SHOULD_HAVE_UNIQUE_KEY, ruleCtx);
            }
            nameSet.add(nv.getName());
            if (this.isJavaKeyword(nv.getName())) {
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)nv, ctx.getGroupId(), new String[]{nv.getName(), nv.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().VJO_SYNTAX_CORRECTNESS, ruleCtx);
            }
            JstIdentifier name = nv.getIdentifier();
            IExpr value = nv.getValue();
            this.validateNVTypes(ctx, nv, name, value);
        }
        this.validateComplexType(ctx, (IJstNode)objLiteral, objLiteral.toExprText(), objLiteral.getResultType());
    }

    private void validateNVTypes(VjoValidationCtx ctx, NV nv, JstIdentifier name, IExpr value) {
        if (name != null && name.getType() != null && value != null && value.getResultType() != null && !TypeCheckUtil.isAssignable(name.getType(), value.getResultType())) {
            String[] arguments = new String[]{name.getType().getName(), value.toExprText(), nv.toString()};
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)name, ctx.getGroupId(), arguments);
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ASSIGNABLE, ruleCtx);
        }
    }
}

