/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.vjo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.BaseGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.CastExpr;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class JsDocGenerator
extends BaseGenerator {
    public static final String DOT = ".";
    public static final String TYPE_REF_PREFIX = "type::";
    private List<IJstMethod> m_methodsWritten = new ArrayList<IJstMethod>();

    public JsDocGenerator(GeneratorCtx ctx) {
        super(ctx);
    }

    public void writeJsDoc(IJstType type) {
        JstModifiers modifiers = type.getModifiers();
        boolean hasParams = type.getParamTypes().size() > 0;
        this.getWriter().append(" ");
        this.startWriteJsDoc(false);
        this.writeJsDocAccessScope(modifiers.getAccessScope());
        if (modifiers.isDynamic()) {
            this.getWriter().append(" ").append("dynamic");
        }
        if (modifiers.isFinal() && !type.isEnum()) {
            this.getWriter().append(" ").append(JsCoreKeywords.EXT_FINAL);
        }
        if (modifiers.isAbstract()) {
            this.getWriter().append(" ").append(JsCoreKeywords.EXT_ABSTRACT);
        }
        if (hasParams && type.isEmbededType()) {
            this.writeJsDocName(type.getSimpleName());
            this.writeParamTypes(type);
        }
    }

    public void writeParamTypes(IJstType type) {
        List params = type.getParamTypes();
        int len = params.size();
        if (len > 0) {
            this.getWriter().append("<");
            int i = 0;
            while (i < len) {
                JstParamType ptype = (JstParamType)params.get(i);
                this.getWriter().append(ptype.getSimpleName());
                this.writeParamBounds(ptype.getBounds());
                if (i < len - 1) {
                    this.getWriter().append(",");
                }
                ++i;
            }
            this.getWriter().append(">");
        }
    }

    private void writeParamBounds(List<IJstType> bounds) {
        if (bounds != null && bounds.size() > 0) {
            int len = bounds.size();
            this.getWriter().append(" extends ");
            int i = 0;
            while (i < len) {
                IJstType bound = bounds.get(i);
                this.getWriter().append(bound.getSimpleName());
                if (bound.getParamNames().size() > 0) {
                    boolean first = true;
                    this.getWriter().append("<");
                    for (String pName : bound.getParamNames()) {
                        if (!first) {
                            this.getWriter().append(",");
                        }
                        this.getWriter().append(pName);
                        first = false;
                    }
                    this.getWriter().append(">");
                }
                if (i < len - 1) {
                    this.getWriter().append(",");
                }
                ++i;
            }
        }
    }

    public void writeJsDoc(IJstMethod mtd, String access, String name) {
        this.startWriteJsDoc();
        if (mtd.isFinal()) {
            this.getWriter().append(" ").append(JsCoreKeywords.EXT_FINAL);
        }
        this.writeJsDocAccessScope(access);
        if (mtd.getModifiers().isAbstract()) {
            this.getWriter().append(" ").append(JsCoreKeywords.EXT_ABSTRACT);
        }
        this.writeVjetDocRawMtd(mtd, name);
    }

    public void writeVjetDocRawMtd(IJstMethod mtd, String name) {
        IJstType root = this.getType((IJstNode)mtd);
        if (mtd.isOType() && mtd instanceof JstMethod) {
            JstMethod meth = (JstMethod)mtd;
            this.getWriter().append(" ").append(meth.getOType().getName());
            return;
        }
        this.appendParameters(mtd);
        IJstType rtnType = mtd.getRtnType();
        if (rtnType != null && !mtd.isConstructor()) {
            this.getWriter().append(" ");
            if (mtd.isTypeFactoryEnabled()) {
                this.getWriter().append("^");
            }
            this.writeJsDocReturnType(this.getName(rtnType, root));
            if (rtnType instanceof JstTypeWithArgs) {
                this.appendArguments((JstTypeWithArgs)rtnType);
            }
        }
        this.getWriter().append(" ");
        if (mtd.isFuncArgMetaExtensionEnabled()) {
            this.getWriter().append("^");
        }
        this.getWriter().append(name);
        this.writeJsDocParamType(mtd, root);
        this.m_methodsWritten.add(mtd);
    }

    public void writeJsDoc(IJstMethod mtd, String access) {
        this.writeJsDoc(mtd, access, mtd.getName().getName());
    }

    public void writeJsDoc(IJstMethod mtd) {
        JstModifiers modifiers = mtd.getModifiers();
        String access = modifiers.getAccessScope();
        if (this.isHelperMethod(mtd)) {
            access = !modifiers.isFinal() && (modifiers.isPublic() || modifiers.isProtected()) ? JsCoreKeywords.EXT_PROTECTED : JsCoreKeywords.EXT_PRIVATE;
        }
        this.writeJsDoc(mtd, access);
    }

    public void writeJsDoc(IJstProperty pty) {
        if (pty instanceof ISynthesized) {
            return;
        }
        this.getWriter().append(" ");
        this.startWriteJsDoc(false);
        IJstType root = this.getType((IJstNode)pty);
        this.writeJsDocAccessScope(pty.getModifiers().getAccessScope());
        if (pty.isFinal()) {
            this.getWriter().append(" ").append(JsCoreKeywords.EXT_FINAL);
        }
        this.writeJsDocName(this.getName(pty.getType(), root));
        if (pty.getType() instanceof JstTypeWithArgs) {
            this.appendArguments((JstTypeWithArgs)pty.getType());
            this.writeJsDocName(pty.getName().getName());
        }
    }

    public void writeJsDocForArg(IExpr expr) {
        if (expr instanceof CastExpr) {
            this.getWriter().append("/*>").append(">").append("*/");
        }
    }

    public void writeJsDoc(AssignExpr assign, boolean forceType) {
        IExpr expr = assign.getExpr();
        if (expr instanceof CastExpr) {
            CastExpr cast = (CastExpr)expr;
            this.getWriter().append(" ");
            this.startWriteJsDoc(false);
            this.getWriter().append("<");
            this.writeType(cast.getResultType());
        } else if (forceType) {
            this.getWriter().append(" ");
            this.startWriteJsDoc(false);
            this.writeType(assign.getLHS().getType());
        }
    }

    public void writeJsDoc(IExpr expr, boolean forceType) {
        if (expr == null) {
            return;
        }
        if (expr instanceof CastExpr) {
            CastExpr cast = (CastExpr)expr;
            this.getWriter().append(" ");
            this.startWriteJsDoc(false);
            this.getWriter().append("<");
            this.writeType(cast.getResultType());
        } else if (forceType) {
            this.getWriter().append(" ");
            this.startWriteJsDoc(false);
            if (expr.getResultType() instanceof JstArray) {
                this.writeType(expr.getResultType());
            }
        }
    }

    private void writeType(IJstType type) {
        if (type != null) {
            String typeName = DataTypeHelper.getTypeName((String)type.getName());
            if (typeName.equals(type.getName())) {
                typeName = this.isInnerType(type) ? this.getSimpleNameForInner(type) : type.getSimpleName();
            }
            this.getWriter().append(typeName);
        }
    }

    public void writeJsDoc(JstVars vars) {
        AssignExpr assignExpr;
        List assigns;
        int size;
        JstInitializer inits = vars.getInitializer();
        if (inits != null && (size = (assigns = inits.getAssignments()).size()) > 0 && (assignExpr = (AssignExpr)assigns.get(size - 1)).getExpr() instanceof CastExpr) {
            this.writeJsDoc(assignExpr, true);
            return;
        }
        IJstType varType = vars.getType();
        if (varType != null && !(varType instanceof IInferred) && !"Object".equals(varType.getSimpleName())) {
            this.getWriter().append(" ");
            this.startWriteJsDoc(false);
            this.writeType(varType);
        }
    }

    protected void writeJsDocName(String name) {
        this.getWriter().append(" ").append(name);
    }

    protected void startWriteJsDoc() {
        this.startWriteJsDoc(true);
    }

    private void startWriteJsDoc(boolean forward) {
        if (forward) {
            this.writeNewline();
            this.writeIndent();
            this.getWriter().append("//>");
        } else {
            this.getWriter().append("//<");
        }
    }

    protected void writeJsDocParamType(IJstMethod mtd, IJstType root) {
        List args = mtd.getArgs();
        this.getWriter().append('(');
        int index = 0;
        for (JstArg arg : args) {
            if (arg == null || arg.getType() == null) continue;
            if (index > 0) {
                this.getWriter().append(',');
            }
            if (arg.isFinal()) {
                this.getWriter().append("final").append(" ");
            }
            if (arg.getTypeRef() instanceof IJstRefType) {
                this.getWriter().append(TYPE_REF_PREFIX);
            }
            if (arg.getTypes().size() == 1) {
                this.getWriter().append(this.getName(arg.getType(), root));
            } else {
                this.getWriter().append('{');
                int i = 0;
                while (i < arg.getTypes().size()) {
                    IJstType type = (IJstType)arg.getTypes().get(i);
                    this.getWriter().append(this.getName(type, root));
                    if (i != arg.getTypes().size() - 1) {
                        this.getWriter().append('|');
                    }
                    ++i;
                }
                this.getWriter().append('}');
            }
            if (arg.getType() instanceof JstTypeWithArgs) {
                this.appendArguments((JstTypeWithArgs)arg.getType());
            }
            if (arg.isVariable()) {
                this.getWriter().append("...");
            } else if (arg.isOptional()) {
                this.getWriter().append("?");
            }
            this.getWriter().append(" ");
            this.getWriter().append(arg.getName());
            ++index;
        }
        this.getWriter().append(')');
    }

    protected void writeJsDocReturnType(String type) {
        if ("Void".equals(type)) {
            this.getWriter().append("void");
        } else {
            String name = type;
            boolean isA = false;
            if (type.endsWith("[]")) {
                name = name.substring(0, type.indexOf("[]"));
                isA = true;
            }
            String s = DataTypeHelper.getTypeName((String)name);
            this.getWriter().append(String.valueOf(s) + (isA ? "[]" : ""));
        }
    }

    protected void writeJsDocAccessScope(String scope) {
        if (scope != null && scope.length() > 0) {
            this.getWriter().append(" ");
        }
        this.getWriter().append(scope);
    }

    private void appendArguments(JstTypeWithArgs pType) {
        if (!pType.getArgTypes().isEmpty()) {
            this.getWriter().append(pType.getArgsDecoration());
        }
    }

    private void appendParameters(IJstMethod mtd) {
        if (!mtd.getParamTypes().isEmpty()) {
            this.getWriter().append(" ").append(((JstMethod)mtd).getParamsDecoration());
        }
    }

    private String getName(IJstType type, IJstType root) {
        String name = type.getSimpleName();
        boolean isN = this.isNeed(type.getName(), root);
        if (!"vjo.Object".equals(type.getName()) && (this.getCtx().getConfig().getFilters().isJavaPrimitiveOrWrapper(name) || isN)) {
            if (isN && type != null) {
                IJstType imT = root.getImport(type.getName());
                if (imT == null) {
                    imT = root.getInactiveImport(type.getName());
                }
                if (imT != null && type.getName().equals(imT.getAlias())) {
                    name = type.getName();
                }
            }
            if (this.isInnerType(type)) {
                return this.getSimpleNameForInner(type);
            }
            if (!(isN || type.getPackage() == null || type.getName().startsWith("java.lang") || type.getName().startsWith("org.eclipse.vjet.dsf.jsnative.global"))) {
                return type.getName();
            }
            return name;
        }
        if (this.isInnerType(type)) {
            return this.getSimpleNameForInner(type);
        }
        if (type.getPackage() != null) {
            String otype = this.getOTypeContainer(root, type.getPackage().getName());
            if (otype != null) {
                return String.valueOf(otype) + DOT + name;
            }
            if (type instanceof JstFuncType) {
                this.getWriter().append("(");
                IJstMethod mtd = ((JstFuncType)type).getFunction();
                this.writeVjetDocRawMtd(mtd, mtd.getName().getName());
                this.getWriter().append(")");
                return "";
            }
        }
        return DataTypeHelper.getTypeName((String)type.getName());
    }

    private boolean isInnerType(IJstType type) {
        return type != null && type.getOuterType() != null && type != type.getRootType();
    }

    private String getSimpleNameForInner(IJstType type) {
        String s = type.getSimpleName();
        IJstType root = type.getRootType();
        IJstType tmp = type;
        while (!tmp.equals(root) && tmp.getOuterType() != null) {
            tmp = tmp.getOuterType();
            if (s.length() > 0) {
                s = DOT + s;
            }
            s = String.valueOf(tmp.getSimpleName()) + s;
        }
        return s;
    }

    private String getOTypeContainer(IJstType type, String name) {
        if (type == null || type.getInactiveImports() == null) {
            return null;
        }
        for (IJstType need : type.getInactiveImports()) {
            if (!name.equals(need.getName())) continue;
            return need.getSimpleName();
        }
        return null;
    }

    private boolean isNeed(String name, IJstType root) {
        if (root == null) {
            return false;
        }
        List list = root.getImports();
        if (this.compare(name, root)) {
            return true;
        }
        for (IJstType type : list) {
            if (!this.compare(name, type)) continue;
            return true;
        }
        list = root.getInactiveImports();
        for (IJstType type : list) {
            if (!this.compare(name, type)) continue;
            return true;
        }
        return false;
    }

    private boolean compare(String name, IJstType type) {
        String typeName = type.getName();
        return name.equals(typeName) || name.startsWith(String.valueOf(typeName) + DOT) || name.startsWith(String.valueOf(typeName) + "[");
    }

    private IJstType getType(IJstNode mtd) {
        IJstNode type = mtd;
        while (type.getParentNode() != null) {
            type = type.getParentNode();
        }
        if (type instanceof IJstType) {
            return (IJstType)type;
        }
        return null;
    }

    private boolean isWritten(IJstMethod target) {
        for (IJstMethod method : this.m_methodsWritten) {
            if (!this.isEqual(method, target)) continue;
            return true;
        }
        return false;
    }

    private boolean isEqual(IJstMethod source, IJstMethod target) {
        int targetParamsCount;
        List sourceParams = source.getArgs();
        List targetParams = target.getArgs();
        int sourceParamsCount = sourceParams.size();
        if (sourceParamsCount == (targetParamsCount = targetParams.size())) {
            int i = 0;
            while (i < sourceParamsCount) {
                JstArg sourceArg = (JstArg)sourceParams.get(i);
                JstArg targetArg = (JstArg)targetParams.get(i);
                if (sourceArg == null && targetArg != null) {
                    return false;
                }
                if (sourceArg != null && targetArg == null) {
                    return false;
                }
                if (!sourceArg.getType().equals(targetArg.getType())) {
                    return false;
                }
                ++i;
            }
        }
        if (!source.getName().getName().equals(target.getName().getName())) {
            return false;
        }
        if (sourceParamsCount != targetParamsCount) {
            return false;
        }
        if (source instanceof JstMethod && target instanceof JstConstructor) {
            return false;
        }
        if (source instanceof JstConstructor && target instanceof JstMethod) {
            return false;
        }
        if (!source.getModifiers().getAccessScope().equals(target.getModifiers().getAccessScope())) {
            return false;
        }
        return source.getRtnType() == null || target.getRtnType() == null || source.getRtnType().equals(target.getRtnType());
    }

    private boolean isHelperMethod(IJstMethod mtd) {
        if (mtd.getName() == null || mtd.getOriginalName() == null) {
            return false;
        }
        return !mtd.getName().getName().equals(mtd.getOriginalName());
    }
}

