/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public final class JstLib
implements IJstLib {
    private String m_name;
    private Map<String, JstType> m_types = new HashMap<String, JstType>();
    private Map<String, IJstLib> m_libs = new HashMap<String, IJstLib>();
    private Manifest m_manifest = null;

    public JstLib(String name) {
        assert (name != null) : "name cannot be null";
        this.m_name = name;
    }

    public JstLib(String name, Manifest mf) {
        assert (name != null) : "name cannot be null";
        this.m_name = name;
        this.m_manifest = mf;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public JstType getType(String typeName, boolean recursive) {
        JstType type = this.m_types.get(typeName);
        if (type == null && recursive) {
            for (IJstLib lib : this.m_libs.values()) {
                type = lib.getType(typeName, recursive);
                if (type == null) continue;
                return type;
            }
        }
        return type;
    }

    @Override
    public IJstLib getLib(String libName, boolean recursive) {
        IJstLib lib = this.m_libs.get(libName);
        if (lib == null && recursive) {
            for (IJstLib l : this.m_libs.values()) {
                lib = l.getLib(libName, recursive);
                if (lib == null) continue;
                return lib;
            }
        }
        return lib;
    }

    @Override
    public List<JstType> getAllTypes(boolean recursive) {
        ArrayList<JstType> list = new ArrayList<JstType>();
        list.addAll(this.m_types.values());
        if (recursive) {
            for (IJstLib lib : this.m_libs.values()) {
                list.addAll(lib.getAllTypes(recursive));
            }
        }
        return list;
    }

    @Override
    public List<IJstLib> getAllLibs(boolean recursive) {
        ArrayList<IJstLib> list = new ArrayList<IJstLib>();
        list.addAll(this.m_libs.values());
        if (recursive) {
            for (IJstLib lib : this.m_libs.values()) {
                list.addAll(lib.getAllLibs(recursive));
            }
        }
        return list;
    }

    public JstLib addType(JstType type) {
        assert (type != null) : "type cannot be null";
        this.m_types.put(type.getName(), type);
        return this;
    }

    public JstLib addLib(IJstLib lib) {
        assert (lib != null) : "lib cannot be null";
        this.m_libs.put(lib.getName(), lib);
        return this;
    }

    public JstLib addTypes(List<IJstType> jstTypes) {
        assert (jstTypes != null) : "type cannot be null";
        for (IJstType type : jstTypes) {
            this.addType((JstType)type);
        }
        return this;
    }

    @Override
    public Manifest getManifest() {
        return this.m_manifest;
    }
}

