/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeRefType;

public class JstFactory {
    private JstCache m_cache = JstCache.getInstance();
    private static JstFactory s_instance = new JstFactory();

    private JstFactory() {
    }

    public static JstFactory getInstance() {
        return s_instance;
    }

    public synchronized JstType createJstType(boolean cacheIt) {
        JstType type = new JstType();
        if (cacheIt) {
            this.m_cache.addType(type);
        }
        return type;
    }

    public synchronized JstType createJstType(String name, boolean cacheIt) {
        JstType type = new JstType(name);
        if (cacheIt) {
            this.m_cache.addType(type);
        }
        return type;
    }

    public synchronized JstType createJstType(JstPackage pkg, String name, boolean cacheIt) {
        JstType type = new JstType(pkg, name);
        if (cacheIt) {
            this.m_cache.addType(type);
        }
        return type;
    }

    @Deprecated
    public JstPackage createPackage(String fullName) {
        return new JstPackage(fullName);
    }

    @Deprecated
    public JstRefType createJstRefType(Class refType, String name, boolean primitive, boolean isArray) {
        JstRefType type = new JstRefType(refType, name, primitive, isArray);
        this.m_cache.addRefType(name, type);
        return type;
    }

    public JstRefType createJstRefType(String name, boolean primitive, boolean isArray, boolean cacheIt) {
        JstRefType type = new JstRefType(name, primitive, isArray);
        if (cacheIt) {
            this.m_cache.addRefType(type);
        }
        return type;
    }

    public JstArray createJstArrayType(IJstType elementType, boolean cacheIt) {
        if (elementType == null) {
            throw new IllegalArgumentException();
        }
        JstArray type = this.createJstArray(elementType);
        if (cacheIt) {
            this.m_cache.addType(type);
        }
        return type;
    }

    public IJstRefType createJstTypeRefType(IJstType type) {
        JstTypeRefType jstTypeRefType = new JstTypeRefType(type);
        this.m_cache.addTypeRefType(jstTypeRefType);
        return jstTypeRefType;
    }

    private JstArray createJstArray(IJstType componentType) {
        return new JstArray(componentType);
    }
}

