/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeMixer;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstInferredType
extends JstProxyType
implements IInferred {
    private static final long serialVersionUID = 1L;
    private transient List<TypeMeta> m_modifiedTypes = null;
    private transient TypeMeta m_defaultMeta;
    private boolean m_modified = false;

    public JstInferredType(IJstType targetType) {
        super(targetType);
        this.m_defaultMeta = new TypeMeta(targetType, 0, null);
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
    }

    public boolean modified() {
        return this.m_modified;
    }

    public IJstType getCurrentType(int pos, Set<?> scopes) {
        return this.getMeta(pos, scopes).getType(pos);
    }

    public void setCurrentType(IJstType type, int pos, Object scope) {
        this.m_modified = true;
        List<TypeMeta> list = this.getModifiedTypes();
        list.add(new TypeMeta(type, pos, scope));
        Collections.sort(list);
    }

    public void addNewProperty(String name, IJstType type, int pos, Set<?> scopes) {
        this.m_modified = true;
        TypeMeta meta = this.getMeta(pos, scopes);
        JstProperty node = new JstProperty(type, name);
        node.getModifiers().setPublic();
        meta.addProperties(pos, node);
    }

    private TypeMeta getMeta(int pos, Set<?> scopes) {
        if (this.m_modifiedTypes == null) {
            if (this.m_defaultMeta == null) {
                this.m_defaultMeta = new TypeMeta(this.getType(), 0, null);
            }
            return this.m_defaultMeta;
        }
        int candidate = -1;
        int i = 0;
        while (i < this.m_modifiedTypes.size()) {
            TypeMeta meta = this.m_modifiedTypes.get(i);
            if (scopes.contains(meta.m_scope)) {
                if (pos < meta.m_pos) break;
                candidate = i;
            }
            ++i;
        }
        if (candidate == -1) {
            return this.m_defaultMeta;
        }
        return this.m_modifiedTypes.get(candidate);
    }

    private synchronized List<TypeMeta> getModifiedTypes() {
        if (this.m_modifiedTypes == null) {
            this.m_modifiedTypes = new ArrayList<TypeMeta>(3);
        }
        return this.m_modifiedTypes;
    }

    public static class AugmentedType
    extends JstTypeMixer
    implements IInferred {
        private static final long serialVersionUID = 1L;

        protected AugmentedType(IJstType targetType, IJstType extraType) {
            super(String.valueOf(targetType.getName()) + "(+)");
            this.addExtend(targetType);
            this.m_types = new ArrayList(2);
            this.m_types.add(targetType);
            this.m_types.add(extraType);
        }
    }

    private static class TypeMeta
    implements Comparable<TypeMeta> {
        private int m_pos;
        private IJstType m_type;
        private Object m_scope;
        private Map<Integer, IJstProperty> m_extraProps = null;

        TypeMeta(IJstType type, int pos, Object scope) {
            this.m_type = type;
            this.m_pos = pos;
            this.m_scope = scope;
        }

        @Override
        public int compareTo(TypeMeta o) {
            if (this.m_pos == o.m_pos) {
                return 0;
            }
            if (this.m_pos > o.m_pos) {
                return 1;
            }
            return -1;
        }

        void addProperties(int pos, IJstProperty node) {
            if (this.m_extraProps == null) {
                this.m_extraProps = new LinkedHashMap<Integer, IJstProperty>();
            }
            this.m_extraProps.put(pos, node);
        }

        IJstType getType(int pos) {
            if (this.m_extraProps == null) {
                return this.m_type;
            }
            ArrayList<IJstProperty> props = new ArrayList<IJstProperty>();
            for (Map.Entry<Integer, IJstProperty> entry : this.m_extraProps.entrySet()) {
                if (entry.getKey() > pos) break;
                props.add(entry.getValue());
            }
            if (props.isEmpty()) {
                return this.m_type;
            }
            JstType extraType = new JstType("");
            for (IJstProperty prop : props) {
                extraType.addProperty(prop);
            }
            return new AugmentedType(this.m_type, extraType);
        }
    }
}

